/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.maven;

import io.spring.gradle.dependencymanagement.org.apache.maven.model.Model;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelBuildingRequest;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelProblemCollector;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.validation.DefaultModelValidator;
import org.gradle.api.Action;

class RelaxedModelValidator
extends DefaultModelValidator {
    RelaxedModelValidator() {
    }

    @Override
    public void validateRawModel(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        this.withNoDistributionManagementStatus(model, (Action<Model>)((Action)modifiedModel -> RelaxedModelValidator.super.validateRawModel(modifiedModel, request, problems)));
    }

    @Override
    public void validateEffectiveModel(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        this.withNoDistributionManagementStatus(model, (Action<Model>)((Action)modifiedModel -> RelaxedModelValidator.super.validateEffectiveModel(modifiedModel, request, problems)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withNoDistributionManagementStatus(Model model, Action<Model> action) {
        if (model.getDistributionManagement() != null) {
            String status = model.getDistributionManagement().getStatus();
            model.getDistributionManagement().setStatus(null);
            try {
                action.execute((Object)model);
            }
            finally {
                model.getDistributionManagement().setStatus(status);
            }
        } else {
            action.execute((Object)model);
        }
    }
}

