/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.bridge;

import io.spring.gradle.dependencymanagement.dsl.DependencyManagementExtension;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementApplier;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementConfigurationContainer;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementContainer;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementSettings;
import io.spring.gradle.dependencymanagement.internal.ImplicitDependencyManagementCollector;
import io.spring.gradle.dependencymanagement.internal.dsl.StandardDependencyManagementExtension;
import io.spring.gradle.dependencymanagement.internal.maven.MavenPomResolver;
import io.spring.gradle.dependencymanagement.internal.report.DependencyManagementReportTask;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;

public class InternalComponents {
    private final Project project;
    private final DependencyManagementExtension dependencyManagementExtension;
    private final Action<Configuration> implicitDependencyManagementCollector;
    private final Action<Configuration> dependencyManagementApplier;
    private final DependencyManagementContainer dependencyManagementContainer;

    public InternalComponents(Project project) {
        this.project = project;
        DependencyManagementConfigurationContainer configurationContainer = new DependencyManagementConfigurationContainer(project);
        MavenPomResolver pomResolver = new MavenPomResolver(project, configurationContainer);
        this.dependencyManagementContainer = new DependencyManagementContainer(project, pomResolver);
        DependencyManagementSettings dependencyManagementSettings = new DependencyManagementSettings();
        this.dependencyManagementExtension = new StandardDependencyManagementExtension(this.dependencyManagementContainer, configurationContainer, project, dependencyManagementSettings);
        this.implicitDependencyManagementCollector = new ImplicitDependencyManagementCollector(this.dependencyManagementContainer, dependencyManagementSettings);
        this.dependencyManagementApplier = new DependencyManagementApplier(project, this.dependencyManagementContainer, configurationContainer, dependencyManagementSettings, pomResolver);
    }

    public DependencyManagementExtension getDependencyManagementExtension() {
        return this.dependencyManagementExtension;
    }

    public Action<Configuration> getImplicitDependencyManagementCollector() {
        return this.implicitDependencyManagementCollector;
    }

    public Action<Configuration> getDependencyManagementApplier() {
        return this.dependencyManagementApplier;
    }

    public void createDependencyManagementReportTask(String taskName) {
        this.project.getTasks().create(taskName, DependencyManagementReportTask.class, this::setupTask);
    }

    private void setupTask(DependencyManagementReportTask task) {
        task.setDependencyManagementContainer(this.dependencyManagementContainer);
        task.setGroup("help");
        task.setDescription("Displays the dependency management declared in " + task.getProject() + ".");
    }
}

