/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import io.spring.javaformat.checkstyle.check.AbstractSpringCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SpringJUnit5Check
extends AbstractSpringCheck {
    private static final String JUNIT4_TEST_ANNOTATION_NAME = "org.junit.Test";
    private static final List<Annotation> TEST_ANNOTATIONS;
    private static final List<Annotation> LIFECYCLE_ANNOTATIONS;
    private static final Set<String> BANNED_IMPORTS;
    private List<String> unlessImports = new ArrayList<String>();
    private final List<DetailAST> testMethods = new ArrayList<DetailAST>();
    private final Map<String, FullIdent> imports = new LinkedHashMap<String, FullIdent>();
    private final List<DetailAST> lifecycleMethods = new ArrayList<DetailAST>();

    public int[] getAcceptableTokens() {
        return new int[]{9, 30};
    }

    public void beginTree(DetailAST rootAST) {
        this.imports.clear();
        this.testMethods.clear();
        this.lifecycleMethods.clear();
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 9: {
                this.visitMethodDef(ast);
            }
            case 30: {
                this.visitImport(ast);
            }
        }
    }

    private void visitMethodDef(DetailAST ast) {
        if (this.containsAnnotation(ast, TEST_ANNOTATIONS)) {
            this.testMethods.add(ast);
        }
        if (this.containsAnnotation(ast, LIFECYCLE_ANNOTATIONS)) {
            this.lifecycleMethods.add(ast);
        }
    }

    private boolean containsAnnotation(DetailAST ast, List<Annotation> annotations) {
        List annotationNames = annotations.stream().flatMap(annotation -> Stream.of(((Annotation)annotation).simpleName, ((Annotation)annotation).fullyQualifiedName())).collect(Collectors.toList());
        try {
            return AnnotationUtil.containsAnnotation((DetailAST)ast, annotationNames);
        }
        catch (NoSuchMethodError ex) {
            HashSet annotationNamesSet = new HashSet(annotationNames);
            try {
                return (Boolean)AnnotationUtil.class.getMethod("containsAnnotation", DetailAST.class, Set.class).invoke(null, ast, annotationNamesSet);
            }
            catch (Exception ex2) {
                throw new RuntimeException("containsAnnotation failed", ex2);
            }
        }
    }

    private void visitImport(DetailAST ast) {
        FullIdent ident = FullIdent.createFullIdentBelow((DetailAST)ast);
        this.imports.put(ident.getText(), ident);
    }

    public void finishTree(DetailAST rootAST) {
        if (this.shouldCheck()) {
            this.check();
        }
    }

    private boolean shouldCheck() {
        if (this.testMethods.isEmpty() && this.lifecycleMethods.isEmpty()) {
            return false;
        }
        for (String unlessImport : this.unlessImports) {
            if (!this.imports.containsKey(unlessImport)) continue;
            return false;
        }
        return true;
    }

    private void check() {
        for (String bannedImport : BANNED_IMPORTS) {
            FullIdent ident = this.imports.get(bannedImport);
            if (ident == null) continue;
            this.log(ident.getLineNo(), ident.getColumnNo(), "junit5.bannedImport", new Object[]{bannedImport});
        }
        for (DetailAST testMethod : this.testMethods) {
            if (!AnnotationUtil.containsAnnotation((DetailAST)testMethod, (String)JUNIT4_TEST_ANNOTATION_NAME)) continue;
            this.log(testMethod, "junit5.bannedTestAnnotation");
        }
        this.checkMethodVisibility(this.testMethods, "junit5.testPublicMethod", "junit5.testPrivateMethod");
        this.checkMethodVisibility(this.lifecycleMethods, "junit5.lifecyclePublicMethod", "junit5.lifecyclePrivateMethod");
    }

    private void checkMethodVisibility(List<DetailAST> methods, String publicMessageKey, String privateMessageKey) {
        for (DetailAST method : methods) {
            DetailAST modifiers = method.findFirstToken(5);
            if (modifiers.findFirstToken(62) != null) {
                this.log(method, publicMessageKey);
            }
            if (modifiers.findFirstToken(61) == null) continue;
            this.log(method, privateMessageKey);
        }
    }

    private void log(DetailAST method, String key) {
        String name = method.findFirstToken(58).getText();
        this.log(method.getLineNo(), method.getColumnNo(), key, new Object[]{name});
    }

    public void setUnlessImports(String unlessImports) {
        this.unlessImports = Collections.unmodifiableList(Arrays.stream(unlessImports.split(",")).map(String::trim).collect(Collectors.toList()));
    }

    static {
        LinkedHashSet<Annotation> annotations = new LinkedHashSet<Annotation>();
        annotations.add(new Annotation("org.junit.jupiter.api", "RepeatedTest"));
        annotations.add(new Annotation("org.junit.jupiter.api", "Test"));
        annotations.add(new Annotation("org.junit.jupiter.api", "TestFactory"));
        annotations.add(new Annotation("org.junit.jupiter.api", "TestTemplate"));
        annotations.add(new Annotation("org.junit.jupiter.api", "ParameterizedTest"));
        TEST_ANNOTATIONS = Collections.unmodifiableList(new ArrayList(annotations));
        annotations = new LinkedHashSet();
        annotations.add(new Annotation("org.junit.jupiter.api", "BeforeAll"));
        annotations.add(new Annotation("org.junit.jupiter.api", "BeforeEach"));
        annotations.add(new Annotation("org.junit.jupiter.api", "AfterAll"));
        annotations.add(new Annotation("org.junit.jupiter.api", "AfterEach"));
        LIFECYCLE_ANNOTATIONS = Collections.unmodifiableList(new ArrayList(annotations));
        LinkedHashSet<String> bannedImports = new LinkedHashSet<String>();
        bannedImports.add(JUNIT4_TEST_ANNOTATION_NAME);
        bannedImports.add("org.junit.After");
        bannedImports.add("org.junit.AfterClass");
        bannedImports.add("org.junit.Before");
        bannedImports.add("org.junit.BeforeClass");
        bannedImports.add("org.junit.Rule");
        bannedImports.add("org.junit.ClassRule");
        BANNED_IMPORTS = Collections.unmodifiableSet(bannedImports);
    }

    private static final class Annotation {
        private final String packageName;
        private final String simpleName;

        private Annotation(String packageName, String simpleName) {
            this.packageName = packageName;
            this.simpleName = simpleName;
        }

        private String fullyQualifiedName() {
            return this.packageName + "." + this.simpleName;
        }
    }
}

