/*
 * Copyright 2002-2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.spring.nohttp.file;

import io.spring.nohttp.HttpMatchResult;
import io.spring.nohttp.HttpMatcher;

import java.io.File;
import java.util.List;

/**
 * @author Rob Winch
 */
public class HttpMatcherProcessor extends HttpProcessor {
	private final HttpMatcher matcher;

	public HttpMatcherProcessor(HttpMatcher matcher) {
		if (matcher == null) {
			throw new IllegalArgumentException("matcher cannot be null");
		}
		this.matcher = matcher;
	}

	@Override
	List<HttpMatchResult> processHttpInFile(File file) {
		String originalText = FileUtils.readTextFrom(file);
		return this.matcher.findHttp(originalText);
	}
}
