/*
 * Decompiled with CFR 0.152.
 */
package io.spring.nohttp.gradle;

import io.spring.nohttp.gradle.NoHttpExtension;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.plugins.quality.CheckstylePlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.resources.TextResource;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoHttpCheckstylePlugin
implements Plugin<Project> {
    private static final String NOHTTP_VERSION = NoHttpCheckstylePlugin.determineNohttpVersion();
    @Deprecated
    public static final String DEFAULT_WHITELIST_FILE_PATH = "config/nohttp/whitelist.lines";
    @Deprecated
    public static final String LEGACY_WHITELIST_FILE_PATH = "etc/nohttp/whitelist.lines";
    public static final String DEFAULT_ALLOWLIST_FILE_PATH = "config/nohttp/allowlist.lines";
    public static final String NOHTTP_EXTENSION_NAME = "nohttp";
    public static final String CHECKSTYLE_CONFIGURATION_NAME = "checkstyle";
    public static final String CHECKSTYLE_NOHTTP_TASK_NAME = "checkstyleNohttp";
    public static final String DEFAULT_CONFIGURATION_NAME = "nohttp";
    private static final String CHECK_TASK_NAME = "check";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Project project;
    private NoHttpExtension extension;

    public void apply(final Project project) {
        File allowlistFile;
        File defaultWhiteListFile;
        this.project = project;
        this.extension = (NoHttpExtension)this.project.getExtensions().create("nohttp", NoHttpExtension.class, new Object[0]);
        this.extension.setToolVersion(NOHTTP_VERSION);
        this.extension.setSource(project.fileTree((Object)project.getProjectDir(), (Action)new Action<ConfigurableFileTree>(){

            public void execute(final ConfigurableFileTree files) {
                final String projectDir = project.getProjectDir().getAbsolutePath();
                files.exclude(new String[]{NoHttpCheckstylePlugin.this.createBuildExclusion(projectDir, project)});
                project.subprojects((Action)new Action<Project>(){

                    public void execute(Project p) {
                        files.exclude(new String[]{NoHttpCheckstylePlugin.this.createBuildExclusion(projectDir, p)});
                    }
                });
                files.exclude(new String[]{".git/**"});
                files.exclude(new String[]{".gradle/**"});
                files.exclude(new String[]{"buildSrc/.gradle/**"});
                files.exclude(new String[]{".idea/**"});
                files.exclude(new String[]{"**/*.class"});
                files.exclude(new String[]{"**/*.hprof"});
                files.exclude(new String[]{"**/*.jar"});
                files.exclude(new String[]{"**/*.jpg"});
                files.exclude(new String[]{"**/*.jks"});
                files.exclude(new String[]{"**/spring.handlers"});
                files.exclude(new String[]{"**/spring.schemas"});
                files.exclude(new String[]{"**/spring.tooling"});
            }
        }));
        File legacyWhiteListFile = project.file((Object)LEGACY_WHITELIST_FILE_PATH);
        if (legacyWhiteListFile.exists()) {
            this.extension.setAllowlistFile(legacyWhiteListFile);
        }
        if ((defaultWhiteListFile = project.file((Object)DEFAULT_WHITELIST_FILE_PATH)).exists()) {
            this.extension.setAllowlistFile(defaultWhiteListFile);
        }
        if ((allowlistFile = this.project.file((Object)DEFAULT_ALLOWLIST_FILE_PATH)).exists()) {
            this.extension.setAllowlistFile(allowlistFile);
        }
        project.getPluginManager().apply(CheckstylePlugin.class);
        Configuration checkstyleConfiguration = project.getConfigurations().getByName(CHECKSTYLE_CONFIGURATION_NAME);
        Configuration noHttpConfiguration = (Configuration)project.getConfigurations().create("nohttp");
        checkstyleConfiguration.extendsFrom(new Configuration[]{noHttpConfiguration});
        this.configureDefaultDependenciesForProject(noHttpConfiguration);
        this.createCheckstyleTaskForProject(checkstyleConfiguration);
        this.configureCheckTask();
    }

    private String createBuildExclusion(String projectDir, Project p) {
        File buildDir = p.getBuildDir();
        String path = buildDir.getAbsolutePath().replace(projectDir + File.separator, "");
        String pattern = path + "/**";
        return pattern;
    }

    private void createCheckstyleTaskForProject(final Configuration configuration) {
        Project project = this.project;
        project.getTasks().register(CHECKSTYLE_NOHTTP_TASK_NAME, Checkstyle.class, (Action)new Action<Checkstyle>(){

            public void execute(Checkstyle checkstyleTask) {
                NoHttpCheckstylePlugin.this.configureCheckstyleTask(configuration, checkstyleTask);
            }
        });
    }

    private void configureCheckstyleTask(final Configuration configuration, final Checkstyle checkstyleTask) {
        final Logger logger = this.logger;
        final NoHttpExtension extension = this.extension;
        checkstyleTask.setDescription("Checks for illegal uses of http://");
        checkstyleTask.getReports().all((Action)new Action<SingleFileReport>(){

            public void execute(SingleFileReport report) {
                Provider reportDir = ((ReportingExtension)NoHttpCheckstylePlugin.this.project.getExtensions().getByType(ReportingExtension.class)).getBaseDirectory().dir(checkstyleTask.getName());
                if (NoHttpCheckstylePlugin.isAtLeastGradle7()) {
                    String reportFileName = ((RegularFile)report.getOutputLocation().get()).getAsFile().getName();
                    report.getOutputLocation().value(reportDir.map(it -> it.file(reportFileName)));
                } else {
                    String reportFileName = report.getDestination().getName();
                    report.setDestination(reportDir.map(it -> it.file(reportFileName).getAsFile()));
                }
            }
        });
        ConventionMapping taskMapping = checkstyleTask.getConventionMapping();
        taskMapping.map("classpath", (Callable)new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                return configuration;
            }
        });
        taskMapping.map("source", (Callable)new Callable<FileTree>(){

            @Override
            public FileTree call() throws Exception {
                return extension.getSource();
            }
        });
        final boolean configureConfigLoc = this.configureConfigDirectory(checkstyleTask);
        taskMapping.map("configProperties", (Callable)new Callable<Map<String, Object>>(){

            @Override
            public Map<String, Object> call() throws Exception {
                HashMap<String, Object> configProperties = new HashMap<String, Object>();
                File allowlistFile = extension.getAllowlistFile();
                if (allowlistFile != null) {
                    logger.debug("Using allowlist at {}", (Object)allowlistFile);
                    String allowlistPath = NoHttpCheckstylePlugin.this.project.relativePath((Object)allowlistFile);
                    configProperties.put("nohttp.checkstyle.allowlistFileName", allowlistPath);
                }
                if (configureConfigLoc) {
                    configProperties.put("config_loc", NoHttpCheckstylePlugin.this.project.relativePath((Object)NoHttpCheckstylePlugin.this.getConfigLocation()));
                }
                return configProperties;
            }
        });
        taskMapping.map("config", (Callable)new Callable<TextResource>(){

            @Override
            public TextResource call() throws Exception {
                File configLoc = NoHttpCheckstylePlugin.this.getConfigLocation();
                File defaultCheckstyleFile = new File(configLoc, "checkstyle.xml");
                if (defaultCheckstyleFile.exists()) {
                    logger.debug("Found default checkstyle configuration, so configuring checkstyleTask to use it");
                    String checkstyleXmlAsString = NoHttpCheckstylePlugin.this.project.getResources().getText().fromFile((Object)defaultCheckstyleFile).asString();
                    return NoHttpCheckstylePlugin.this.project.getResources().getText().fromString(checkstyleXmlAsString);
                }
                logger.debug("No checkstyle configuration provided, so using the default.");
                URL resource = this.getClass().getResource("/io/spring/nohttp/checkstyle/default-nohttp-checkstyle.xml");
                String checkstyleXmlAsString = NoHttpCheckstylePlugin.this.project.getResources().getText().fromUri((Object)resource).asString();
                return NoHttpCheckstylePlugin.this.project.getResources().getText().fromString(checkstyleXmlAsString);
            }
        });
    }

    private boolean configureConfigDirectory(Checkstyle checkstyleTask) {
        File configDirectory = this.project.file((Object)this.getConfigLocation());
        if (!configDirectory.exists() && this.isGradle7_0()) {
            File defaultConfigDir = (File)checkstyleTask.getConfigDirectory().getAsFile().forUseAtConfigurationTime().getOrNull();
            return defaultConfigDir == null || !defaultConfigDir.exists();
        }
        try {
            checkstyleTask.getConfigDirectory().set(configDirectory);
            return false;
        }
        catch (NoSuchMethodError defaultConfigDir) {
            try {
                Method configDir = checkstyleTask.getClass().getMethod("setConfigDir", Provider.class);
                configDir.invoke((Object)checkstyleTask, this.project.provider(() -> configDirectory));
                return false;
            }
            catch (ReflectiveOperationException ex) {
                return true;
            }
        }
    }

    public static boolean isAtLeastGradle7() {
        return GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"7.0")) >= 0;
    }

    private boolean isGradle7_0() {
        return GradleVersion.current().getBaseVersion().equals((Object)GradleVersion.version((String)"7.0"));
    }

    private File getConfigLocation() {
        File allowlistFile = this.extension.getAllowlistFile();
        if (allowlistFile != null) {
            return allowlistFile.getParentFile();
        }
        File legacy = this.project.file((Object)"etc/nohttp");
        if (legacy.exists()) {
            return legacy;
        }
        return this.project.file((Object)"config/nohttp");
    }

    private void configureDefaultDependenciesForProject(Configuration configuration) {
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencies) {
                NoHttpExtension extension = NoHttpCheckstylePlugin.this.extension;
                dependencies.add((Object)NoHttpCheckstylePlugin.this.project.getDependencies().create((Object)("io.spring.nohttp:nohttp-checkstyle:" + extension.getToolVersion())));
            }
        });
    }

    private void configureCheckTask() {
        this.project.getTasks().withType(Task.class).configureEach((Action)new Action<Task>(){

            public void execute(Task task) {
                if (NoHttpCheckstylePlugin.CHECK_TASK_NAME.equals(task.getName())) {
                    task.dependsOn(new Object[]{new Callable(){

                        public Object call() {
                            return NoHttpCheckstylePlugin.CHECKSTYLE_NOHTTP_TASK_NAME;
                        }
                    }});
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String determineNohttpVersion() {
        Class<NoHttpCheckstylePlugin> clazz = NoHttpCheckstylePlugin.class;
        String implementationVersion = clazz.getPackage().getImplementationVersion();
        if (implementationVersion != null) {
            return implementationVersion;
        }
        URL codeSourceLocation = clazz.getProtectionDomain().getCodeSource().getLocation();
        try {
            URLConnection connection = codeSourceLocation.openConnection();
            if (connection instanceof JarURLConnection) {
                return NoHttpCheckstylePlugin.getImplementationVersion(((JarURLConnection)connection).getJarFile());
            }
            try (JarFile jarFile = new JarFile(new File(codeSourceLocation.toURI()));){
                String string = NoHttpCheckstylePlugin.getImplementationVersion(jarFile);
                return string;
            }
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String getImplementationVersion(JarFile jarFile) throws IOException {
        return jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }
}

