package io.stargate.db;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DriverInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDriverInfo.builder()}.
 */
@Generated(from = "DriverInfo", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDriverInfo implements DriverInfo {
  private final String name;
  private final @Nullable String version;

  private ImmutableDriverInfo(String name, @Nullable String version) {
    this.name = name;
    this.version = version;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @Override
  public Optional<String> version() {
    return Optional.ofNullable(version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DriverInfo#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDriverInfo withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableDriverInfo(newValue, this.version);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link DriverInfo#version() version} attribute.
   * @param value The value for version
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDriverInfo withVersion(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "version");
    if (Objects.equals(this.version, newValue)) return this;
    return new ImmutableDriverInfo(this.name, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link DriverInfo#version() version} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for version
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDriverInfo withVersion(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.version, value)) return this;
    return new ImmutableDriverInfo(this.name, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDriverInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDriverInfo
        && equalTo((ImmutableDriverInfo) another);
  }

  private boolean equalTo(ImmutableDriverInfo another) {
    return name.equals(another.name)
        && Objects.equals(version, another.version);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(version);
    return h;
  }

  /**
   * Prints the immutable value {@code DriverInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("DriverInfo{");
    builder.append("name=").append(name);
    if (version != null) {
      builder.append(", ");
      builder.append("version=").append(version);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link DriverInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DriverInfo instance
   */
  public static ImmutableDriverInfo copyOf(DriverInfo instance) {
    if (instance instanceof ImmutableDriverInfo) {
      return (ImmutableDriverInfo) instance;
    }
    return ImmutableDriverInfo.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDriverInfo ImmutableDriverInfo}.
   * <pre>
   * ImmutableDriverInfo.builder()
   *    .name(String) // required {@link DriverInfo#name() name}
   *    .version(String) // optional {@link DriverInfo#version() version}
   *    .build();
   * </pre>
   * @return A new ImmutableDriverInfo builder
   */
  public static ImmutableDriverInfo.Builder builder() {
    return new ImmutableDriverInfo.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDriverInfo ImmutableDriverInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DriverInfo", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;
    private @Nullable String version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DriverInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DriverInfo instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      Optional<String> versionOptional = instance.version();
      if (versionOptional.isPresent()) {
        version(versionOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DriverInfo#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the optional value {@link DriverInfo#version() version} to version.
     * @param version The value for version
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      return this;
    }

    /**
     * Initializes the optional value {@link DriverInfo#version() version} to version.
     * @param version The value for version
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder version(Optional<String> version) {
      this.version = version.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableDriverInfo ImmutableDriverInfo}.
     * @return An immutable instance of DriverInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDriverInfo build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDriverInfo(name, version);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build DriverInfo, some of required attributes are not set " + attributes;
    }
  }
}
