package io.stargate.db;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.stargate.db.ConsistencyLevel;
import org.apache.cassandra.stargate.transport.ProtocolVersion;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Parameters}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableParameters.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableParameters.of()}.
 */
@Generated(from = "Parameters", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableParameters extends Parameters {
  private final ProtocolVersion protocolVersion;
  private final @Nullable Integer pageSize;
  private final @Nullable ByteBuffer pagingState;
  private final ConsistencyLevel consistencyLevel;
  private final @Nullable ConsistencyLevel serialConsistencyLevel;
  private final @Nullable Long defaultTimestamp;
  private final @Nullable Integer nowInSeconds;
  private final @Nullable String defaultKeyspace;
  private final @Nullable Map<String, ByteBuffer> customPayload;
  private final boolean skipMetadataInResult;
  private final boolean tracingRequested;

  private ImmutableParameters() {
    this.pageSize = null;
    this.pagingState = null;
    this.serialConsistencyLevel = null;
    this.defaultTimestamp = null;
    this.nowInSeconds = null;
    this.defaultKeyspace = null;
    this.customPayload = null;
    this.protocolVersion = initShim.protocolVersion();
    this.consistencyLevel = initShim.consistencyLevel();
    this.skipMetadataInResult = initShim.skipMetadataInResult();
    this.tracingRequested = initShim.tracingRequested();
    this.initShim = null;
  }

  private ImmutableParameters(ImmutableParameters.Builder builder) {
    this.pageSize = builder.pageSize;
    this.pagingState = builder.pagingState;
    this.serialConsistencyLevel = builder.serialConsistencyLevel;
    this.defaultTimestamp = builder.defaultTimestamp;
    this.nowInSeconds = builder.nowInSeconds;
    this.defaultKeyspace = builder.defaultKeyspace;
    this.customPayload = builder.customPayload;
    if (builder.protocolVersion != null) {
      initShim.protocolVersion(builder.protocolVersion);
    }
    if (builder.consistencyLevel != null) {
      initShim.consistencyLevel(builder.consistencyLevel);
    }
    if (builder.skipMetadataInResultIsSet()) {
      initShim.skipMetadataInResult(builder.skipMetadataInResult);
    }
    if (builder.tracingRequestedIsSet()) {
      initShim.tracingRequested(builder.tracingRequested);
    }
    this.protocolVersion = initShim.protocolVersion();
    this.consistencyLevel = initShim.consistencyLevel();
    this.skipMetadataInResult = initShim.skipMetadataInResult();
    this.tracingRequested = initShim.tracingRequested();
    this.initShim = null;
  }

  private ImmutableParameters(
      ProtocolVersion protocolVersion,
      @Nullable Integer pageSize,
      @Nullable ByteBuffer pagingState,
      ConsistencyLevel consistencyLevel,
      @Nullable ConsistencyLevel serialConsistencyLevel,
      @Nullable Long defaultTimestamp,
      @Nullable Integer nowInSeconds,
      @Nullable String defaultKeyspace,
      @Nullable Map<String, ByteBuffer> customPayload,
      boolean skipMetadataInResult,
      boolean tracingRequested) {
    this.protocolVersion = protocolVersion;
    this.pageSize = pageSize;
    this.pagingState = pagingState;
    this.consistencyLevel = consistencyLevel;
    this.serialConsistencyLevel = serialConsistencyLevel;
    this.defaultTimestamp = defaultTimestamp;
    this.nowInSeconds = nowInSeconds;
    this.defaultKeyspace = defaultKeyspace;
    this.customPayload = customPayload;
    this.skipMetadataInResult = skipMetadataInResult;
    this.tracingRequested = tracingRequested;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "Parameters", generator = "Immutables")
  private final class InitShim {
    private byte protocolVersionBuildStage = STAGE_UNINITIALIZED;
    private ProtocolVersion protocolVersion;

    ProtocolVersion protocolVersion() {
      if (protocolVersionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (protocolVersionBuildStage == STAGE_UNINITIALIZED) {
        protocolVersionBuildStage = STAGE_INITIALIZING;
        this.protocolVersion = Objects.requireNonNull(ImmutableParameters.super.protocolVersion(), "protocolVersion");
        protocolVersionBuildStage = STAGE_INITIALIZED;
      }
      return this.protocolVersion;
    }

    void protocolVersion(ProtocolVersion protocolVersion) {
      this.protocolVersion = protocolVersion;
      protocolVersionBuildStage = STAGE_INITIALIZED;
    }

    private byte consistencyLevelBuildStage = STAGE_UNINITIALIZED;
    private ConsistencyLevel consistencyLevel;

    ConsistencyLevel consistencyLevel() {
      if (consistencyLevelBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (consistencyLevelBuildStage == STAGE_UNINITIALIZED) {
        consistencyLevelBuildStage = STAGE_INITIALIZING;
        this.consistencyLevel = Objects.requireNonNull(ImmutableParameters.super.consistencyLevel(), "consistencyLevel");
        consistencyLevelBuildStage = STAGE_INITIALIZED;
      }
      return this.consistencyLevel;
    }

    void consistencyLevel(ConsistencyLevel consistencyLevel) {
      this.consistencyLevel = consistencyLevel;
      consistencyLevelBuildStage = STAGE_INITIALIZED;
    }

    private byte skipMetadataInResultBuildStage = STAGE_UNINITIALIZED;
    private boolean skipMetadataInResult;

    boolean skipMetadataInResult() {
      if (skipMetadataInResultBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (skipMetadataInResultBuildStage == STAGE_UNINITIALIZED) {
        skipMetadataInResultBuildStage = STAGE_INITIALIZING;
        this.skipMetadataInResult = ImmutableParameters.super.skipMetadataInResult();
        skipMetadataInResultBuildStage = STAGE_INITIALIZED;
      }
      return this.skipMetadataInResult;
    }

    void skipMetadataInResult(boolean skipMetadataInResult) {
      this.skipMetadataInResult = skipMetadataInResult;
      skipMetadataInResultBuildStage = STAGE_INITIALIZED;
    }

    private byte tracingRequestedBuildStage = STAGE_UNINITIALIZED;
    private boolean tracingRequested;

    boolean tracingRequested() {
      if (tracingRequestedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (tracingRequestedBuildStage == STAGE_UNINITIALIZED) {
        tracingRequestedBuildStage = STAGE_INITIALIZING;
        this.tracingRequested = ImmutableParameters.super.tracingRequested();
        tracingRequestedBuildStage = STAGE_INITIALIZED;
      }
      return this.tracingRequested;
    }

    void tracingRequested(boolean tracingRequested) {
      this.tracingRequested = tracingRequested;
      tracingRequestedBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (protocolVersionBuildStage == STAGE_INITIALIZING) attributes.add("protocolVersion");
      if (consistencyLevelBuildStage == STAGE_INITIALIZING) attributes.add("consistencyLevel");
      if (skipMetadataInResultBuildStage == STAGE_INITIALIZING) attributes.add("skipMetadataInResult");
      if (tracingRequestedBuildStage == STAGE_INITIALIZING) attributes.add("tracingRequested");
      return "Cannot build Parameters, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * The protocol version used for the request. In particular, this must be the version with which
   * the values of the request ({@link Statement#values()}) are encoded, and will be the version
   * with which returned values will be encoded. Defaults to {@link ProtocolVersion#CURRENT}.
   */
  @Override
  public ProtocolVersion protocolVersion() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.protocolVersion()
        : this.protocolVersion;
  }

  /**
   * The optional page size, in rows, for the request. If unset, the request will not page. If set,
   * this must be a strictly positive number.
   */
  @Override
  public OptionalInt pageSize() {
    return pageSize != null
        ? OptionalInt.of(pageSize)
        : OptionalInt.empty();
  }

  /**
   *The optional paging state to request the subsequent pages of a paged request. 
   */
  @Override
  public Optional<ByteBuffer> pagingState() {
    return Optional.ofNullable(pagingState);
  }

  /**
   *The consistency level for the request. Defaults to ONE. 
   */
  @Override
  public ConsistencyLevel consistencyLevel() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.consistencyLevel()
        : this.consistencyLevel;
  }

  /**
   * The optional serial consistency level for the request. This is optional in that only
   * conditional (LWT) requests use a serial consistency level. If unset but the request is a
   * conditional one, a default will be used but is unspecified and might depend of the {@link
   * Persistence} implementation.
   */
  @Override
  public Optional<ConsistencyLevel> serialConsistencyLevel() {
    return Optional.ofNullable(serialConsistencyLevel);
  }

  /**
   * The optional default timestamp to use for the request. If unset, the default timestamp will be
   * generated by the {@link Persistence} implementation.
   */
  @Override
  public OptionalLong defaultTimestamp() {
    return defaultTimestamp != null
        ? OptionalLong.of(defaultTimestamp)
        : OptionalLong.empty();
  }

  /**
   * The optional time to use a "now". If unset, the current time will be generated by the {@link
   * Persistence} implementation. This option is mainly meant for testing.
   */
  @Override
  public OptionalInt nowInSeconds() {
    return nowInSeconds != null
        ? OptionalInt.of(nowInSeconds)
        : OptionalInt.empty();
  }

  /**
   * The default keyspace to use for the request (only used if the request itself does not specify a
   * keyspace). If unset, the default keyspace used on the underlying {@link Persistence.Connection}
   * the request is made on will be used (and if none if use and the request does not specify a
   * keyspace, the request will error out).
   */
  @Override
  public Optional<String> defaultKeyspace() {
    return Optional.ofNullable(defaultKeyspace);
  }

  /**
   *Custom payload that can be used by the underlying {@link Persistence} implementation. 
   */
  @Override
  public Optional<Map<String, ByteBuffer>> customPayload() {
    return Optional.ofNullable(customPayload);
  }

  /**
   * Requests to not include metadata in the result of the request (can be used when paging to
   * potentially save a few cycles since the result metadata is the same for all pages). Not set by
   * default.
   */
  @Override
  public boolean skipMetadataInResult() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.skipMetadataInResult()
        : this.skipMetadataInResult;
  }

  /**
   *Enables tracing for the request. Not set by default. 
   */
  @Override
  public boolean tracingRequested() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.tracingRequested()
        : this.tracingRequested;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Parameters#protocolVersion() protocolVersion} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for protocolVersion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParameters withProtocolVersion(ProtocolVersion value) {
    if (this.protocolVersion == value) return this;
    ProtocolVersion newValue = Objects.requireNonNull(value, "protocolVersion");
    if (this.protocolVersion.equals(newValue)) return this;
    return validate(new ImmutableParameters(
        newValue,
        this.pageSize,
        this.pagingState,
        this.consistencyLevel,
        this.serialConsistencyLevel,
        this.defaultTimestamp,
        this.nowInSeconds,
        this.defaultKeyspace,
        this.customPayload,
        this.skipMetadataInResult,
        this.tracingRequested));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Parameters#pageSize() pageSize} attribute.
   * @param value The value for pageSize
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParameters withPageSize(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.pageSize, newValue)) return this;
    return validate(new ImmutableParameters(
        this.protocolVersion,
        newValue,
        this.pagingState,
        this.consistencyLevel,
        this.serialConsistencyLevel,
        this.defaultTimestamp,
        this.nowInSeconds,
        this.defaultKeyspace,
        this.customPayload,
        this.skipMetadataInResult,
        this.tracingRequested));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Parameters#pageSize() pageSize} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for pageSize
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParameters withPageSize(OptionalInt optional) {
    @Nullable Integer value = optional.isPresent() ? optional.getAsInt() : null;
    if (Objects.equals(this.pageSize, value)) return this;
    return validate(new ImmutableParameters(
        this.protocolVersion,
        value,
        this.pagingState,
        this.consistencyLevel,
        this.serialConsistencyLevel,
        this.defaultTimestamp,
        this.nowInSeconds,
        this.defaultKeyspace,
        this.customPayload,
        this.skipMetadataInResult,
        this.tracingRequested));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Parameters#pagingState() pagingState} attribute.
   * @param value The value for pagingState
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParameters withPagingState(ByteBuffer value) {
    @Nullable ByteBuffer newValue = Objects.requireNonNull(value, "pagingState");
    if (this.pagingState == newValue) return this;
    return validate(new ImmutableParameters(
        this.protocolVersion,
        this.pageSize,
        newValue,
        this.consistencyLevel,
        this.serialConsistencyLevel,
        this.defaultTimestamp,
        this.nowInSeconds,
        this.defaultKeyspace,
        this.customPayload,
        this.skipMetadataInResult,
        this.tracingRequested));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Parameters#pagingState() pagingState} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for pagingState
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableParameters withPagingState(Optional<? extends ByteBuffer> optional) {
    @Nullable ByteBuffer value = optional.orElse(null);
    if (this.pagingState == value) return this;
    return validate(new ImmutableParameters(
        this.protocolVersion,
        this.pageSize,
        value,
        this.consistencyLevel,
        this.serialConsistencyLevel,
        this.defaultTimestamp,
        this.nowInSeconds,
        this.defaultKeyspace,
        this.customPayload,
        this.skipMetadataInResult,
        this.tracingRequested));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Parameters#consistencyLevel() consistencyLevel} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for consistencyLevel
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParameters withConsistencyLevel(ConsistencyLevel value) {
    if (this.consistencyLevel == value) return this;
    ConsistencyLevel newValue = Objects.requireNonNull(value, "consistencyLevel");
    if (this.consistencyLevel.equals(newValue)) return this;
    return validate(new ImmutableParameters(
        this.protocolVersion,
        this.pageSize,
        this.pagingState,
        newValue,
        this.serialConsistencyLevel,
        this.defaultTimestamp,
        this.nowInSeconds,
        this.defaultKeyspace,
        this.customPayload,
        this.skipMetadataInResult,
        this.tracingRequested));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Parameters#serialConsistencyLevel() serialConsistencyLevel} attribute.
   * @param value The value for serialConsistencyLevel
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParameters withSerialConsistencyLevel(ConsistencyLevel value) {
    @Nullable ConsistencyLevel newValue = Objects.requireNonNull(value, "serialConsistencyLevel");
    if (this.serialConsistencyLevel == newValue) return this;
    return validate(new ImmutableParameters(
        this.protocolVersion,
        this.pageSize,
        this.pagingState,
        this.consistencyLevel,
        newValue,
        this.defaultTimestamp,
        this.nowInSeconds,
        this.defaultKeyspace,
        this.customPayload,
        this.skipMetadataInResult,
        this.tracingRequested));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Parameters#serialConsistencyLevel() serialConsistencyLevel} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serialConsistencyLevel
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableParameters withSerialConsistencyLevel(Optional<? extends ConsistencyLevel> optional) {
    @Nullable ConsistencyLevel value = optional.orElse(null);
    if (Objects.equals(this.serialConsistencyLevel, value)) return this;
    return validate(new ImmutableParameters(
        this.protocolVersion,
        this.pageSize,
        this.pagingState,
        this.consistencyLevel,
        value,
        this.defaultTimestamp,
        this.nowInSeconds,
        this.defaultKeyspace,
        this.customPayload,
        this.skipMetadataInResult,
        this.tracingRequested));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Parameters#defaultTimestamp() defaultTimestamp} attribute.
   * @param value The value for defaultTimestamp
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParameters withDefaultTimestamp(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.defaultTimestamp, newValue)) return this;
    return validate(new ImmutableParameters(
        this.protocolVersion,
        this.pageSize,
        this.pagingState,
        this.consistencyLevel,
        this.serialConsistencyLevel,
        newValue,
        this.nowInSeconds,
        this.defaultKeyspace,
        this.customPayload,
        this.skipMetadataInResult,
        this.tracingRequested));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Parameters#defaultTimestamp() defaultTimestamp} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for defaultTimestamp
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParameters withDefaultTimestamp(OptionalLong optional) {
    @Nullable Long value = optional.isPresent() ? optional.getAsLong() : null;
    if (Objects.equals(this.defaultTimestamp, value)) return this;
    return validate(new ImmutableParameters(
        this.protocolVersion,
        this.pageSize,
        this.pagingState,
        this.consistencyLevel,
        this.serialConsistencyLevel,
        value,
        this.nowInSeconds,
        this.defaultKeyspace,
        this.customPayload,
        this.skipMetadataInResult,
        this.tracingRequested));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Parameters#nowInSeconds() nowInSeconds} attribute.
   * @param value The value for nowInSeconds
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParameters withNowInSeconds(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.nowInSeconds, newValue)) return this;
    return validate(new ImmutableParameters(
        this.protocolVersion,
        this.pageSize,
        this.pagingState,
        this.consistencyLevel,
        this.serialConsistencyLevel,
        this.defaultTimestamp,
        newValue,
        this.defaultKeyspace,
        this.customPayload,
        this.skipMetadataInResult,
        this.tracingRequested));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Parameters#nowInSeconds() nowInSeconds} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for nowInSeconds
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParameters withNowInSeconds(OptionalInt optional) {
    @Nullable Integer value = optional.isPresent() ? optional.getAsInt() : null;
    if (Objects.equals(this.nowInSeconds, value)) return this;
    return validate(new ImmutableParameters(
        this.protocolVersion,
        this.pageSize,
        this.pagingState,
        this.consistencyLevel,
        this.serialConsistencyLevel,
        this.defaultTimestamp,
        value,
        this.defaultKeyspace,
        this.customPayload,
        this.skipMetadataInResult,
        this.tracingRequested));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Parameters#defaultKeyspace() defaultKeyspace} attribute.
   * @param value The value for defaultKeyspace
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParameters withDefaultKeyspace(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "defaultKeyspace");
    if (Objects.equals(this.defaultKeyspace, newValue)) return this;
    return validate(new ImmutableParameters(
        this.protocolVersion,
        this.pageSize,
        this.pagingState,
        this.consistencyLevel,
        this.serialConsistencyLevel,
        this.defaultTimestamp,
        this.nowInSeconds,
        newValue,
        this.customPayload,
        this.skipMetadataInResult,
        this.tracingRequested));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Parameters#defaultKeyspace() defaultKeyspace} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for defaultKeyspace
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParameters withDefaultKeyspace(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.defaultKeyspace, value)) return this;
    return validate(new ImmutableParameters(
        this.protocolVersion,
        this.pageSize,
        this.pagingState,
        this.consistencyLevel,
        this.serialConsistencyLevel,
        this.defaultTimestamp,
        this.nowInSeconds,
        value,
        this.customPayload,
        this.skipMetadataInResult,
        this.tracingRequested));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Parameters#customPayload() customPayload} attribute.
   * @param value The value for customPayload
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParameters withCustomPayload(Map<String, ByteBuffer> value) {
    @Nullable Map<String, ByteBuffer> newValue = Objects.requireNonNull(value, "customPayload");
    if (this.customPayload == newValue) return this;
    return validate(new ImmutableParameters(
        this.protocolVersion,
        this.pageSize,
        this.pagingState,
        this.consistencyLevel,
        this.serialConsistencyLevel,
        this.defaultTimestamp,
        this.nowInSeconds,
        this.defaultKeyspace,
        newValue,
        this.skipMetadataInResult,
        this.tracingRequested));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Parameters#customPayload() customPayload} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for customPayload
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableParameters withCustomPayload(Optional<? extends Map<String, ByteBuffer>> optional) {
    @Nullable Map<String, ByteBuffer> value = optional.orElse(null);
    if (this.customPayload == value) return this;
    return validate(new ImmutableParameters(
        this.protocolVersion,
        this.pageSize,
        this.pagingState,
        this.consistencyLevel,
        this.serialConsistencyLevel,
        this.defaultTimestamp,
        this.nowInSeconds,
        this.defaultKeyspace,
        value,
        this.skipMetadataInResult,
        this.tracingRequested));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Parameters#skipMetadataInResult() skipMetadataInResult} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for skipMetadataInResult
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParameters withSkipMetadataInResult(boolean value) {
    if (this.skipMetadataInResult == value) return this;
    return validate(new ImmutableParameters(
        this.protocolVersion,
        this.pageSize,
        this.pagingState,
        this.consistencyLevel,
        this.serialConsistencyLevel,
        this.defaultTimestamp,
        this.nowInSeconds,
        this.defaultKeyspace,
        this.customPayload,
        value,
        this.tracingRequested));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Parameters#tracingRequested() tracingRequested} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tracingRequested
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParameters withTracingRequested(boolean value) {
    if (this.tracingRequested == value) return this;
    return validate(new ImmutableParameters(
        this.protocolVersion,
        this.pageSize,
        this.pagingState,
        this.consistencyLevel,
        this.serialConsistencyLevel,
        this.defaultTimestamp,
        this.nowInSeconds,
        this.defaultKeyspace,
        this.customPayload,
        this.skipMetadataInResult,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableParameters} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableParameters
        && equalTo((ImmutableParameters) another);
  }

  private boolean equalTo(ImmutableParameters another) {
    return protocolVersion.equals(another.protocolVersion)
        && Objects.equals(pageSize, another.pageSize)
        && Objects.equals(pagingState, another.pagingState)
        && consistencyLevel.equals(another.consistencyLevel)
        && Objects.equals(serialConsistencyLevel, another.serialConsistencyLevel)
        && Objects.equals(defaultTimestamp, another.defaultTimestamp)
        && Objects.equals(nowInSeconds, another.nowInSeconds)
        && Objects.equals(defaultKeyspace, another.defaultKeyspace)
        && Objects.equals(customPayload, another.customPayload)
        && skipMetadataInResult == another.skipMetadataInResult
        && tracingRequested == another.tracingRequested;
  }

  /**
   * Computes a hash code from attributes: {@code protocolVersion}, {@code pageSize}, {@code pagingState}, {@code consistencyLevel}, {@code serialConsistencyLevel}, {@code defaultTimestamp}, {@code nowInSeconds}, {@code defaultKeyspace}, {@code customPayload}, {@code skipMetadataInResult}, {@code tracingRequested}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + protocolVersion.hashCode();
    h += (h << 5) + Objects.hashCode(pageSize);
    h += (h << 5) + Objects.hashCode(pagingState);
    h += (h << 5) + consistencyLevel.hashCode();
    h += (h << 5) + Objects.hashCode(serialConsistencyLevel);
    h += (h << 5) + Objects.hashCode(defaultTimestamp);
    h += (h << 5) + Objects.hashCode(nowInSeconds);
    h += (h << 5) + Objects.hashCode(defaultKeyspace);
    h += (h << 5) + Objects.hashCode(customPayload);
    h += (h << 5) + Boolean.hashCode(skipMetadataInResult);
    h += (h << 5) + Boolean.hashCode(tracingRequested);
    return h;
  }

  private static final ImmutableParameters INSTANCE = validate(new ImmutableParameters());

  /**
   * Returns the default immutable singleton value of {@code Parameters}
   * @return An immutable instance of Parameters
   */
  public static ImmutableParameters of() {
    return INSTANCE;
  }

  private static ImmutableParameters validate(ImmutableParameters instance) {
    instance.validate();
    return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link Parameters} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Parameters instance
   */
  public static ImmutableParameters copyOf(Parameters instance) {
    if (instance instanceof ImmutableParameters) {
      return (ImmutableParameters) instance;
    }
    return ImmutableParameters.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableParameters ImmutableParameters}.
   * <pre>
   * ImmutableParameters.builder()
   *    .protocolVersion(org.apache.cassandra.stargate.transport.ProtocolVersion) // optional {@link Parameters#protocolVersion() protocolVersion}
   *    .pageSize(int) // optional {@link Parameters#pageSize() pageSize}
   *    .pagingState(java.nio.ByteBuffer) // optional {@link Parameters#pagingState() pagingState}
   *    .consistencyLevel(org.apache.cassandra.stargate.db.ConsistencyLevel) // optional {@link Parameters#consistencyLevel() consistencyLevel}
   *    .serialConsistencyLevel(org.apache.cassandra.stargate.db.ConsistencyLevel) // optional {@link Parameters#serialConsistencyLevel() serialConsistencyLevel}
   *    .defaultTimestamp(long) // optional {@link Parameters#defaultTimestamp() defaultTimestamp}
   *    .nowInSeconds(int) // optional {@link Parameters#nowInSeconds() nowInSeconds}
   *    .defaultKeyspace(String) // optional {@link Parameters#defaultKeyspace() defaultKeyspace}
   *    .customPayload(Map&amp;lt;String, java.nio.ByteBuffer&amp;gt;) // optional {@link Parameters#customPayload() customPayload}
   *    .skipMetadataInResult(boolean) // optional {@link Parameters#skipMetadataInResult() skipMetadataInResult}
   *    .tracingRequested(boolean) // optional {@link Parameters#tracingRequested() tracingRequested}
   *    .build();
   * </pre>
   * @return A new ImmutableParameters builder
   */
  public static ImmutableParameters.Builder builder() {
    return new ImmutableParameters.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableParameters ImmutableParameters}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Parameters", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_SKIP_METADATA_IN_RESULT = 0x1L;
    private static final long OPT_BIT_TRACING_REQUESTED = 0x2L;
    private long optBits;

    private @Nullable ProtocolVersion protocolVersion;
    private @Nullable Integer pageSize;
    private @Nullable ByteBuffer pagingState;
    private @Nullable ConsistencyLevel consistencyLevel;
    private @Nullable ConsistencyLevel serialConsistencyLevel;
    private @Nullable Long defaultTimestamp;
    private @Nullable Integer nowInSeconds;
    private @Nullable String defaultKeyspace;
    private @Nullable Map<String, ByteBuffer> customPayload;
    private boolean skipMetadataInResult;
    private boolean tracingRequested;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Parameters} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Parameters instance) {
      Objects.requireNonNull(instance, "instance");
      protocolVersion(instance.protocolVersion());
      OptionalInt pageSizeOptional = instance.pageSize();
      if (pageSizeOptional.isPresent()) {
        pageSize(pageSizeOptional);
      }
      Optional<ByteBuffer> pagingStateOptional = instance.pagingState();
      if (pagingStateOptional.isPresent()) {
        pagingState(pagingStateOptional);
      }
      consistencyLevel(instance.consistencyLevel());
      Optional<ConsistencyLevel> serialConsistencyLevelOptional = instance.serialConsistencyLevel();
      if (serialConsistencyLevelOptional.isPresent()) {
        serialConsistencyLevel(serialConsistencyLevelOptional);
      }
      OptionalLong defaultTimestampOptional = instance.defaultTimestamp();
      if (defaultTimestampOptional.isPresent()) {
        defaultTimestamp(defaultTimestampOptional);
      }
      OptionalInt nowInSecondsOptional = instance.nowInSeconds();
      if (nowInSecondsOptional.isPresent()) {
        nowInSeconds(nowInSecondsOptional);
      }
      Optional<String> defaultKeyspaceOptional = instance.defaultKeyspace();
      if (defaultKeyspaceOptional.isPresent()) {
        defaultKeyspace(defaultKeyspaceOptional);
      }
      Optional<Map<String, ByteBuffer>> customPayloadOptional = instance.customPayload();
      if (customPayloadOptional.isPresent()) {
        customPayload(customPayloadOptional);
      }
      skipMetadataInResult(instance.skipMetadataInResult());
      tracingRequested(instance.tracingRequested());
      return this;
    }

    /**
     * Initializes the value for the {@link Parameters#protocolVersion() protocolVersion} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Parameters#protocolVersion() protocolVersion}.</em>
     * @param protocolVersion The value for protocolVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder protocolVersion(ProtocolVersion protocolVersion) {
      this.protocolVersion = Objects.requireNonNull(protocolVersion, "protocolVersion");
      return this;
    }

    /**
     * Initializes the optional value {@link Parameters#pageSize() pageSize} to pageSize.
     * @param pageSize The value for pageSize
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pageSize(int pageSize) {
      this.pageSize = pageSize;
      return this;
    }

    /**
     * Initializes the optional value {@link Parameters#pageSize() pageSize} to pageSize.
     * @param pageSize The value for pageSize
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pageSize(OptionalInt pageSize) {
      this.pageSize = pageSize.isPresent() ? pageSize.getAsInt() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link Parameters#pagingState() pagingState} to pagingState.
     * @param pagingState The value for pagingState
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pagingState(ByteBuffer pagingState) {
      this.pagingState = Objects.requireNonNull(pagingState, "pagingState");
      return this;
    }

    /**
     * Initializes the optional value {@link Parameters#pagingState() pagingState} to pagingState.
     * @param pagingState The value for pagingState
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pagingState(Optional<? extends ByteBuffer> pagingState) {
      this.pagingState = pagingState.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Parameters#consistencyLevel() consistencyLevel} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Parameters#consistencyLevel() consistencyLevel}.</em>
     * @param consistencyLevel The value for consistencyLevel 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
      this.consistencyLevel = Objects.requireNonNull(consistencyLevel, "consistencyLevel");
      return this;
    }

    /**
     * Initializes the optional value {@link Parameters#serialConsistencyLevel() serialConsistencyLevel} to serialConsistencyLevel.
     * @param serialConsistencyLevel The value for serialConsistencyLevel
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder serialConsistencyLevel(ConsistencyLevel serialConsistencyLevel) {
      this.serialConsistencyLevel = Objects.requireNonNull(serialConsistencyLevel, "serialConsistencyLevel");
      return this;
    }

    /**
     * Initializes the optional value {@link Parameters#serialConsistencyLevel() serialConsistencyLevel} to serialConsistencyLevel.
     * @param serialConsistencyLevel The value for serialConsistencyLevel
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder serialConsistencyLevel(Optional<? extends ConsistencyLevel> serialConsistencyLevel) {
      this.serialConsistencyLevel = serialConsistencyLevel.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Parameters#defaultTimestamp() defaultTimestamp} to defaultTimestamp.
     * @param defaultTimestamp The value for defaultTimestamp
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultTimestamp(long defaultTimestamp) {
      this.defaultTimestamp = defaultTimestamp;
      return this;
    }

    /**
     * Initializes the optional value {@link Parameters#defaultTimestamp() defaultTimestamp} to defaultTimestamp.
     * @param defaultTimestamp The value for defaultTimestamp
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultTimestamp(OptionalLong defaultTimestamp) {
      this.defaultTimestamp = defaultTimestamp.isPresent() ? defaultTimestamp.getAsLong() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link Parameters#nowInSeconds() nowInSeconds} to nowInSeconds.
     * @param nowInSeconds The value for nowInSeconds
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nowInSeconds(int nowInSeconds) {
      this.nowInSeconds = nowInSeconds;
      return this;
    }

    /**
     * Initializes the optional value {@link Parameters#nowInSeconds() nowInSeconds} to nowInSeconds.
     * @param nowInSeconds The value for nowInSeconds
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nowInSeconds(OptionalInt nowInSeconds) {
      this.nowInSeconds = nowInSeconds.isPresent() ? nowInSeconds.getAsInt() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link Parameters#defaultKeyspace() defaultKeyspace} to defaultKeyspace.
     * @param defaultKeyspace The value for defaultKeyspace
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultKeyspace(String defaultKeyspace) {
      this.defaultKeyspace = Objects.requireNonNull(defaultKeyspace, "defaultKeyspace");
      return this;
    }

    /**
     * Initializes the optional value {@link Parameters#defaultKeyspace() defaultKeyspace} to defaultKeyspace.
     * @param defaultKeyspace The value for defaultKeyspace
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultKeyspace(Optional<String> defaultKeyspace) {
      this.defaultKeyspace = defaultKeyspace.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Parameters#customPayload() customPayload} to customPayload.
     * @param customPayload The value for customPayload
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder customPayload(Map<String, ByteBuffer> customPayload) {
      this.customPayload = Objects.requireNonNull(customPayload, "customPayload");
      return this;
    }

    /**
     * Initializes the optional value {@link Parameters#customPayload() customPayload} to customPayload.
     * @param customPayload The value for customPayload
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder customPayload(Optional<? extends Map<String, ByteBuffer>> customPayload) {
      this.customPayload = customPayload.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Parameters#skipMetadataInResult() skipMetadataInResult} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Parameters#skipMetadataInResult() skipMetadataInResult}.</em>
     * @param skipMetadataInResult The value for skipMetadataInResult 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder skipMetadataInResult(boolean skipMetadataInResult) {
      this.skipMetadataInResult = skipMetadataInResult;
      optBits |= OPT_BIT_SKIP_METADATA_IN_RESULT;
      return this;
    }

    /**
     * Initializes the value for the {@link Parameters#tracingRequested() tracingRequested} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Parameters#tracingRequested() tracingRequested}.</em>
     * @param tracingRequested The value for tracingRequested 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tracingRequested(boolean tracingRequested) {
      this.tracingRequested = tracingRequested;
      optBits |= OPT_BIT_TRACING_REQUESTED;
      return this;
    }

    /**
     * Builds a new {@link ImmutableParameters ImmutableParameters}.
     * @return An immutable instance of Parameters
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableParameters build() {
      return ImmutableParameters.validate(new ImmutableParameters(this));
    }

    private boolean skipMetadataInResultIsSet() {
      return (optBits & OPT_BIT_SKIP_METADATA_IN_RESULT) != 0;
    }

    private boolean tracingRequestedIsSet() {
      return (optBits & OPT_BIT_TRACING_REQUESTED) != 0;
    }
  }
}
