package io.stargate.db.datastore;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.Parameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DataStoreOptions}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDataStoreOptions.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableDataStoreOptions.of()}.
 */
@Generated(from = "DataStoreOptions", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDataStoreOptions extends DataStoreOptions {
  private final Parameters defaultParameters;
  private final boolean alwaysPrepareQueries;
  private final Map<String, String> customProperties;

  private ImmutableDataStoreOptions() {
    this.defaultParameters = initShim.defaultParameters();
    this.alwaysPrepareQueries = initShim.alwaysPrepareQueries();
    this.customProperties = initShim.customProperties();
    this.initShim = null;
  }

  private ImmutableDataStoreOptions(ImmutableDataStoreOptions.Builder builder) {
    if (builder.defaultParameters != null) {
      initShim.defaultParameters(builder.defaultParameters);
    }
    if (builder.alwaysPrepareQueriesIsSet()) {
      initShim.alwaysPrepareQueries(builder.alwaysPrepareQueries);
    }
    if (builder.customPropertiesIsSet()) {
      initShim.customProperties(createUnmodifiableMap(false, false, builder.customProperties));
    }
    this.defaultParameters = initShim.defaultParameters();
    this.alwaysPrepareQueries = initShim.alwaysPrepareQueries();
    this.customProperties = initShim.customProperties();
    this.initShim = null;
  }

  private ImmutableDataStoreOptions(
      Parameters defaultParameters,
      boolean alwaysPrepareQueries,
      Map<String, String> customProperties) {
    this.defaultParameters = defaultParameters;
    this.alwaysPrepareQueries = alwaysPrepareQueries;
    this.customProperties = customProperties;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "DataStoreOptions", generator = "Immutables")
  private final class InitShim {
    private byte defaultParametersBuildStage = STAGE_UNINITIALIZED;
    private Parameters defaultParameters;

    Parameters defaultParameters() {
      if (defaultParametersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (defaultParametersBuildStage == STAGE_UNINITIALIZED) {
        defaultParametersBuildStage = STAGE_INITIALIZING;
        this.defaultParameters = Objects.requireNonNull(ImmutableDataStoreOptions.super.defaultParameters(), "defaultParameters");
        defaultParametersBuildStage = STAGE_INITIALIZED;
      }
      return this.defaultParameters;
    }

    void defaultParameters(Parameters defaultParameters) {
      this.defaultParameters = defaultParameters;
      defaultParametersBuildStage = STAGE_INITIALIZED;
    }

    private byte alwaysPrepareQueriesBuildStage = STAGE_UNINITIALIZED;
    private boolean alwaysPrepareQueries;

    boolean alwaysPrepareQueries() {
      if (alwaysPrepareQueriesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (alwaysPrepareQueriesBuildStage == STAGE_UNINITIALIZED) {
        alwaysPrepareQueriesBuildStage = STAGE_INITIALIZING;
        this.alwaysPrepareQueries = ImmutableDataStoreOptions.super.alwaysPrepareQueries();
        alwaysPrepareQueriesBuildStage = STAGE_INITIALIZED;
      }
      return this.alwaysPrepareQueries;
    }

    void alwaysPrepareQueries(boolean alwaysPrepareQueries) {
      this.alwaysPrepareQueries = alwaysPrepareQueries;
      alwaysPrepareQueriesBuildStage = STAGE_INITIALIZED;
    }

    private byte customPropertiesBuildStage = STAGE_UNINITIALIZED;
    private Map<String, String> customProperties;

    Map<String, String> customProperties() {
      if (customPropertiesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (customPropertiesBuildStage == STAGE_UNINITIALIZED) {
        customPropertiesBuildStage = STAGE_INITIALIZING;
        this.customProperties = createUnmodifiableMap(true, false, ImmutableDataStoreOptions.super.customProperties());
        customPropertiesBuildStage = STAGE_INITIALIZED;
      }
      return this.customProperties;
    }

    void customProperties(Map<String, String> customProperties) {
      this.customProperties = customProperties;
      customPropertiesBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (defaultParametersBuildStage == STAGE_INITIALIZING) attributes.add("defaultParameters");
      if (alwaysPrepareQueriesBuildStage == STAGE_INITIALIZING) attributes.add("alwaysPrepareQueries");
      if (customPropertiesBuildStage == STAGE_INITIALIZING) attributes.add("customProperties");
      return "Cannot build DataStoreOptions, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * The default parameters use by the datastore for execution (those can be overridden
   * per-execution, see {@link DataStore#execute(BoundQuery, UnaryOperator)}).
   */
  @Override
  public Parameters defaultParameters() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.defaultParameters()
        : this.defaultParameters;
  }

  /**
   * If {@code true}, the datastore will internally prepare non-prepared query it is passed before
   * execution.
   * <p>This can save time query parsing when queries are built at execution time (not manually
   * prepared) as query preparation first check if the query isn't already prepared and return
   * immediately if they are (and that check is faster than parsing). Of course, if the queries
   * executed are one-offs, this option is undesirable (adds a bit of latency for the preparation
   * without saving parsing, and can unnecessary pollute the prepared statement cache). But do note
   * that queries built through {@link DataStore#queryBuilder()} always prepare queries with no
   * values at all (even if values are passed at construction time), so this option is unlikely to
   * be very problematic with those queries (at worst, it's a minor inefficiency).
   */
  @Override
  public boolean alwaysPrepareQueries() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.alwaysPrepareQueries()
        : this.alwaysPrepareQueries;
  }

  /**
   * @return The value of the {@code customProperties} attribute
   */
  @Override
  public Map<String, String> customProperties() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.customProperties()
        : this.customProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataStoreOptions#defaultParameters() defaultParameters} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultParameters
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataStoreOptions withDefaultParameters(Parameters value) {
    if (this.defaultParameters == value) return this;
    Parameters newValue = Objects.requireNonNull(value, "defaultParameters");
    return validate(new ImmutableDataStoreOptions(newValue, this.alwaysPrepareQueries, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataStoreOptions#alwaysPrepareQueries() alwaysPrepareQueries} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for alwaysPrepareQueries
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataStoreOptions withAlwaysPrepareQueries(boolean value) {
    if (this.alwaysPrepareQueries == value) return this;
    return validate(new ImmutableDataStoreOptions(this.defaultParameters, value, this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link DataStoreOptions#customProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataStoreOptions withCustomProperties(Map<String, ? extends String> entries) {
    if (this.customProperties == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return validate(new ImmutableDataStoreOptions(this.defaultParameters, this.alwaysPrepareQueries, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDataStoreOptions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDataStoreOptions
        && equalTo((ImmutableDataStoreOptions) another);
  }

  private boolean equalTo(ImmutableDataStoreOptions another) {
    return defaultParameters.equals(another.defaultParameters)
        && alwaysPrepareQueries == another.alwaysPrepareQueries
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code defaultParameters}, {@code alwaysPrepareQueries}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + defaultParameters.hashCode();
    h += (h << 5) + Boolean.hashCode(alwaysPrepareQueries);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  private static final ImmutableDataStoreOptions INSTANCE = validate(new ImmutableDataStoreOptions());

  /**
   * Returns the default immutable singleton value of {@code DataStoreOptions}
   * @return An immutable instance of DataStoreOptions
   */
  public static ImmutableDataStoreOptions of() {
    return INSTANCE;
  }

  private static ImmutableDataStoreOptions validate(ImmutableDataStoreOptions instance) {
    return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link DataStoreOptions} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DataStoreOptions instance
   */
  public static ImmutableDataStoreOptions copyOf(DataStoreOptions instance) {
    if (instance instanceof ImmutableDataStoreOptions) {
      return (ImmutableDataStoreOptions) instance;
    }
    return ImmutableDataStoreOptions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDataStoreOptions ImmutableDataStoreOptions}.
   * <pre>
   * ImmutableDataStoreOptions.builder()
   *    .defaultParameters(io.stargate.db.Parameters) // optional {@link DataStoreOptions#defaultParameters() defaultParameters}
   *    .alwaysPrepareQueries(boolean) // optional {@link DataStoreOptions#alwaysPrepareQueries() alwaysPrepareQueries}
   *    .putCustomProperties|putAllCustomProperties(String =&gt; String) // {@link DataStoreOptions#customProperties() customProperties} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableDataStoreOptions builder
   */
  public static ImmutableDataStoreOptions.Builder builder() {
    return new ImmutableDataStoreOptions.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDataStoreOptions ImmutableDataStoreOptions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DataStoreOptions", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_ALWAYS_PREPARE_QUERIES = 0x1L;
    private static final long OPT_BIT_CUSTOM_PROPERTIES = 0x2L;
    private long optBits;

    private @Nullable Parameters defaultParameters;
    private boolean alwaysPrepareQueries;
    private Map<String, String> customProperties = new LinkedHashMap<String, String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DataStoreOptions} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DataStoreOptions instance) {
      Objects.requireNonNull(instance, "instance");
      defaultParameters(instance.defaultParameters());
      alwaysPrepareQueries(instance.alwaysPrepareQueries());
      putAllCustomProperties(instance.customProperties());
      return this;
    }

    /**
     * Initializes the value for the {@link DataStoreOptions#defaultParameters() defaultParameters} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DataStoreOptions#defaultParameters() defaultParameters}.</em>
     * @param defaultParameters The value for defaultParameters 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultParameters(Parameters defaultParameters) {
      this.defaultParameters = Objects.requireNonNull(defaultParameters, "defaultParameters");
      return this;
    }

    /**
     * Initializes the value for the {@link DataStoreOptions#alwaysPrepareQueries() alwaysPrepareQueries} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DataStoreOptions#alwaysPrepareQueries() alwaysPrepareQueries}.</em>
     * @param alwaysPrepareQueries The value for alwaysPrepareQueries 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder alwaysPrepareQueries(boolean alwaysPrepareQueries) {
      this.alwaysPrepareQueries = alwaysPrepareQueries;
      optBits |= OPT_BIT_ALWAYS_PREPARE_QUERIES;
      return this;
    }

    /**
     * Put one entry to the {@link DataStoreOptions#customProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperties(String key, String value) {
      this.customProperties.put(
          Objects.requireNonNull(key, "customProperties key"),
          Objects.requireNonNull(value, "customProperties value"));
      optBits |= OPT_BIT_CUSTOM_PROPERTIES;
      return this;
    }

    /**
     * Put one entry to the {@link DataStoreOptions#customProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperties(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.customProperties.put(
          Objects.requireNonNull(k, "customProperties key"),
          Objects.requireNonNull(v, "customProperties value"));
      optBits |= OPT_BIT_CUSTOM_PROPERTIES;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DataStoreOptions#customProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder customProperties(Map<String, ? extends String> entries) {
      this.customProperties.clear();
      optBits |= OPT_BIT_CUSTOM_PROPERTIES;
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DataStoreOptions#customProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.customProperties.put(
            Objects.requireNonNull(k, "customProperties key"),
            Objects.requireNonNull(v, "customProperties value"));
      }
      optBits |= OPT_BIT_CUSTOM_PROPERTIES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDataStoreOptions ImmutableDataStoreOptions}.
     * @return An immutable instance of DataStoreOptions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDataStoreOptions build() {
      return ImmutableDataStoreOptions.validate(new ImmutableDataStoreOptions(this));
    }

    private boolean alwaysPrepareQueriesIsSet() {
      return (optBits & OPT_BIT_ALWAYS_PREPARE_QUERIES) != 0;
    }

    private boolean customPropertiesIsSet() {
      return (optBits & OPT_BIT_CUSTOM_PROPERTIES) != 0;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
