package io.stargate.db.query;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.schema.Column;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BindMarker}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBindMarker.builder()}.
 */
@Generated(from = "BindMarker", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableBindMarker implements BindMarker {
  private final String receiver;
  private final Column.ColumnType type;

  private ImmutableBindMarker(String receiver, Column.ColumnType type) {
    this.receiver = receiver;
    this.type = type;
  }

  /**
   * @return The value of the {@code receiver} attribute
   */
  @Override
  public String receiver() {
    return receiver;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public Column.ColumnType type() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BindMarker#receiver() receiver} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for receiver
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBindMarker withReceiver(String value) {
    String newValue = Objects.requireNonNull(value, "receiver");
    if (this.receiver.equals(newValue)) return this;
    return new ImmutableBindMarker(newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BindMarker#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBindMarker withType(Column.ColumnType value) {
    if (this.type == value) return this;
    Column.ColumnType newValue = Objects.requireNonNull(value, "type");
    return new ImmutableBindMarker(this.receiver, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBindMarker} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBindMarker
        && equalTo((ImmutableBindMarker) another);
  }

  private boolean equalTo(ImmutableBindMarker another) {
    return receiver.equals(another.receiver)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code receiver}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + receiver.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BindMarker} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BindMarker{"
        + "receiver=" + receiver
        + ", type=" + type
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link BindMarker} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BindMarker instance
   */
  public static ImmutableBindMarker copyOf(BindMarker instance) {
    if (instance instanceof ImmutableBindMarker) {
      return (ImmutableBindMarker) instance;
    }
    return ImmutableBindMarker.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBindMarker ImmutableBindMarker}.
   * <pre>
   * ImmutableBindMarker.builder()
   *    .receiver(String) // required {@link BindMarker#receiver() receiver}
   *    .type(io.stargate.db.schema.Column.ColumnType) // required {@link BindMarker#type() type}
   *    .build();
   * </pre>
   * @return A new ImmutableBindMarker builder
   */
  public static ImmutableBindMarker.Builder builder() {
    return new ImmutableBindMarker.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBindMarker ImmutableBindMarker}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BindMarker", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_RECEIVER = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String receiver;
    private @Nullable Column.ColumnType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BindMarker} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BindMarker instance) {
      Objects.requireNonNull(instance, "instance");
      receiver(instance.receiver());
      type(instance.type());
      return this;
    }

    /**
     * Initializes the value for the {@link BindMarker#receiver() receiver} attribute.
     * @param receiver The value for receiver 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder receiver(String receiver) {
      this.receiver = Objects.requireNonNull(receiver, "receiver");
      initBits &= ~INIT_BIT_RECEIVER;
      return this;
    }

    /**
     * Initializes the value for the {@link BindMarker#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(Column.ColumnType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBindMarker ImmutableBindMarker}.
     * @return An immutable instance of BindMarker
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBindMarker build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBindMarker(receiver, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RECEIVER) != 0) attributes.add("receiver");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build BindMarker, some of required attributes are not set " + attributes;
    }
  }
}
