package io.stargate.db.query;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Condition}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCondition.builder()}.
 */
@Generated(from = "Condition", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCondition implements Condition {
  private final Condition.LHS lhs;
  private final Predicate predicate;
  private final @Nullable TypedValue value;

  private ImmutableCondition(
      Condition.LHS lhs,
      Predicate predicate,
      @Nullable TypedValue value) {
    this.lhs = lhs;
    this.predicate = predicate;
    this.value = value;
  }

  /**
   * @return The value of the {@code lhs} attribute
   */
  @Override
  public Condition.LHS lhs() {
    return lhs;
  }

  /**
   * @return The value of the {@code predicate} attribute
   */
  @Override
  public Predicate predicate() {
    return predicate;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public @Nullable TypedValue value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Condition#lhs() lhs} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lhs
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCondition withLhs(Condition.LHS value) {
    if (this.lhs == value) return this;
    Condition.LHS newValue = Objects.requireNonNull(value, "lhs");
    return new ImmutableCondition(newValue, this.predicate, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Condition#predicate() predicate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for predicate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCondition withPredicate(Predicate value) {
    if (this.predicate == value) return this;
    Predicate newValue = Objects.requireNonNull(value, "predicate");
    if (this.predicate.equals(newValue)) return this;
    return new ImmutableCondition(this.lhs, newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Condition#value() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCondition withValue(@Nullable TypedValue value) {
    if (this.value == value) return this;
    return new ImmutableCondition(this.lhs, this.predicate, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCondition} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCondition
        && equalTo((ImmutableCondition) another);
  }

  private boolean equalTo(ImmutableCondition another) {
    return lhs.equals(another.lhs)
        && predicate.equals(another.predicate)
        && Objects.equals(value, another.value);
  }

  /**
   * Computes a hash code from attributes: {@code lhs}, {@code predicate}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + lhs.hashCode();
    h += (h << 5) + predicate.hashCode();
    h += (h << 5) + Objects.hashCode(value);
    return h;
  }

  /**
   * Prints the immutable value {@code Condition} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Condition{"
        + "lhs=" + lhs
        + ", predicate=" + predicate
        + ", value=" + value
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Condition} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Condition instance
   */
  public static ImmutableCondition copyOf(Condition instance) {
    if (instance instanceof ImmutableCondition) {
      return (ImmutableCondition) instance;
    }
    return ImmutableCondition.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCondition ImmutableCondition}.
   * <pre>
   * ImmutableCondition.builder()
   *    .lhs(io.stargate.db.query.Condition.LHS) // required {@link Condition#lhs() lhs}
   *    .predicate(io.stargate.db.query.Predicate) // required {@link Condition#predicate() predicate}
   *    .value(io.stargate.db.query.TypedValue | null) // nullable {@link Condition#value() value}
   *    .build();
   * </pre>
   * @return A new ImmutableCondition builder
   */
  public static ImmutableCondition.Builder builder() {
    return new ImmutableCondition.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCondition ImmutableCondition}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Condition", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_LHS = 0x1L;
    private static final long INIT_BIT_PREDICATE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Condition.LHS lhs;
    private @Nullable Predicate predicate;
    private @Nullable TypedValue value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Condition} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Condition instance) {
      Objects.requireNonNull(instance, "instance");
      lhs(instance.lhs());
      predicate(instance.predicate());
      @Nullable TypedValue valueValue = instance.value();
      if (valueValue != null) {
        value(valueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Condition#lhs() lhs} attribute.
     * @param lhs The value for lhs 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder lhs(Condition.LHS lhs) {
      this.lhs = Objects.requireNonNull(lhs, "lhs");
      initBits &= ~INIT_BIT_LHS;
      return this;
    }

    /**
     * Initializes the value for the {@link Condition#predicate() predicate} attribute.
     * @param predicate The value for predicate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder predicate(Predicate predicate) {
      this.predicate = Objects.requireNonNull(predicate, "predicate");
      initBits &= ~INIT_BIT_PREDICATE;
      return this;
    }

    /**
     * Initializes the value for the {@link Condition#value() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(@Nullable TypedValue value) {
      this.value = value;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCondition ImmutableCondition}.
     * @return An immutable instance of Condition
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCondition build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCondition(lhs, predicate, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LHS) != 0) attributes.add("lhs");
      if ((initBits & INIT_BIT_PREDICATE) != 0) attributes.add("predicate");
      return "Cannot build Condition, some of required attributes are not set " + attributes;
    }
  }
}
