package io.stargate.db.query;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Modification}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableModification.builder()}.
 */
@Generated(from = "Modification", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableModification implements Modification {
  private final ModifiableEntity entity;
  private final Modification.Operation operation;
  private final @Nullable TypedValue value;

  private ImmutableModification(
      ModifiableEntity entity,
      Modification.Operation operation,
      @Nullable TypedValue value) {
    this.entity = entity;
    this.operation = operation;
    this.value = value;
  }

  /**
   * @return The value of the {@code entity} attribute
   */
  @Override
  public ModifiableEntity entity() {
    return entity;
  }

  /**
   * @return The value of the {@code operation} attribute
   */
  @Override
  public Modification.Operation operation() {
    return operation;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public @Nullable TypedValue value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Modification#entity() entity} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for entity
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModification withEntity(ModifiableEntity value) {
    if (this.entity == value) return this;
    ModifiableEntity newValue = Objects.requireNonNull(value, "entity");
    return new ImmutableModification(newValue, this.operation, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Modification#operation() operation} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for operation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModification withOperation(Modification.Operation value) {
    if (this.operation == value) return this;
    Modification.Operation newValue = Objects.requireNonNull(value, "operation");
    if (this.operation.equals(newValue)) return this;
    return new ImmutableModification(this.entity, newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Modification#value() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModification withValue(@Nullable TypedValue value) {
    if (this.value == value) return this;
    return new ImmutableModification(this.entity, this.operation, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableModification} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableModification
        && equalTo((ImmutableModification) another);
  }

  private boolean equalTo(ImmutableModification another) {
    return entity.equals(another.entity)
        && operation.equals(another.operation)
        && Objects.equals(value, another.value);
  }

  /**
   * Computes a hash code from attributes: {@code entity}, {@code operation}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + entity.hashCode();
    h += (h << 5) + operation.hashCode();
    h += (h << 5) + Objects.hashCode(value);
    return h;
  }

  /**
   * Prints the immutable value {@code Modification} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Modification{"
        + "entity=" + entity
        + ", operation=" + operation
        + ", value=" + value
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Modification} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Modification instance
   */
  public static ImmutableModification copyOf(Modification instance) {
    if (instance instanceof ImmutableModification) {
      return (ImmutableModification) instance;
    }
    return ImmutableModification.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableModification ImmutableModification}.
   * <pre>
   * ImmutableModification.builder()
   *    .entity(io.stargate.db.query.ModifiableEntity) // required {@link Modification#entity() entity}
   *    .operation(io.stargate.db.query.Modification.Operation) // required {@link Modification#operation() operation}
   *    .value(io.stargate.db.query.TypedValue | null) // nullable {@link Modification#value() value}
   *    .build();
   * </pre>
   * @return A new ImmutableModification builder
   */
  public static ImmutableModification.Builder builder() {
    return new ImmutableModification.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableModification ImmutableModification}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Modification", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ENTITY = 0x1L;
    private static final long INIT_BIT_OPERATION = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ModifiableEntity entity;
    private @Nullable Modification.Operation operation;
    private @Nullable TypedValue value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Modification} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Modification instance) {
      Objects.requireNonNull(instance, "instance");
      entity(instance.entity());
      operation(instance.operation());
      @Nullable TypedValue valueValue = instance.value();
      if (valueValue != null) {
        value(valueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Modification#entity() entity} attribute.
     * @param entity The value for entity 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder entity(ModifiableEntity entity) {
      this.entity = Objects.requireNonNull(entity, "entity");
      initBits &= ~INIT_BIT_ENTITY;
      return this;
    }

    /**
     * Initializes the value for the {@link Modification#operation() operation} attribute.
     * @param operation The value for operation 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder operation(Modification.Operation operation) {
      this.operation = Objects.requireNonNull(operation, "operation");
      initBits &= ~INIT_BIT_OPERATION;
      return this;
    }

    /**
     * Initializes the value for the {@link Modification#value() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(@Nullable TypedValue value) {
      this.value = value;
      return this;
    }

    /**
     * Builds a new {@link ImmutableModification ImmutableModification}.
     * @return An immutable instance of Modification
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableModification build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableModification(entity, operation, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ENTITY) != 0) attributes.add("entity");
      if ((initBits & INIT_BIT_OPERATION) != 0) attributes.add("operation");
      return "Cannot build Modification, some of required attributes are not set " + attributes;
    }
  }
}
