package io.stargate.db.query.builder;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.schema.Column;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ColumnOrder}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableColumnOrder.builder()}.
 */
@Generated(from = "ColumnOrder", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableColumnOrder extends ColumnOrder {
  private final String column;
  private final Column.Order order;
  private transient final int hashCode;

  private ImmutableColumnOrder(String column, Column.Order order) {
    this.column = column;
    this.order = order;
    this.hashCode = computeHashCode();
  }

  /**
   * @return The value of the {@code column} attribute
   */
  @Override
  public String column() {
    return column;
  }

  /**
   * @return The value of the {@code order} attribute
   */
  @Override
  public Column.Order order() {
    return order;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ColumnOrder#column() column} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for column
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumnOrder withColumn(String value) {
    String newValue = Objects.requireNonNull(value, "column");
    if (this.column.equals(newValue)) return this;
    return new ImmutableColumnOrder(newValue, this.order);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ColumnOrder#order() order} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for order
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumnOrder withOrder(Column.Order value) {
    if (this.order == value) return this;
    Column.Order newValue = Objects.requireNonNull(value, "order");
    if (this.order.equals(newValue)) return this;
    return new ImmutableColumnOrder(this.column, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableColumnOrder} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableColumnOrder
        && equalTo((ImmutableColumnOrder) another);
  }

  private boolean equalTo(ImmutableColumnOrder another) {
    if (hashCode != another.hashCode) return false;
    return column.equals(another.column)
        && order.equals(another.order);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code column}, {@code order}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + column.hashCode();
    h += (h << 5) + order.hashCode();
    return h;
  }

  /**
   * Creates an immutable copy of a {@link ColumnOrder} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ColumnOrder instance
   */
  public static ImmutableColumnOrder copyOf(ColumnOrder instance) {
    if (instance instanceof ImmutableColumnOrder) {
      return (ImmutableColumnOrder) instance;
    }
    return ImmutableColumnOrder.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableColumnOrder ImmutableColumnOrder}.
   * <pre>
   * ImmutableColumnOrder.builder()
   *    .column(String) // required {@link ColumnOrder#column() column}
   *    .order(io.stargate.db.schema.Column.Order) // required {@link ColumnOrder#order() order}
   *    .build();
   * </pre>
   * @return A new ImmutableColumnOrder builder
   */
  public static ImmutableColumnOrder.Builder builder() {
    return new ImmutableColumnOrder.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableColumnOrder ImmutableColumnOrder}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ColumnOrder", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_COLUMN = 0x1L;
    private static final long INIT_BIT_ORDER = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String column;
    private @Nullable Column.Order order;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ColumnOrder} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ColumnOrder instance) {
      Objects.requireNonNull(instance, "instance");
      column(instance.column());
      order(instance.order());
      return this;
    }

    /**
     * Initializes the value for the {@link ColumnOrder#column() column} attribute.
     * @param column The value for column 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder column(String column) {
      this.column = Objects.requireNonNull(column, "column");
      initBits &= ~INIT_BIT_COLUMN;
      return this;
    }

    /**
     * Initializes the value for the {@link ColumnOrder#order() order} attribute.
     * @param order The value for order 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder order(Column.Order order) {
      this.order = Objects.requireNonNull(order, "order");
      initBits &= ~INIT_BIT_ORDER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableColumnOrder ImmutableColumnOrder}.
     * @return An immutable instance of ColumnOrder
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableColumnOrder build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableColumnOrder(column, order);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_COLUMN) != 0) attributes.add("column");
      if ((initBits & INIT_BIT_ORDER) != 0) attributes.add("order");
      return "Cannot build ColumnOrder, some of required attributes are not set " + attributes;
    }
  }
}
