package io.stargate.db.query.builder;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ValueModifier.Target}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTarget.builder()}.
 */
@Generated(from = "ValueModifier.Target", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableTarget extends ValueModifier.Target {
  private final String columnName;
  private final @Nullable String fieldName;
  private final @Nullable Value<?> mapKey;

  private ImmutableTarget(
      String columnName,
      @Nullable String fieldName,
      @Nullable Value<?> mapKey) {
    this.columnName = columnName;
    this.fieldName = fieldName;
    this.mapKey = mapKey;
  }

  /**
   * @return The value of the {@code columnName} attribute
   */
  @Override
  String columnName() {
    return columnName;
  }

  /**
   * @return The value of the {@code fieldName} attribute
   */
  @Override
  @Nullable String fieldName() {
    return fieldName;
  }

  /**
   * @return The value of the {@code mapKey} attribute
   */
  @Override
  @Nullable Value<?> mapKey() {
    return mapKey;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueModifier.Target#columnName() columnName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for columnName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTarget withColumnName(String value) {
    String newValue = Objects.requireNonNull(value, "columnName");
    if (this.columnName.equals(newValue)) return this;
    return new ImmutableTarget(newValue, this.fieldName, this.mapKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueModifier.Target#fieldName() fieldName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fieldName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTarget withFieldName(@Nullable String value) {
    if (Objects.equals(this.fieldName, value)) return this;
    return new ImmutableTarget(this.columnName, value, this.mapKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueModifier.Target#mapKey() mapKey} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mapKey (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTarget withMapKey(@Nullable Value<?> value) {
    if (this.mapKey == value) return this;
    return new ImmutableTarget(this.columnName, this.fieldName, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTarget} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTarget
        && equalTo((ImmutableTarget) another);
  }

  private boolean equalTo(ImmutableTarget another) {
    return columnName.equals(another.columnName)
        && Objects.equals(fieldName, another.fieldName)
        && Objects.equals(mapKey, another.mapKey);
  }

  /**
   * Computes a hash code from attributes: {@code columnName}, {@code fieldName}, {@code mapKey}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + columnName.hashCode();
    h += (h << 5) + Objects.hashCode(fieldName);
    h += (h << 5) + Objects.hashCode(mapKey);
    return h;
  }

  /**
   * Prints the immutable value {@code Target} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Target{"
        + "columnName=" + columnName
        + ", fieldName=" + fieldName
        + ", mapKey=" + mapKey
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ValueModifier.Target} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Target instance
   */
  public static ImmutableTarget copyOf(ValueModifier.Target instance) {
    if (instance instanceof ImmutableTarget) {
      return (ImmutableTarget) instance;
    }
    return ImmutableTarget.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTarget ImmutableTarget}.
   * <pre>
   * ImmutableTarget.builder()
   *    .columnName(String) // required {@link ValueModifier.Target#columnName() columnName}
   *    .fieldName(String | null) // nullable {@link ValueModifier.Target#fieldName() fieldName}
   *    .mapKey(io.stargate.db.query.builder.Value&amp;lt;?&amp;gt; | null) // nullable {@link ValueModifier.Target#mapKey() mapKey}
   *    .build();
   * </pre>
   * @return A new ImmutableTarget builder
   */
  public static ImmutableTarget.Builder builder() {
    return new ImmutableTarget.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTarget ImmutableTarget}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ValueModifier.Target", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_COLUMN_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String columnName;
    private @Nullable String fieldName;
    private @Nullable Value<?> mapKey;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Target} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ValueModifier.Target instance) {
      Objects.requireNonNull(instance, "instance");
      columnName(instance.columnName());
      @Nullable String fieldNameValue = instance.fieldName();
      if (fieldNameValue != null) {
        fieldName(fieldNameValue);
      }
      @Nullable Value<?> mapKeyValue = instance.mapKey();
      if (mapKeyValue != null) {
        mapKey(mapKeyValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ValueModifier.Target#columnName() columnName} attribute.
     * @param columnName The value for columnName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder columnName(String columnName) {
      this.columnName = Objects.requireNonNull(columnName, "columnName");
      initBits &= ~INIT_BIT_COLUMN_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ValueModifier.Target#fieldName() fieldName} attribute.
     * @param fieldName The value for fieldName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder fieldName(@Nullable String fieldName) {
      this.fieldName = fieldName;
      return this;
    }

    /**
     * Initializes the value for the {@link ValueModifier.Target#mapKey() mapKey} attribute.
     * @param mapKey The value for mapKey (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mapKey(@Nullable Value<?> mapKey) {
      this.mapKey = mapKey;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTarget ImmutableTarget}.
     * @return An immutable instance of Target
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTarget build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTarget(columnName, fieldName, mapKey);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_COLUMN_NAME) != 0) attributes.add("columnName");
      return "Cannot build Target, some of required attributes are not set " + attributes;
    }
  }
}
