package io.stargate.db.schema;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ColumnUtils.Codecs}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCodecs.builder()}.
 */
@Generated(from = "ColumnUtils.Codecs", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableCodecs extends ColumnUtils.Codecs {
  private final TypeCodec codec;
  private transient final int hashCode;

  private ImmutableCodecs(TypeCodec codec) {
    this.codec = codec;
    this.hashCode = computeHashCode();
  }

  /**
   * @return The value of the {@code codec} attribute
   */
  @Override
  TypeCodec codec() {
    return codec;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ColumnUtils.Codecs#codec() codec} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for codec
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCodecs withCodec(TypeCodec value) {
    if (this.codec == value) return this;
    TypeCodec newValue = Objects.requireNonNull(value, "codec");
    return new ImmutableCodecs(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCodecs} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCodecs
        && equalTo((ImmutableCodecs) another);
  }

  private boolean equalTo(ImmutableCodecs another) {
    if (hashCode != another.hashCode) return false;
    return codec.equals(another.codec);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code codec}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + codec.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Codecs} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Codecs{"
        + "codec=" + codec
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ColumnUtils.Codecs} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Codecs instance
   */
  public static ImmutableCodecs copyOf(ColumnUtils.Codecs instance) {
    if (instance instanceof ImmutableCodecs) {
      return (ImmutableCodecs) instance;
    }
    return ImmutableCodecs.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCodecs ImmutableCodecs}.
   * <pre>
   * ImmutableCodecs.builder()
   *    .codec(com.datastax.oss.driver.api.core.type.codec.TypeCodec) // required {@link ColumnUtils.Codecs#codec() codec}
   *    .build();
   * </pre>
   * @return A new ImmutableCodecs builder
   */
  public static ImmutableCodecs.Builder builder() {
    return new ImmutableCodecs.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCodecs ImmutableCodecs}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ColumnUtils.Codecs", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CODEC = 0x1L;
    private long initBits = 0x1L;

    private @Nullable TypeCodec codec;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Codecs} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ColumnUtils.Codecs instance) {
      Objects.requireNonNull(instance, "instance");
      codec(instance.codec());
      return this;
    }

    /**
     * Initializes the value for the {@link ColumnUtils.Codecs#codec() codec} attribute.
     * @param codec The value for codec 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder codec(TypeCodec codec) {
      this.codec = Objects.requireNonNull(codec, "codec");
      initBits &= ~INIT_BIT_CODEC;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCodecs ImmutableCodecs}.
     * @return An immutable instance of Codecs
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCodecs build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCodecs(codec);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CODEC) != 0) attributes.add("codec");
      return "Cannot build Codecs, some of required attributes are not set " + attributes;
    }
  }
}
