package io.stargate.db.schema;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CollectionIndexingType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCollectionIndexingType.builder()}.
 */
@Generated(from = "CollectionIndexingType", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCollectionIndexingType extends CollectionIndexingType {
  private final boolean indexKeys;
  private final boolean indexValues;
  private final boolean indexEntries;
  private final boolean indexFull;
  private final int hashCode;

  private ImmutableCollectionIndexingType(ImmutableCollectionIndexingType.Builder builder) {
    if (builder.indexKeysIsSet()) {
      initShim.indexKeys(builder.indexKeys);
    }
    if (builder.indexValuesIsSet()) {
      initShim.indexValues(builder.indexValues);
    }
    if (builder.indexEntriesIsSet()) {
      initShim.indexEntries(builder.indexEntries);
    }
    if (builder.indexFullIsSet()) {
      initShim.indexFull(builder.indexFull);
    }
    this.indexKeys = initShim.indexKeys();
    this.indexValues = initShim.indexValues();
    this.indexEntries = initShim.indexEntries();
    this.indexFull = initShim.indexFull();
    this.hashCode = computeHashCode();
    this.initShim = null;
  }

  private ImmutableCollectionIndexingType(boolean indexKeys, boolean indexValues, boolean indexEntries, boolean indexFull) {
    this.indexKeys = indexKeys;
    this.indexValues = indexValues;
    this.indexEntries = indexEntries;
    this.indexFull = indexFull;
    this.hashCode = computeHashCode();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "CollectionIndexingType", generator = "Immutables")
  private final class InitShim {
    private byte indexKeysBuildStage = STAGE_UNINITIALIZED;
    private boolean indexKeys;

    boolean indexKeys() {
      if (indexKeysBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (indexKeysBuildStage == STAGE_UNINITIALIZED) {
        indexKeysBuildStage = STAGE_INITIALIZING;
        this.indexKeys = ImmutableCollectionIndexingType.super.indexKeys();
        indexKeysBuildStage = STAGE_INITIALIZED;
      }
      return this.indexKeys;
    }

    void indexKeys(boolean indexKeys) {
      this.indexKeys = indexKeys;
      indexKeysBuildStage = STAGE_INITIALIZED;
    }

    private byte indexValuesBuildStage = STAGE_UNINITIALIZED;
    private boolean indexValues;

    boolean indexValues() {
      if (indexValuesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (indexValuesBuildStage == STAGE_UNINITIALIZED) {
        indexValuesBuildStage = STAGE_INITIALIZING;
        this.indexValues = ImmutableCollectionIndexingType.super.indexValues();
        indexValuesBuildStage = STAGE_INITIALIZED;
      }
      return this.indexValues;
    }

    void indexValues(boolean indexValues) {
      this.indexValues = indexValues;
      indexValuesBuildStage = STAGE_INITIALIZED;
    }

    private byte indexEntriesBuildStage = STAGE_UNINITIALIZED;
    private boolean indexEntries;

    boolean indexEntries() {
      if (indexEntriesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (indexEntriesBuildStage == STAGE_UNINITIALIZED) {
        indexEntriesBuildStage = STAGE_INITIALIZING;
        this.indexEntries = ImmutableCollectionIndexingType.super.indexEntries();
        indexEntriesBuildStage = STAGE_INITIALIZED;
      }
      return this.indexEntries;
    }

    void indexEntries(boolean indexEntries) {
      this.indexEntries = indexEntries;
      indexEntriesBuildStage = STAGE_INITIALIZED;
    }

    private byte indexFullBuildStage = STAGE_UNINITIALIZED;
    private boolean indexFull;

    boolean indexFull() {
      if (indexFullBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (indexFullBuildStage == STAGE_UNINITIALIZED) {
        indexFullBuildStage = STAGE_INITIALIZING;
        this.indexFull = ImmutableCollectionIndexingType.super.indexFull();
        indexFullBuildStage = STAGE_INITIALIZED;
      }
      return this.indexFull;
    }

    void indexFull(boolean indexFull) {
      this.indexFull = indexFull;
      indexFullBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (indexKeysBuildStage == STAGE_INITIALIZING) attributes.add("indexKeys");
      if (indexValuesBuildStage == STAGE_INITIALIZING) attributes.add("indexValues");
      if (indexEntriesBuildStage == STAGE_INITIALIZING) attributes.add("indexEntries");
      if (indexFullBuildStage == STAGE_INITIALIZING) attributes.add("indexFull");
      return "Cannot build CollectionIndexingType, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code indexKeys} attribute
   */
  @Override
  public boolean indexKeys() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.indexKeys()
        : this.indexKeys;
  }

  /**
   * @return The value of the {@code indexValues} attribute
   */
  @Override
  public boolean indexValues() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.indexValues()
        : this.indexValues;
  }

  /**
   * @return The value of the {@code indexEntries} attribute
   */
  @Override
  public boolean indexEntries() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.indexEntries()
        : this.indexEntries;
  }

  /**
   * @return The value of the {@code indexFull} attribute
   */
  @Override
  public boolean indexFull() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.indexFull()
        : this.indexFull;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CollectionIndexingType#indexKeys() indexKeys} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for indexKeys
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCollectionIndexingType withIndexKeys(boolean value) {
    if (this.indexKeys == value) return this;
    return new ImmutableCollectionIndexingType(value, this.indexValues, this.indexEntries, this.indexFull);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CollectionIndexingType#indexValues() indexValues} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for indexValues
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCollectionIndexingType withIndexValues(boolean value) {
    if (this.indexValues == value) return this;
    return new ImmutableCollectionIndexingType(this.indexKeys, value, this.indexEntries, this.indexFull);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CollectionIndexingType#indexEntries() indexEntries} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for indexEntries
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCollectionIndexingType withIndexEntries(boolean value) {
    if (this.indexEntries == value) return this;
    return new ImmutableCollectionIndexingType(this.indexKeys, this.indexValues, value, this.indexFull);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CollectionIndexingType#indexFull() indexFull} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for indexFull
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCollectionIndexingType withIndexFull(boolean value) {
    if (this.indexFull == value) return this;
    return new ImmutableCollectionIndexingType(this.indexKeys, this.indexValues, this.indexEntries, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCollectionIndexingType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCollectionIndexingType
        && equalTo((ImmutableCollectionIndexingType) another);
  }

  private boolean equalTo(ImmutableCollectionIndexingType another) {
    if (hashCode != another.hashCode) return false;
    return indexKeys == another.indexKeys
        && indexValues == another.indexValues
        && indexEntries == another.indexEntries
        && indexFull == another.indexFull;
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code indexKeys}, {@code indexValues}, {@code indexEntries}, {@code indexFull}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + Boolean.hashCode(indexKeys);
    h += (h << 5) + Boolean.hashCode(indexValues);
    h += (h << 5) + Boolean.hashCode(indexEntries);
    h += (h << 5) + Boolean.hashCode(indexFull);
    return h;
  }

  /**
   * Prints the immutable value {@code CollectionIndexingType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CollectionIndexingType{"
        + "indexKeys=" + indexKeys
        + ", indexValues=" + indexValues
        + ", indexEntries=" + indexEntries
        + ", indexFull=" + indexFull
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link CollectionIndexingType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CollectionIndexingType instance
   */
  public static ImmutableCollectionIndexingType copyOf(CollectionIndexingType instance) {
    if (instance instanceof ImmutableCollectionIndexingType) {
      return (ImmutableCollectionIndexingType) instance;
    }
    return ImmutableCollectionIndexingType.builder()
        .from(instance)
        .build();
  }

  private Object readResolve() throws ObjectStreamException {
    return new ImmutableCollectionIndexingType(this.indexKeys, this.indexValues, this.indexEntries, this.indexFull);
  }

  /**
   * Creates a builder for {@link ImmutableCollectionIndexingType ImmutableCollectionIndexingType}.
   * <pre>
   * ImmutableCollectionIndexingType.builder()
   *    .indexKeys(boolean) // optional {@link CollectionIndexingType#indexKeys() indexKeys}
   *    .indexValues(boolean) // optional {@link CollectionIndexingType#indexValues() indexValues}
   *    .indexEntries(boolean) // optional {@link CollectionIndexingType#indexEntries() indexEntries}
   *    .indexFull(boolean) // optional {@link CollectionIndexingType#indexFull() indexFull}
   *    .build();
   * </pre>
   * @return A new ImmutableCollectionIndexingType builder
   */
  public static ImmutableCollectionIndexingType.Builder builder() {
    return new ImmutableCollectionIndexingType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCollectionIndexingType ImmutableCollectionIndexingType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CollectionIndexingType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_INDEX_KEYS = 0x1L;
    private static final long OPT_BIT_INDEX_VALUES = 0x2L;
    private static final long OPT_BIT_INDEX_ENTRIES = 0x4L;
    private static final long OPT_BIT_INDEX_FULL = 0x8L;
    private long optBits;

    private boolean indexKeys;
    private boolean indexValues;
    private boolean indexEntries;
    private boolean indexFull;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CollectionIndexingType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CollectionIndexingType instance) {
      Objects.requireNonNull(instance, "instance");
      indexKeys(instance.indexKeys());
      indexValues(instance.indexValues());
      indexEntries(instance.indexEntries());
      indexFull(instance.indexFull());
      return this;
    }

    /**
     * Initializes the value for the {@link CollectionIndexingType#indexKeys() indexKeys} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link CollectionIndexingType#indexKeys() indexKeys}.</em>
     * @param indexKeys The value for indexKeys 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder indexKeys(boolean indexKeys) {
      this.indexKeys = indexKeys;
      optBits |= OPT_BIT_INDEX_KEYS;
      return this;
    }

    /**
     * Initializes the value for the {@link CollectionIndexingType#indexValues() indexValues} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link CollectionIndexingType#indexValues() indexValues}.</em>
     * @param indexValues The value for indexValues 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder indexValues(boolean indexValues) {
      this.indexValues = indexValues;
      optBits |= OPT_BIT_INDEX_VALUES;
      return this;
    }

    /**
     * Initializes the value for the {@link CollectionIndexingType#indexEntries() indexEntries} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link CollectionIndexingType#indexEntries() indexEntries}.</em>
     * @param indexEntries The value for indexEntries 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder indexEntries(boolean indexEntries) {
      this.indexEntries = indexEntries;
      optBits |= OPT_BIT_INDEX_ENTRIES;
      return this;
    }

    /**
     * Initializes the value for the {@link CollectionIndexingType#indexFull() indexFull} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link CollectionIndexingType#indexFull() indexFull}.</em>
     * @param indexFull The value for indexFull 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder indexFull(boolean indexFull) {
      this.indexFull = indexFull;
      optBits |= OPT_BIT_INDEX_FULL;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCollectionIndexingType ImmutableCollectionIndexingType}.
     * @return An immutable instance of CollectionIndexingType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCollectionIndexingType build() {
      return new ImmutableCollectionIndexingType(this);
    }

    private boolean indexKeysIsSet() {
      return (optBits & OPT_BIT_INDEX_KEYS) != 0;
    }

    private boolean indexValuesIsSet() {
      return (optBits & OPT_BIT_INDEX_VALUES) != 0;
    }

    private boolean indexEntriesIsSet() {
      return (optBits & OPT_BIT_INDEX_ENTRIES) != 0;
    }

    private boolean indexFullIsSet() {
      return (optBits & OPT_BIT_INDEX_FULL) != 0;
    }
  }
}
