package io.stargate.db.schema;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Column}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableColumn.builder()}.
 */
@Generated(from = "Column", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableColumn extends Column {
  private final String name;
  private final @Nullable Column.ColumnType type;
  private final @Nullable Column.Kind kind;
  private final @Nullable String keyspace;
  private final @Nullable String table;
  private final @Nullable Column.Order order;
  private final int schemaHashCode;
  private final int hashCode;

  private ImmutableColumn(ImmutableColumn.Builder builder) {
    this.name = builder.name;
    this.type = builder.type;
    this.kind = builder.kind;
    this.keyspace = builder.keyspace;
    this.table = builder.table;
    if (builder.orderIsSet()) {
      initShim.order(builder.order);
    }
    this.order = initShim.order();
    this.schemaHashCode = initShim.schemaHashCode();
    this.hashCode = computeHashCode();
    this.initShim = null;
  }

  private ImmutableColumn(
      String name,
      @Nullable Column.ColumnType type,
      @Nullable Column.Kind kind,
      @Nullable String keyspace,
      @Nullable String table,
      @Nullable Column.Order order) {
    this.name = name;
    this.type = type;
    this.kind = kind;
    this.keyspace = keyspace;
    this.table = table;
    initShim.order(order);
    this.order = initShim.order();
    this.schemaHashCode = initShim.schemaHashCode();
    this.hashCode = computeHashCode();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "Column", generator = "Immutables")
  private final class InitShim {
    private byte orderBuildStage = STAGE_UNINITIALIZED;
    private Column.Order order;

    Column.Order order() {
      if (orderBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (orderBuildStage == STAGE_UNINITIALIZED) {
        orderBuildStage = STAGE_INITIALIZING;
        this.order = ImmutableColumn.super.order();
        orderBuildStage = STAGE_INITIALIZED;
      }
      return this.order;
    }

    void order(Column.Order order) {
      this.order = order;
      orderBuildStage = STAGE_INITIALIZED;
    }

    private byte schemaHashCodeBuildStage = STAGE_UNINITIALIZED;
    private int schemaHashCode;

    int schemaHashCode() {
      if (schemaHashCodeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (schemaHashCodeBuildStage == STAGE_UNINITIALIZED) {
        schemaHashCodeBuildStage = STAGE_INITIALIZING;
        this.schemaHashCode = ImmutableColumn.super.schemaHashCode();
        schemaHashCodeBuildStage = STAGE_INITIALIZED;
      }
      return this.schemaHashCode;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (orderBuildStage == STAGE_INITIALIZING) attributes.add("order");
      if (schemaHashCodeBuildStage == STAGE_INITIALIZING) attributes.add("schemaHashCode");
      return "Cannot build Column, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public @Nullable Column.ColumnType type() {
    return type;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @Override
  public @Nullable Column.Kind kind() {
    return kind;
  }

  /**
   * @return The value of the {@code keyspace} attribute
   */
  @Override
  public @Nullable String keyspace() {
    return keyspace;
  }

  /**
   * @return The value of the {@code table} attribute
   */
  @Override
  public @Nullable String table() {
    return table;
  }

  /**
   * @return The value of the {@code order} attribute
   */
  @Override
  public @Nullable Column.Order order() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.order()
        : this.order;
  }

  /**
   * @return The computed-at-construction value of the {@code schemaHashCode} attribute
   */
  @Override
  public int schemaHashCode() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.schemaHashCode()
        : this.schemaHashCode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableColumn(newValue, this.type, this.kind, this.keyspace, this.table, this.order);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withType(@Nullable Column.ColumnType value) {
    if (this.type == value) return this;
    return new ImmutableColumn(this.name, value, this.kind, this.keyspace, this.table, this.order);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#kind() kind} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withKind(@Nullable Column.Kind value) {
    if (this.kind == value) return this;
    if (Objects.equals(this.kind, value)) return this;
    return new ImmutableColumn(this.name, this.type, value, this.keyspace, this.table, this.order);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#keyspace() keyspace} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keyspace (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withKeyspace(@Nullable String value) {
    if (Objects.equals(this.keyspace, value)) return this;
    return new ImmutableColumn(this.name, this.type, this.kind, value, this.table, this.order);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#table() table} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for table (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withTable(@Nullable String value) {
    if (Objects.equals(this.table, value)) return this;
    return new ImmutableColumn(this.name, this.type, this.kind, this.keyspace, value, this.order);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#order() order} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for order (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withOrder(@Nullable Column.Order value) {
    if (this.order == value) return this;
    if (Objects.equals(this.order, value)) return this;
    return new ImmutableColumn(this.name, this.type, this.kind, this.keyspace, this.table, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableColumn} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableColumn
        && equalTo((ImmutableColumn) another);
  }

  private boolean equalTo(ImmutableColumn another) {
    if (hashCode != another.hashCode) return false;
    return name.equals(another.name)
        && Objects.equals(type, another.type)
        && Objects.equals(kind, another.kind)
        && Objects.equals(keyspace, another.keyspace)
        && Objects.equals(table, another.table)
        && Objects.equals(order, another.order);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code name}, {@code type}, {@code kind}, {@code keyspace}, {@code table}, {@code order}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(kind);
    h += (h << 5) + Objects.hashCode(keyspace);
    h += (h << 5) + Objects.hashCode(table);
    h += (h << 5) + Objects.hashCode(order);
    return h;
  }

  /**
   * Prints the immutable value {@code Column} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Column{"
        + "name=" + name
        + ", type=" + type
        + ", kind=" + kind
        + ", keyspace=" + keyspace
        + ", table=" + table
        + ", order=" + order
        + "}";
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long CQL_NAME_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient String cqlName;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Column#cqlName() cqlName} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code cqlName} attribute
   */
  @Override
  public String cqlName() {
    if ((lazyInitBitmap & CQL_NAME_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CQL_NAME_LAZY_INIT_BIT) == 0) {
          this.cqlName = Objects.requireNonNull(super.cqlName(), "cqlName");
          lazyInitBitmap |= CQL_NAME_LAZY_INIT_BIT;
        }
      }
    }
    return cqlName;
  }

  /**
   * Creates an immutable copy of a {@link Column} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Column instance
   */
  public static ImmutableColumn copyOf(Column instance) {
    if (instance instanceof ImmutableColumn) {
      return (ImmutableColumn) instance;
    }
    return ImmutableColumn.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 2199514488330101566L;

  private Object readResolve() throws ObjectStreamException {
    return new ImmutableColumn(this.name, this.type, this.kind, this.keyspace, this.table, this.order);
  }

  /**
   * Creates a builder for {@link ImmutableColumn ImmutableColumn}.
   * <pre>
   * ImmutableColumn.builder()
   *    .name(String) // required {@link Column#name() name}
   *    .type(io.stargate.db.schema.Column.ColumnType | null) // nullable {@link Column#type() type}
   *    .kind(io.stargate.db.schema.Column.Kind | null) // nullable {@link Column#kind() kind}
   *    .keyspace(String | null) // nullable {@link Column#keyspace() keyspace}
   *    .table(String | null) // nullable {@link Column#table() table}
   *    .order(io.stargate.db.schema.Column.Order | null) // nullable {@link Column#order() order}
   *    .build();
   * </pre>
   * @return A new ImmutableColumn builder
   */
  public static ImmutableColumn.Builder builder() {
    return new ImmutableColumn.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableColumn ImmutableColumn}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Column", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder implements Column.Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long OPT_BIT_ORDER = 0x1L;
    private long initBits = 0x1L;
    private long optBits;

    private @Nullable String name;
    private @Nullable Column.ColumnType type;
    private @Nullable Column.Kind kind;
    private @Nullable String keyspace;
    private @Nullable String table;
    private @Nullable Column.Order order;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.SchemaEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SchemaEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.Column} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Column instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SchemaEntity) {
        SchemaEntity instance = (SchemaEntity) object;
        name(instance.name());
      }
      if (object instanceof Column) {
        Column instance = (Column) object;
        @Nullable String keyspaceValue = instance.keyspace();
        if (keyspaceValue != null) {
          keyspace(keyspaceValue);
        }
        @Nullable Column.ColumnType typeValue = instance.type();
        if (typeValue != null) {
          type(typeValue);
        }
        @Nullable Column.Kind kindValue = instance.kind();
        if (kindValue != null) {
          kind(kindValue);
        }
        @Nullable String tableValue = instance.table();
        if (tableValue != null) {
          table(tableValue);
        }
        @Nullable Column.Order orderValue = instance.order();
        if (orderValue != null) {
          order(orderValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link Column#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#type() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(@Nullable Column.ColumnType type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#kind() kind} attribute.
     * @param kind The value for kind (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder kind(@Nullable Column.Kind kind) {
      this.kind = kind;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#keyspace() keyspace} attribute.
     * @param keyspace The value for keyspace (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder keyspace(@Nullable String keyspace) {
      this.keyspace = keyspace;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#table() table} attribute.
     * @param table The value for table (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder table(@Nullable String table) {
      this.table = table;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#order() order} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Column#order() order}.</em>
     * @param order The value for order (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder order(@Nullable Column.Order order) {
      this.order = order;
      optBits |= OPT_BIT_ORDER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableColumn ImmutableColumn}.
     * @return An immutable instance of Column
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableColumn build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableColumn(this);
    }

    private boolean orderIsSet() {
      return (optBits & OPT_BIT_ORDER) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Column, some of required attributes are not set " + attributes;
    }
  }
}
