package io.stargate.db.schema;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ColumnMappingMetadata}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableColumnMappingMetadata.builder()}.
 */
@Generated(from = "ColumnMappingMetadata", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableColumnMappingMetadata extends ColumnMappingMetadata {
  private final String vertexColumn;
  private final String edgeColumn;
  private final int hashCode;

  private ImmutableColumnMappingMetadata(String vertexColumn, String edgeColumn) {
    this.vertexColumn = vertexColumn;
    this.edgeColumn = edgeColumn;
    this.hashCode = computeHashCode();
  }

  /**
   * @return The value of the {@code vertexColumn} attribute
   */
  @Override
  public String vertexColumn() {
    return vertexColumn;
  }

  /**
   * @return The value of the {@code edgeColumn} attribute
   */
  @Override
  public String edgeColumn() {
    return edgeColumn;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ColumnMappingMetadata#vertexColumn() vertexColumn} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vertexColumn
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumnMappingMetadata withVertexColumn(String value) {
    String newValue = Objects.requireNonNull(value, "vertexColumn");
    if (this.vertexColumn.equals(newValue)) return this;
    return new ImmutableColumnMappingMetadata(newValue, this.edgeColumn);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ColumnMappingMetadata#edgeColumn() edgeColumn} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for edgeColumn
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumnMappingMetadata withEdgeColumn(String value) {
    String newValue = Objects.requireNonNull(value, "edgeColumn");
    if (this.edgeColumn.equals(newValue)) return this;
    return new ImmutableColumnMappingMetadata(this.vertexColumn, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableColumnMappingMetadata} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableColumnMappingMetadata
        && equalTo((ImmutableColumnMappingMetadata) another);
  }

  private boolean equalTo(ImmutableColumnMappingMetadata another) {
    if (hashCode != another.hashCode) return false;
    return vertexColumn.equals(another.vertexColumn)
        && edgeColumn.equals(another.edgeColumn);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code vertexColumn}, {@code edgeColumn}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + vertexColumn.hashCode();
    h += (h << 5) + edgeColumn.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ColumnMappingMetadata} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ColumnMappingMetadata{"
        + "vertexColumn=" + vertexColumn
        + ", edgeColumn=" + edgeColumn
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ColumnMappingMetadata} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ColumnMappingMetadata instance
   */
  public static ImmutableColumnMappingMetadata copyOf(ColumnMappingMetadata instance) {
    if (instance instanceof ImmutableColumnMappingMetadata) {
      return (ImmutableColumnMappingMetadata) instance;
    }
    return ImmutableColumnMappingMetadata.builder()
        .from(instance)
        .build();
  }

  private Object readResolve() throws ObjectStreamException {
    return new ImmutableColumnMappingMetadata(this.vertexColumn, this.edgeColumn);
  }

  /**
   * Creates a builder for {@link ImmutableColumnMappingMetadata ImmutableColumnMappingMetadata}.
   * <pre>
   * ImmutableColumnMappingMetadata.builder()
   *    .vertexColumn(String) // required {@link ColumnMappingMetadata#vertexColumn() vertexColumn}
   *    .edgeColumn(String) // required {@link ColumnMappingMetadata#edgeColumn() edgeColumn}
   *    .build();
   * </pre>
   * @return A new ImmutableColumnMappingMetadata builder
   */
  public static ImmutableColumnMappingMetadata.Builder builder() {
    return new ImmutableColumnMappingMetadata.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableColumnMappingMetadata ImmutableColumnMappingMetadata}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ColumnMappingMetadata", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VERTEX_COLUMN = 0x1L;
    private static final long INIT_BIT_EDGE_COLUMN = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String vertexColumn;
    private @Nullable String edgeColumn;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ColumnMappingMetadata} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ColumnMappingMetadata instance) {
      Objects.requireNonNull(instance, "instance");
      vertexColumn(instance.vertexColumn());
      edgeColumn(instance.edgeColumn());
      return this;
    }

    /**
     * Initializes the value for the {@link ColumnMappingMetadata#vertexColumn() vertexColumn} attribute.
     * @param vertexColumn The value for vertexColumn 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder vertexColumn(String vertexColumn) {
      this.vertexColumn = Objects.requireNonNull(vertexColumn, "vertexColumn");
      initBits &= ~INIT_BIT_VERTEX_COLUMN;
      return this;
    }

    /**
     * Initializes the value for the {@link ColumnMappingMetadata#edgeColumn() edgeColumn} attribute.
     * @param edgeColumn The value for edgeColumn 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder edgeColumn(String edgeColumn) {
      this.edgeColumn = Objects.requireNonNull(edgeColumn, "edgeColumn");
      initBits &= ~INIT_BIT_EDGE_COLUMN;
      return this;
    }

    /**
     * Builds a new {@link ImmutableColumnMappingMetadata ImmutableColumnMappingMetadata}.
     * @return An immutable instance of ColumnMappingMetadata
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableColumnMappingMetadata build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableColumnMappingMetadata(vertexColumn, edgeColumn);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VERTEX_COLUMN) != 0) attributes.add("vertexColumn");
      if ((initBits & INIT_BIT_EDGE_COLUMN) != 0) attributes.add("edgeColumn");
      return "Cannot build ColumnMappingMetadata, some of required attributes are not set " + attributes;
    }
  }
}
