package io.stargate.db.schema;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Keyspace}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableKeyspace.builder()}.
 */
@Generated(from = "Keyspace", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableKeyspace extends Keyspace {
  private final String name;
  private final Set<Table> tables;
  private final List<UserDefinedType> userDefinedTypes;
  private final Map<String, String> replication;
  private final @Nullable Boolean durableWrites;
  private final int schemaHashCode;
  private final int hashCode;

  private ImmutableKeyspace(
      String name,
      Set<Table> tables,
      List<UserDefinedType> userDefinedTypes,
      Map<String, String> replication,
      @Nullable Boolean durableWrites) {
    this.name = name;
    this.tables = tables;
    this.userDefinedTypes = userDefinedTypes;
    this.replication = replication;
    this.durableWrites = durableWrites;
    this.schemaHashCode = super.schemaHashCode();
    this.hashCode = computeHashCode();
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code tables} attribute
   */
  @Override
  public Set<Table> tables() {
    return tables;
  }

  /**
   * @return The value of the {@code userDefinedTypes} attribute
   */
  @Override
  public List<UserDefinedType> userDefinedTypes() {
    return userDefinedTypes;
  }

  /**
   * @return The value of the {@code replication} attribute
   */
  @Override
  public Map<String, String> replication() {
    return replication;
  }

  /**
   * @return The value of the {@code durableWrites} attribute
   */
  @Override
  public Optional<Boolean> durableWrites() {
    return Optional.ofNullable(durableWrites);
  }

  /**
   * @return The computed-at-construction value of the {@code schemaHashCode} attribute
   */
  @Override
  public int schemaHashCode() {
    return schemaHashCode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Keyspace#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableKeyspace withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableKeyspace(newValue, this.tables, this.userDefinedTypes, this.replication, this.durableWrites);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Keyspace#tables() tables}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableKeyspace withTables(Table... elements) {
    Set<Table> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableKeyspace(this.name, newValue, this.userDefinedTypes, this.replication, this.durableWrites);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Keyspace#tables() tables}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tables elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableKeyspace withTables(Iterable<? extends Table> elements) {
    if (this.tables == elements) return this;
    Set<Table> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new ImmutableKeyspace(this.name, newValue, this.userDefinedTypes, this.replication, this.durableWrites);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Keyspace#userDefinedTypes() userDefinedTypes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableKeyspace withUserDefinedTypes(UserDefinedType... elements) {
    List<UserDefinedType> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableKeyspace(this.name, this.tables, newValue, this.replication, this.durableWrites);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Keyspace#userDefinedTypes() userDefinedTypes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of userDefinedTypes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableKeyspace withUserDefinedTypes(Iterable<? extends UserDefinedType> elements) {
    if (this.userDefinedTypes == elements) return this;
    List<UserDefinedType> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableKeyspace(this.name, this.tables, newValue, this.replication, this.durableWrites);
  }

  /**
   * Copy the current immutable object by replacing the {@link Keyspace#replication() replication} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the replication map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableKeyspace withReplication(Map<String, ? extends String> entries) {
    if (this.replication == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableKeyspace(this.name, this.tables, this.userDefinedTypes, newValue, this.durableWrites);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Keyspace#durableWrites() durableWrites} attribute.
   * @param value The value for durableWrites
   * @return A modified copy of {@code this} object
   */
  public final ImmutableKeyspace withDurableWrites(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.durableWrites, newValue)) return this;
    return new ImmutableKeyspace(this.name, this.tables, this.userDefinedTypes, this.replication, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Keyspace#durableWrites() durableWrites} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for durableWrites
   * @return A modified copy of {@code this} object
   */
  public final ImmutableKeyspace withDurableWrites(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.durableWrites, value)) return this;
    return new ImmutableKeyspace(this.name, this.tables, this.userDefinedTypes, this.replication, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableKeyspace} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableKeyspace
        && equalTo((ImmutableKeyspace) another);
  }

  private boolean equalTo(ImmutableKeyspace another) {
    if (hashCode != another.hashCode) return false;
    return name.equals(another.name)
        && tables.equals(another.tables)
        && userDefinedTypes.equals(another.userDefinedTypes)
        && replication.equals(another.replication)
        && Objects.equals(durableWrites, another.durableWrites);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code name}, {@code tables}, {@code userDefinedTypes}, {@code replication}, {@code durableWrites}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + tables.hashCode();
    h += (h << 5) + userDefinedTypes.hashCode();
    h += (h << 5) + replication.hashCode();
    h += (h << 5) + Objects.hashCode(durableWrites);
    return h;
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long CQL_NAME_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient String cqlName;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Keyspace#cqlName() cqlName} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code cqlName} attribute
   */
  @Override
  public String cqlName() {
    if ((lazyInitBitmap & CQL_NAME_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CQL_NAME_LAZY_INIT_BIT) == 0) {
          this.cqlName = Objects.requireNonNull(super.cqlName(), "cqlName");
          lazyInitBitmap |= CQL_NAME_LAZY_INIT_BIT;
        }
      }
    }
    return cqlName;
  }

  private static final long TABLE_MAP_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient Map<String, Table> tableMap;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Keyspace#tableMap() tableMap} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code tableMap} attribute
   */
  @Override
  Map<String, Table> tableMap() {
    if ((lazyInitBitmap & TABLE_MAP_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & TABLE_MAP_LAZY_INIT_BIT) == 0) {
          this.tableMap = Objects.requireNonNull(super.tableMap(), "tableMap");
          lazyInitBitmap |= TABLE_MAP_LAZY_INIT_BIT;
        }
      }
    }
    return tableMap;
  }

  private static final long USER_DEFINED_TYPE_MAP_LAZY_INIT_BIT = 0x4L;

  @SuppressWarnings("Immutable")
  private transient Map<String, UserDefinedType> userDefinedTypeMap;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Keyspace#userDefinedTypeMap() userDefinedTypeMap} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code userDefinedTypeMap} attribute
   */
  @Override
  Map<String, UserDefinedType> userDefinedTypeMap() {
    if ((lazyInitBitmap & USER_DEFINED_TYPE_MAP_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & USER_DEFINED_TYPE_MAP_LAZY_INIT_BIT) == 0) {
          this.userDefinedTypeMap = Objects.requireNonNull(super.userDefinedTypeMap(), "userDefinedTypeMap");
          lazyInitBitmap |= USER_DEFINED_TYPE_MAP_LAZY_INIT_BIT;
        }
      }
    }
    return userDefinedTypeMap;
  }

  private static final long MATERIALIZED_VIEW_MAP_LAZY_INIT_BIT = 0x8L;

  @SuppressWarnings("Immutable")
  private transient Map<String, MaterializedView> materializedViewMap;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Keyspace#materializedViewMap() materializedViewMap} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code materializedViewMap} attribute
   */
  @Override
  Map<String, MaterializedView> materializedViewMap() {
    if ((lazyInitBitmap & MATERIALIZED_VIEW_MAP_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & MATERIALIZED_VIEW_MAP_LAZY_INIT_BIT) == 0) {
          this.materializedViewMap = Objects.requireNonNull(super.materializedViewMap(), "materializedViewMap");
          lazyInitBitmap |= MATERIALIZED_VIEW_MAP_LAZY_INIT_BIT;
        }
      }
    }
    return materializedViewMap;
  }

  private static final long SECONDARY_INDEX_MAP_LAZY_INIT_BIT = 0x10L;

  @SuppressWarnings("Immutable")
  private transient Map<String, SecondaryIndex> secondaryIndexMap;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Keyspace#secondaryIndexMap() secondaryIndexMap} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code secondaryIndexMap} attribute
   */
  @Override
  Map<String, SecondaryIndex> secondaryIndexMap() {
    if ((lazyInitBitmap & SECONDARY_INDEX_MAP_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SECONDARY_INDEX_MAP_LAZY_INIT_BIT) == 0) {
          this.secondaryIndexMap = Objects.requireNonNull(super.secondaryIndexMap(), "secondaryIndexMap");
          lazyInitBitmap |= SECONDARY_INDEX_MAP_LAZY_INIT_BIT;
        }
      }
    }
    return secondaryIndexMap;
  }

  private static final long REVERSE_INDEX_MAP_LAZY_INIT_BIT = 0x20L;

  @SuppressWarnings("Immutable")
  private transient Map<Index, Table> reverseIndexMap;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Keyspace#reverseIndexMap() reverseIndexMap} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code reverseIndexMap} attribute
   */
  @Override
  Map<Index, Table> reverseIndexMap() {
    if ((lazyInitBitmap & REVERSE_INDEX_MAP_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & REVERSE_INDEX_MAP_LAZY_INIT_BIT) == 0) {
          this.reverseIndexMap = Objects.requireNonNull(super.reverseIndexMap(), "reverseIndexMap");
          lazyInitBitmap |= REVERSE_INDEX_MAP_LAZY_INIT_BIT;
        }
      }
    }
    return reverseIndexMap;
  }

  /**
   * Creates an immutable copy of a {@link Keyspace} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Keyspace instance
   */
  public static ImmutableKeyspace copyOf(Keyspace instance) {
    if (instance instanceof ImmutableKeyspace) {
      return (ImmutableKeyspace) instance;
    }
    return ImmutableKeyspace.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = -337891773492616286L;

  private Object readResolve() throws ObjectStreamException {
    return new ImmutableKeyspace(this.name, this.tables, this.userDefinedTypes, this.replication, this.durableWrites);
  }

  /**
   * Creates a builder for {@link ImmutableKeyspace ImmutableKeyspace}.
   * <pre>
   * ImmutableKeyspace.builder()
   *    .name(String) // required {@link Keyspace#name() name}
   *    .addTables|addAllTables(io.stargate.db.schema.Table) // {@link Keyspace#tables() tables} elements
   *    .addUserDefinedTypes|addAllUserDefinedTypes(io.stargate.db.schema.UserDefinedType) // {@link Keyspace#userDefinedTypes() userDefinedTypes} elements
   *    .putReplication|putAllReplication(String =&gt; String) // {@link Keyspace#replication() replication} mappings
   *    .durableWrites(Boolean) // optional {@link Keyspace#durableWrites() durableWrites}
   *    .build();
   * </pre>
   * @return A new ImmutableKeyspace builder
   */
  public static ImmutableKeyspace.Builder builder() {
    return new ImmutableKeyspace.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableKeyspace ImmutableKeyspace}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Keyspace", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;
    private List<Table> tables = new ArrayList<Table>();
    private List<UserDefinedType> userDefinedTypes = new ArrayList<UserDefinedType>();
    private Map<String, String> replication = new LinkedHashMap<String, String>();
    private @Nullable Boolean durableWrites;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.SchemaEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SchemaEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.Keyspace} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Keyspace instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SchemaEntity) {
        SchemaEntity instance = (SchemaEntity) object;
        name(instance.name());
      }
      if (object instanceof Keyspace) {
        Keyspace instance = (Keyspace) object;
        putAllReplication(instance.replication());
        Optional<Boolean> durableWritesOptional = instance.durableWrites();
        if (durableWritesOptional.isPresent()) {
          durableWrites(durableWritesOptional);
        }
        addAllTables(instance.tables());
        addAllUserDefinedTypes(instance.userDefinedTypes());
      }
    }

    /**
     * Initializes the value for the {@link Keyspace#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link Keyspace#tables() tables} set.
     * @param element A tables element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTables(Table element) {
      this.tables.add(Objects.requireNonNull(element, "tables element"));
      return this;
    }

    /**
     * Adds elements to {@link Keyspace#tables() tables} set.
     * @param elements An array of tables elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTables(Table... elements) {
      for (Table element : elements) {
        this.tables.add(Objects.requireNonNull(element, "tables element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Keyspace#tables() tables} set.
     * @param elements An iterable of tables elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tables(Iterable<? extends Table> elements) {
      this.tables.clear();
      return addAllTables(elements);
    }

    /**
     * Adds elements to {@link Keyspace#tables() tables} set.
     * @param elements An iterable of tables elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTables(Iterable<? extends Table> elements) {
      for (Table element : elements) {
        this.tables.add(Objects.requireNonNull(element, "tables element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Keyspace#userDefinedTypes() userDefinedTypes} list.
     * @param element A userDefinedTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addUserDefinedTypes(UserDefinedType element) {
      this.userDefinedTypes.add(Objects.requireNonNull(element, "userDefinedTypes element"));
      return this;
    }

    /**
     * Adds elements to {@link Keyspace#userDefinedTypes() userDefinedTypes} list.
     * @param elements An array of userDefinedTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addUserDefinedTypes(UserDefinedType... elements) {
      for (UserDefinedType element : elements) {
        this.userDefinedTypes.add(Objects.requireNonNull(element, "userDefinedTypes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Keyspace#userDefinedTypes() userDefinedTypes} list.
     * @param elements An iterable of userDefinedTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder userDefinedTypes(Iterable<? extends UserDefinedType> elements) {
      this.userDefinedTypes.clear();
      return addAllUserDefinedTypes(elements);
    }

    /**
     * Adds elements to {@link Keyspace#userDefinedTypes() userDefinedTypes} list.
     * @param elements An iterable of userDefinedTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllUserDefinedTypes(Iterable<? extends UserDefinedType> elements) {
      for (UserDefinedType element : elements) {
        this.userDefinedTypes.add(Objects.requireNonNull(element, "userDefinedTypes element"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link Keyspace#replication() replication} map.
     * @param key The key in the replication map
     * @param value The associated value in the replication map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putReplication(String key, String value) {
      this.replication.put(
          Objects.requireNonNull(key, "replication key"),
          Objects.requireNonNull(value, "replication value"));
      return this;
    }

    /**
     * Put one entry to the {@link Keyspace#replication() replication} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putReplication(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.replication.put(
          Objects.requireNonNull(k, "replication key"),
          Objects.requireNonNull(v, "replication value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Keyspace#replication() replication} map. Nulls are not permitted
     * @param entries The entries that will be added to the replication map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder replication(Map<String, ? extends String> entries) {
      this.replication.clear();
      return putAllReplication(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Keyspace#replication() replication} map. Nulls are not permitted
     * @param entries The entries that will be added to the replication map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllReplication(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.replication.put(
            Objects.requireNonNull(k, "replication key"),
            Objects.requireNonNull(v, "replication value"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link Keyspace#durableWrites() durableWrites} to durableWrites.
     * @param durableWrites The value for durableWrites
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder durableWrites(boolean durableWrites) {
      this.durableWrites = durableWrites;
      return this;
    }

    /**
     * Initializes the optional value {@link Keyspace#durableWrites() durableWrites} to durableWrites.
     * @param durableWrites The value for durableWrites
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder durableWrites(Optional<Boolean> durableWrites) {
      this.durableWrites = durableWrites.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableKeyspace ImmutableKeyspace}.
     * @return An immutable instance of Keyspace
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableKeyspace build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableKeyspace(
          name,
          createUnmodifiableSet(tables),
          createUnmodifiableList(true, userDefinedTypes),
          createUnmodifiableMap(false, false, replication),
          durableWrites);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Keyspace, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
