package io.stargate.db.schema;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Schema}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSchema.builder()}.
 */
@Generated(from = "Schema", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSchema extends Schema {
  private final Set<Keyspace> keyspaces;
  private transient final int hashCode;

  private ImmutableSchema(Set<Keyspace> keyspaces) {
    this.keyspaces = keyspaces;
    this.hashCode = computeHashCode();
  }

  /**
   * @return The value of the {@code keyspaces} attribute
   */
  @Override
  public Set<Keyspace> keyspaces() {
    return keyspaces;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Schema#keyspaces() keyspaces}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSchema withKeyspaces(Keyspace... elements) {
    Set<Keyspace> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableSchema(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Schema#keyspaces() keyspaces}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of keyspaces elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSchema withKeyspaces(Iterable<? extends Keyspace> elements) {
    if (this.keyspaces == elements) return this;
    Set<Keyspace> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new ImmutableSchema(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSchema} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSchema
        && equalTo((ImmutableSchema) another);
  }

  private boolean equalTo(ImmutableSchema another) {
    if (hashCode != another.hashCode) return false;
    return keyspaces.equals(another.keyspaces);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code keyspaces}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + keyspaces.hashCode();
    return h;
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long KEYSPACE_MAP_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Map<String, Keyspace> keyspaceMap;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Schema#keyspaceMap() keyspaceMap} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code keyspaceMap} attribute
   */
  @Override
  Map<String, Keyspace> keyspaceMap() {
    if ((lazyInitBitmap & KEYSPACE_MAP_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & KEYSPACE_MAP_LAZY_INIT_BIT) == 0) {
          this.keyspaceMap = Objects.requireNonNull(super.keyspaceMap(), "keyspaceMap");
          lazyInitBitmap |= KEYSPACE_MAP_LAZY_INIT_BIT;
        }
      }
    }
    return keyspaceMap;
  }

  /**
   * Creates an immutable copy of a {@link Schema} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Schema instance
   */
  public static ImmutableSchema copyOf(Schema instance) {
    if (instance instanceof ImmutableSchema) {
      return (ImmutableSchema) instance;
    }
    return ImmutableSchema.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSchema ImmutableSchema}.
   * <pre>
   * ImmutableSchema.builder()
   *    .addKeyspaces|addAllKeyspaces(io.stargate.db.schema.Keyspace) // {@link Schema#keyspaces() keyspaces} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSchema builder
   */
  public static ImmutableSchema.Builder builder() {
    return new ImmutableSchema.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSchema ImmutableSchema}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Schema", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Keyspace> keyspaces = new ArrayList<Keyspace>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Schema} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Schema instance) {
      Objects.requireNonNull(instance, "instance");
      addAllKeyspaces(instance.keyspaces());
      return this;
    }

    /**
     * Adds one element to {@link Schema#keyspaces() keyspaces} set.
     * @param element A keyspaces element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addKeyspaces(Keyspace element) {
      this.keyspaces.add(Objects.requireNonNull(element, "keyspaces element"));
      return this;
    }

    /**
     * Adds elements to {@link Schema#keyspaces() keyspaces} set.
     * @param elements An array of keyspaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addKeyspaces(Keyspace... elements) {
      for (Keyspace element : elements) {
        this.keyspaces.add(Objects.requireNonNull(element, "keyspaces element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Schema#keyspaces() keyspaces} set.
     * @param elements An iterable of keyspaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder keyspaces(Iterable<? extends Keyspace> elements) {
      this.keyspaces.clear();
      return addAllKeyspaces(elements);
    }

    /**
     * Adds elements to {@link Schema#keyspaces() keyspaces} set.
     * @param elements An iterable of keyspaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllKeyspaces(Iterable<? extends Keyspace> elements) {
      for (Keyspace element : elements) {
        this.keyspaces.add(Objects.requireNonNull(element, "keyspaces element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableSchema ImmutableSchema}.
     * @return An immutable instance of Schema
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSchema build() {
      return new ImmutableSchema(createUnmodifiableSet(keyspaces));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }
}
