package io.stargate.db.schema;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SecondaryIndex}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSecondaryIndex.builder()}.
 */
@Generated(from = "SecondaryIndex", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSecondaryIndex extends SecondaryIndex {
  private final String name;
  private final String keyspace;
  private final @Nullable Column column;
  private final CollectionIndexingType indexingType;
  private final boolean isCustom;
  private final @Nullable String indexingClass;
  private final @Nullable Map<String, String> indexingOptions;
  private final int schemaHashCode;
  private final int hashCode;

  private ImmutableSecondaryIndex(ImmutableSecondaryIndex.Builder builder) {
    this.name = builder.name;
    this.keyspace = builder.keyspace;
    this.column = builder.column;
    this.indexingType = builder.indexingType;
    this.indexingClass = builder.indexingClass;
    this.indexingOptions = builder.indexingOptions == null ? null : createUnmodifiableMap(false, false, builder.indexingOptions);
    if (builder.isCustomIsSet()) {
      initShim.isCustom(builder.isCustom);
    }
    this.isCustom = initShim.isCustom();
    this.schemaHashCode = initShim.schemaHashCode();
    this.hashCode = computeHashCode();
    this.initShim = null;
  }

  private ImmutableSecondaryIndex(
      String name,
      String keyspace,
      @Nullable Column column,
      CollectionIndexingType indexingType,
      boolean isCustom,
      @Nullable String indexingClass,
      @Nullable Map<String, String> indexingOptions) {
    this.name = name;
    this.keyspace = keyspace;
    this.column = column;
    this.indexingType = indexingType;
    initShim.isCustom(isCustom);
    this.indexingClass = indexingClass;
    this.indexingOptions = indexingOptions;
    this.isCustom = initShim.isCustom();
    this.schemaHashCode = initShim.schemaHashCode();
    this.hashCode = computeHashCode();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "SecondaryIndex", generator = "Immutables")
  private final class InitShim {
    private byte isCustomBuildStage = STAGE_UNINITIALIZED;
    private boolean isCustom;

    boolean isCustom() {
      if (isCustomBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isCustomBuildStage == STAGE_UNINITIALIZED) {
        isCustomBuildStage = STAGE_INITIALIZING;
        this.isCustom = ImmutableSecondaryIndex.super.isCustom();
        isCustomBuildStage = STAGE_INITIALIZED;
      }
      return this.isCustom;
    }

    void isCustom(boolean isCustom) {
      this.isCustom = isCustom;
      isCustomBuildStage = STAGE_INITIALIZED;
    }

    private byte schemaHashCodeBuildStage = STAGE_UNINITIALIZED;
    private int schemaHashCode;

    int schemaHashCode() {
      if (schemaHashCodeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (schemaHashCodeBuildStage == STAGE_UNINITIALIZED) {
        schemaHashCodeBuildStage = STAGE_INITIALIZING;
        this.schemaHashCode = ImmutableSecondaryIndex.super.schemaHashCode();
        schemaHashCodeBuildStage = STAGE_INITIALIZED;
      }
      return this.schemaHashCode;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (isCustomBuildStage == STAGE_INITIALIZING) attributes.add("isCustom");
      if (schemaHashCodeBuildStage == STAGE_INITIALIZING) attributes.add("schemaHashCode");
      return "Cannot build SecondaryIndex, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code keyspace} attribute
   */
  @Override
  public String keyspace() {
    return keyspace;
  }

  /**
   * @return The value of the {@code column} attribute
   */
  @Override
  public @Nullable Column column() {
    return column;
  }

  /**
   * @return The value of the {@code indexingType} attribute
   */
  @Override
  public CollectionIndexingType indexingType() {
    return indexingType;
  }

  /**
   * @return The value of the {@code isCustom} attribute
   */
  @Override
  public boolean isCustom() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isCustom()
        : this.isCustom;
  }

  /**
   * @return The value of the {@code indexingClass} attribute
   */
  @Override
  public @Nullable String indexingClass() {
    return indexingClass;
  }

  /**
   * @return The value of the {@code indexingOptions} attribute
   */
  @Override
  public @Nullable Map<String, String> indexingOptions() {
    return indexingOptions;
  }

  /**
   * @return The computed-at-construction value of the {@code schemaHashCode} attribute
   */
  @Override
  public int schemaHashCode() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.schemaHashCode()
        : this.schemaHashCode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SecondaryIndex#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSecondaryIndex withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableSecondaryIndex(
        newValue,
        this.keyspace,
        this.column,
        this.indexingType,
        this.isCustom,
        this.indexingClass,
        this.indexingOptions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SecondaryIndex#keyspace() keyspace} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keyspace
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSecondaryIndex withKeyspace(String value) {
    String newValue = Objects.requireNonNull(value, "keyspace");
    if (this.keyspace.equals(newValue)) return this;
    return new ImmutableSecondaryIndex(
        this.name,
        newValue,
        this.column,
        this.indexingType,
        this.isCustom,
        this.indexingClass,
        this.indexingOptions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SecondaryIndex#column() column} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for column (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSecondaryIndex withColumn(@Nullable Column value) {
    if (this.column == value) return this;
    return new ImmutableSecondaryIndex(
        this.name,
        this.keyspace,
        value,
        this.indexingType,
        this.isCustom,
        this.indexingClass,
        this.indexingOptions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SecondaryIndex#indexingType() indexingType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for indexingType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSecondaryIndex withIndexingType(CollectionIndexingType value) {
    if (this.indexingType == value) return this;
    CollectionIndexingType newValue = Objects.requireNonNull(value, "indexingType");
    return new ImmutableSecondaryIndex(
        this.name,
        this.keyspace,
        this.column,
        newValue,
        this.isCustom,
        this.indexingClass,
        this.indexingOptions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SecondaryIndex#isCustom() isCustom} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isCustom
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSecondaryIndex withIsCustom(boolean value) {
    if (this.isCustom == value) return this;
    return new ImmutableSecondaryIndex(
        this.name,
        this.keyspace,
        this.column,
        this.indexingType,
        value,
        this.indexingClass,
        this.indexingOptions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SecondaryIndex#indexingClass() indexingClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for indexingClass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSecondaryIndex withIndexingClass(@Nullable String value) {
    if (Objects.equals(this.indexingClass, value)) return this;
    return new ImmutableSecondaryIndex(
        this.name,
        this.keyspace,
        this.column,
        this.indexingType,
        this.isCustom,
        value,
        this.indexingOptions);
  }

  /**
   * Copy the current immutable object by replacing the {@link SecondaryIndex#indexingOptions() indexingOptions} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the indexingOptions map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSecondaryIndex withIndexingOptions(@Nullable Map<String, ? extends String> entries) {
    if (this.indexingOptions == entries) return this;
    @Nullable Map<String, String> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableSecondaryIndex(
        this.name,
        this.keyspace,
        this.column,
        this.indexingType,
        this.isCustom,
        this.indexingClass,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSecondaryIndex} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSecondaryIndex
        && equalTo((ImmutableSecondaryIndex) another);
  }

  private boolean equalTo(ImmutableSecondaryIndex another) {
    if (hashCode != another.hashCode) return false;
    return name.equals(another.name)
        && keyspace.equals(another.keyspace)
        && Objects.equals(column, another.column)
        && indexingType.equals(another.indexingType)
        && isCustom == another.isCustom
        && Objects.equals(indexingClass, another.indexingClass)
        && Objects.equals(indexingOptions, another.indexingOptions);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code name}, {@code keyspace}, {@code column}, {@code indexingType}, {@code isCustom}, {@code indexingClass}, {@code indexingOptions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + keyspace.hashCode();
    h += (h << 5) + Objects.hashCode(column);
    h += (h << 5) + indexingType.hashCode();
    h += (h << 5) + Boolean.hashCode(isCustom);
    h += (h << 5) + Objects.hashCode(indexingClass);
    h += (h << 5) + Objects.hashCode(indexingOptions);
    return h;
  }

  /**
   * Prints the immutable value {@code SecondaryIndex} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SecondaryIndex{"
        + "name=" + name
        + ", keyspace=" + keyspace
        + ", column=" + column
        + ", indexingType=" + indexingType
        + ", isCustom=" + isCustom
        + ", indexingClass=" + indexingClass
        + ", indexingOptions=" + indexingOptions
        + "}";
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long CQL_NAME_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient String cqlName;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link SecondaryIndex#cqlName() cqlName} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code cqlName} attribute
   */
  @Override
  public String cqlName() {
    if ((lazyInitBitmap & CQL_NAME_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CQL_NAME_LAZY_INIT_BIT) == 0) {
          this.cqlName = Objects.requireNonNull(super.cqlName(), "cqlName");
          lazyInitBitmap |= CQL_NAME_LAZY_INIT_BIT;
        }
      }
    }
    return cqlName;
  }

  private static final long CQL_KEYSPACE_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient String cqlKeyspace;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link SecondaryIndex#cqlKeyspace() cqlKeyspace} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code cqlKeyspace} attribute
   */
  @Override
  public String cqlKeyspace() {
    if ((lazyInitBitmap & CQL_KEYSPACE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CQL_KEYSPACE_LAZY_INIT_BIT) == 0) {
          this.cqlKeyspace = Objects.requireNonNull(super.cqlKeyspace(), "cqlKeyspace");
          lazyInitBitmap |= CQL_KEYSPACE_LAZY_INIT_BIT;
        }
      }
    }
    return cqlKeyspace;
  }

  private static final long CQL_QUALIFIED_NAME_LAZY_INIT_BIT = 0x4L;

  @SuppressWarnings("Immutable")
  private transient String cqlQualifiedName;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link SecondaryIndex#cqlQualifiedName() cqlQualifiedName} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code cqlQualifiedName} attribute
   */
  @Override
  public String cqlQualifiedName() {
    if ((lazyInitBitmap & CQL_QUALIFIED_NAME_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CQL_QUALIFIED_NAME_LAZY_INIT_BIT) == 0) {
          this.cqlQualifiedName = Objects.requireNonNull(super.cqlQualifiedName(), "cqlQualifiedName");
          lazyInitBitmap |= CQL_QUALIFIED_NAME_LAZY_INIT_BIT;
        }
      }
    }
    return cqlQualifiedName;
  }

  /**
   * Creates an immutable copy of a {@link SecondaryIndex} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SecondaryIndex instance
   */
  public static ImmutableSecondaryIndex copyOf(SecondaryIndex instance) {
    if (instance instanceof ImmutableSecondaryIndex) {
      return (ImmutableSecondaryIndex) instance;
    }
    return ImmutableSecondaryIndex.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 424886903165529554L;

  private Object readResolve() throws ObjectStreamException {
    return new ImmutableSecondaryIndex(
        this.name,
        this.keyspace,
        this.column,
        this.indexingType,
        this.isCustom,
        this.indexingClass,
        this.indexingOptions);
  }

  /**
   * Creates a builder for {@link ImmutableSecondaryIndex ImmutableSecondaryIndex}.
   * <pre>
   * ImmutableSecondaryIndex.builder()
   *    .name(String) // required {@link SecondaryIndex#name() name}
   *    .keyspace(String) // required {@link SecondaryIndex#keyspace() keyspace}
   *    .column(io.stargate.db.schema.Column | null) // nullable {@link SecondaryIndex#column() column}
   *    .indexingType(io.stargate.db.schema.CollectionIndexingType) // required {@link SecondaryIndex#indexingType() indexingType}
   *    .isCustom(boolean) // optional {@link SecondaryIndex#isCustom() isCustom}
   *    .indexingClass(String | null) // nullable {@link SecondaryIndex#indexingClass() indexingClass}
   *    .indexingOptions(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link SecondaryIndex#indexingOptions() indexingOptions}
   *    .build();
   * </pre>
   * @return A new ImmutableSecondaryIndex builder
   */
  public static ImmutableSecondaryIndex.Builder builder() {
    return new ImmutableSecondaryIndex.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSecondaryIndex ImmutableSecondaryIndex}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SecondaryIndex", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_KEYSPACE = 0x2L;
    private static final long INIT_BIT_INDEXING_TYPE = 0x4L;
    private static final long OPT_BIT_IS_CUSTOM = 0x1L;
    private long initBits = 0x7L;
    private long optBits;

    private @Nullable String name;
    private @Nullable String keyspace;
    private @Nullable Column column;
    private @Nullable CollectionIndexingType indexingType;
    private boolean isCustom;
    private @Nullable String indexingClass;
    private Map<String, String> indexingOptions = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.SchemaEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SchemaEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.SecondaryIndex} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SecondaryIndex instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.QualifiedSchemaEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(QualifiedSchemaEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SchemaEntity) {
        SchemaEntity instance = (SchemaEntity) object;
        name(instance.name());
      }
      if (object instanceof SecondaryIndex) {
        SecondaryIndex instance = (SecondaryIndex) object;
        @Nullable Column columnValue = instance.column();
        if (columnValue != null) {
          column(columnValue);
        }
        isCustom(instance.isCustom());
        @Nullable String indexingClassValue = instance.indexingClass();
        if (indexingClassValue != null) {
          indexingClass(indexingClassValue);
        }
        @Nullable Map<String, String> indexingOptionsValue = instance.indexingOptions();
        if (indexingOptionsValue != null) {
          putAllIndexingOptions(indexingOptionsValue);
        }
        indexingType(instance.indexingType());
      }
      if (object instanceof QualifiedSchemaEntity) {
        QualifiedSchemaEntity instance = (QualifiedSchemaEntity) object;
        keyspace(instance.keyspace());
      }
    }

    /**
     * Initializes the value for the {@link SecondaryIndex#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link SecondaryIndex#keyspace() keyspace} attribute.
     * @param keyspace The value for keyspace 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder keyspace(String keyspace) {
      this.keyspace = Objects.requireNonNull(keyspace, "keyspace");
      initBits &= ~INIT_BIT_KEYSPACE;
      return this;
    }

    /**
     * Initializes the value for the {@link SecondaryIndex#column() column} attribute.
     * @param column The value for column (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder column(@Nullable Column column) {
      this.column = column;
      return this;
    }

    /**
     * Initializes the value for the {@link SecondaryIndex#indexingType() indexingType} attribute.
     * @param indexingType The value for indexingType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder indexingType(CollectionIndexingType indexingType) {
      this.indexingType = Objects.requireNonNull(indexingType, "indexingType");
      initBits &= ~INIT_BIT_INDEXING_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link SecondaryIndex#isCustom() isCustom} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SecondaryIndex#isCustom() isCustom}.</em>
     * @param isCustom The value for isCustom 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isCustom(boolean isCustom) {
      this.isCustom = isCustom;
      optBits |= OPT_BIT_IS_CUSTOM;
      return this;
    }

    /**
     * Initializes the value for the {@link SecondaryIndex#indexingClass() indexingClass} attribute.
     * @param indexingClass The value for indexingClass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder indexingClass(@Nullable String indexingClass) {
      this.indexingClass = indexingClass;
      return this;
    }

    /**
     * Put one entry to the {@link SecondaryIndex#indexingOptions() indexingOptions} map.
     * @param key The key in the indexingOptions map
     * @param value The associated value in the indexingOptions map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putIndexingOptions(String key, String value) {
      if (this.indexingOptions == null) {
        this.indexingOptions = new LinkedHashMap<String, String>();
      }
      this.indexingOptions.put(
          Objects.requireNonNull(key, "indexingOptions key"),
          Objects.requireNonNull(value, "indexingOptions value"));
      return this;
    }

    /**
     * Put one entry to the {@link SecondaryIndex#indexingOptions() indexingOptions} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putIndexingOptions(Map.Entry<String, ? extends String> entry) {
      if (this.indexingOptions == null) {
        this.indexingOptions = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.indexingOptions.put(
          Objects.requireNonNull(k, "indexingOptions key"),
          Objects.requireNonNull(v, "indexingOptions value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link SecondaryIndex#indexingOptions() indexingOptions} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the indexingOptions map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder indexingOptions(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.indexingOptions = null;
        return this;
      }
      this.indexingOptions = new LinkedHashMap<String, String>();
      return putAllIndexingOptions(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link SecondaryIndex#indexingOptions() indexingOptions} map. Nulls are not permitted
     * @param entries The entries that will be added to the indexingOptions map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllIndexingOptions(Map<String, ? extends String> entries) {
      if (this.indexingOptions == null) {
        this.indexingOptions = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.indexingOptions.put(
            Objects.requireNonNull(k, "indexingOptions key"),
            Objects.requireNonNull(v, "indexingOptions value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableSecondaryIndex ImmutableSecondaryIndex}.
     * @return An immutable instance of SecondaryIndex
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSecondaryIndex build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSecondaryIndex(this);
    }

    private boolean isCustomIsSet() {
      return (optBits & OPT_BIT_IS_CUSTOM) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_KEYSPACE) != 0) attributes.add("keyspace");
      if ((initBits & INIT_BIT_INDEXING_TYPE) != 0) attributes.add("indexingType");
      return "Cannot build SecondaryIndex, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
