package io.stargate.db.schema;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ParameterizedType.SetType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSetType.builder()}.
 */
@Generated(from = "ParameterizedType.SetType", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSetType extends ParameterizedType.SetType {
  private final boolean isFrozen;
  private final List<Column.ColumnType> parameters;
  private final int schemaHashCode;
  private final int hashCode;

  private ImmutableSetType(ImmutableSetType.Builder builder) {
    this.parameters = createUnmodifiableList(true, builder.parameters);
    if (builder.isFrozenIsSet()) {
      initShim.isFrozen(builder.isFrozen);
    }
    this.isFrozen = initShim.isFrozen();
    this.schemaHashCode = initShim.schemaHashCode();
    this.hashCode = computeHashCode();
    this.initShim = null;
  }

  private ImmutableSetType(boolean isFrozen, List<Column.ColumnType> parameters) {
    initShim.isFrozen(isFrozen);
    this.parameters = parameters;
    this.isFrozen = initShim.isFrozen();
    this.schemaHashCode = initShim.schemaHashCode();
    this.hashCode = computeHashCode();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ParameterizedType.SetType", generator = "Immutables")
  private final class InitShim {
    private byte isFrozenBuildStage = STAGE_UNINITIALIZED;
    private boolean isFrozen;

    boolean isFrozen() {
      if (isFrozenBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isFrozenBuildStage == STAGE_UNINITIALIZED) {
        isFrozenBuildStage = STAGE_INITIALIZING;
        this.isFrozen = ImmutableSetType.super.isFrozen();
        isFrozenBuildStage = STAGE_INITIALIZED;
      }
      return this.isFrozen;
    }

    void isFrozen(boolean isFrozen) {
      this.isFrozen = isFrozen;
      isFrozenBuildStage = STAGE_INITIALIZED;
    }

    private byte schemaHashCodeBuildStage = STAGE_UNINITIALIZED;
    private int schemaHashCode;

    int schemaHashCode() {
      if (schemaHashCodeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (schemaHashCodeBuildStage == STAGE_UNINITIALIZED) {
        schemaHashCodeBuildStage = STAGE_INITIALIZING;
        this.schemaHashCode = ImmutableSetType.super.schemaHashCode();
        schemaHashCodeBuildStage = STAGE_INITIALIZED;
      }
      return this.schemaHashCode;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (isFrozenBuildStage == STAGE_INITIALIZING) attributes.add("isFrozen");
      if (schemaHashCodeBuildStage == STAGE_INITIALIZING) attributes.add("schemaHashCode");
      return "Cannot build SetType, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code isFrozen} attribute
   */
  @Override
  public boolean isFrozen() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFrozen()
        : this.isFrozen;
  }

  /**
   * @return The value of the {@code parameters} attribute
   */
  @Override
  public List<Column.ColumnType> parameters() {
    return parameters;
  }

  /**
   * @return The computed-at-construction value of the {@code schemaHashCode} attribute
   */
  @Override
  public int schemaHashCode() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.schemaHashCode()
        : this.schemaHashCode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ParameterizedType.SetType#isFrozen() isFrozen} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isFrozen
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSetType withIsFrozen(boolean value) {
    if (this.isFrozen == value) return this;
    return new ImmutableSetType(value, this.parameters);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ParameterizedType.SetType#parameters() parameters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSetType withParameters(Column.ColumnType... elements) {
    List<Column.ColumnType> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableSetType(this.isFrozen, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ParameterizedType.SetType#parameters() parameters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of parameters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSetType withParameters(Iterable<? extends Column.ColumnType> elements) {
    if (this.parameters == elements) return this;
    List<Column.ColumnType> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableSetType(this.isFrozen, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSetType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSetType
        && equalTo((ImmutableSetType) another);
  }

  private boolean equalTo(ImmutableSetType another) {
    if (hashCode != another.hashCode) return false;
    return isFrozen == another.isFrozen
        && parameters.equals(another.parameters);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code isFrozen}, {@code parameters}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + Boolean.hashCode(isFrozen);
    h += (h << 5) + parameters.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SetType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SetType{"
        + "isFrozen=" + isFrozen
        + ", parameters=" + parameters
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ParameterizedType.SetType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SetType instance
   */
  public static ImmutableSetType copyOf(ParameterizedType.SetType instance) {
    if (instance instanceof ImmutableSetType) {
      return (ImmutableSetType) instance;
    }
    return ImmutableSetType.builder()
        .from(instance)
        .build();
  }

  private Object readResolve() throws ObjectStreamException {
    return new ImmutableSetType(this.isFrozen, this.parameters);
  }

  /**
   * Creates a builder for {@link ImmutableSetType ImmutableSetType}.
   * <pre>
   * ImmutableSetType.builder()
   *    .isFrozen(boolean) // optional {@link ParameterizedType.SetType#isFrozen() isFrozen}
   *    .addParameters|addAllParameters(io.stargate.db.schema.Column.ColumnType) // {@link ParameterizedType.SetType#parameters() parameters} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSetType builder
   */
  public static ImmutableSetType.Builder builder() {
    return new ImmutableSetType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSetType ImmutableSetType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ParameterizedType.SetType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder extends ParameterizedType.SetType.Builder {
    private static final long OPT_BIT_IS_FROZEN = 0x1L;
    private long optBits;

    private boolean isFrozen;
    private List<Column.ColumnType> parameters = new ArrayList<Column.ColumnType>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.Column.ColumnType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Column.ColumnType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.ParameterizedType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ParameterizedType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.ParameterizedType.SetType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ParameterizedType.SetType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof Column.ColumnType) {
        Column.ColumnType instance = (Column.ColumnType) object;
        isFrozen(instance.isFrozen());
        if ((bits & 0x1L) == 0) {
          addAllParameters(instance.parameters());
          bits |= 0x1L;
        }
      }
      if (object instanceof ParameterizedType) {
        ParameterizedType instance = (ParameterizedType) object;
        if ((bits & 0x1L) == 0) {
          addAllParameters(instance.parameters());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ParameterizedType.SetType#isFrozen() isFrozen} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ParameterizedType.SetType#isFrozen() isFrozen}.</em>
     * @param isFrozen The value for isFrozen 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isFrozen(boolean isFrozen) {
      this.isFrozen = isFrozen;
      optBits |= OPT_BIT_IS_FROZEN;
      return this;
    }

    /**
     * Adds one element to {@link ParameterizedType.SetType#parameters() parameters} list.
     * @param element A parameters element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addParameters(Column.ColumnType element) {
      this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      return this;
    }

    /**
     * Adds elements to {@link ParameterizedType.SetType#parameters() parameters} list.
     * @param elements An array of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addParameters(Column.ColumnType... elements) {
      for (Column.ColumnType element : elements) {
        this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ParameterizedType.SetType#parameters() parameters} list.
     * @param elements An iterable of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder parameters(Iterable<? extends Column.ColumnType> elements) {
      this.parameters.clear();
      return addAllParameters(elements);
    }

    /**
     * Adds elements to {@link ParameterizedType.SetType#parameters() parameters} list.
     * @param elements An iterable of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllParameters(Iterable<? extends Column.ColumnType> elements) {
      for (Column.ColumnType element : elements) {
        this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableSetType ImmutableSetType}.
     * @return An immutable instance of SetType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSetType build() {
      return new ImmutableSetType(this);
    }

    private boolean isFrozenIsSet() {
      return (optBits & OPT_BIT_IS_FROZEN) != 0;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
