package io.stargate.db.schema;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Table}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTable.builder()}.
 */
@Generated(from = "Table", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTable extends Table {
  private final String name;
  private final String keyspace;
  private final List<Column> columns;
  private final List<Index> indexes;
  private final String comment;
  private final int ttl;
  private final int schemaHashCode;
  private final int hashCode;

  private ImmutableTable(ImmutableTable.Builder builder) {
    this.name = builder.name;
    this.keyspace = builder.keyspace;
    this.columns = createUnmodifiableList(true, builder.columns);
    this.indexes = createUnmodifiableList(true, builder.indexes);
    if (builder.comment != null) {
      initShim.comment(builder.comment);
    }
    if (builder.ttlIsSet()) {
      initShim.ttl(builder.ttl);
    }
    this.comment = initShim.comment();
    this.ttl = initShim.ttl();
    this.schemaHashCode = initShim.schemaHashCode();
    this.hashCode = computeHashCode();
    this.initShim = null;
  }

  private ImmutableTable(
      String name,
      String keyspace,
      List<Column> columns,
      List<Index> indexes,
      String comment,
      int ttl) {
    this.name = name;
    this.keyspace = keyspace;
    this.columns = columns;
    this.indexes = indexes;
    initShim.comment(comment);
    initShim.ttl(ttl);
    this.comment = initShim.comment();
    this.ttl = initShim.ttl();
    this.schemaHashCode = initShim.schemaHashCode();
    this.hashCode = computeHashCode();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "Table", generator = "Immutables")
  private final class InitShim {
    private byte commentBuildStage = STAGE_UNINITIALIZED;
    private String comment;

    String comment() {
      if (commentBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (commentBuildStage == STAGE_UNINITIALIZED) {
        commentBuildStage = STAGE_INITIALIZING;
        this.comment = Objects.requireNonNull(ImmutableTable.super.comment(), "comment");
        commentBuildStage = STAGE_INITIALIZED;
      }
      return this.comment;
    }

    void comment(String comment) {
      this.comment = comment;
      commentBuildStage = STAGE_INITIALIZED;
    }

    private byte ttlBuildStage = STAGE_UNINITIALIZED;
    private int ttl;

    int ttl() {
      if (ttlBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (ttlBuildStage == STAGE_UNINITIALIZED) {
        ttlBuildStage = STAGE_INITIALIZING;
        this.ttl = ImmutableTable.super.ttl();
        ttlBuildStage = STAGE_INITIALIZED;
      }
      return this.ttl;
    }

    void ttl(int ttl) {
      this.ttl = ttl;
      ttlBuildStage = STAGE_INITIALIZED;
    }

    private byte schemaHashCodeBuildStage = STAGE_UNINITIALIZED;
    private int schemaHashCode;

    int schemaHashCode() {
      if (schemaHashCodeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (schemaHashCodeBuildStage == STAGE_UNINITIALIZED) {
        schemaHashCodeBuildStage = STAGE_INITIALIZING;
        this.schemaHashCode = ImmutableTable.super.schemaHashCode();
        schemaHashCodeBuildStage = STAGE_INITIALIZED;
      }
      return this.schemaHashCode;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (commentBuildStage == STAGE_INITIALIZING) attributes.add("comment");
      if (ttlBuildStage == STAGE_INITIALIZING) attributes.add("ttl");
      if (schemaHashCodeBuildStage == STAGE_INITIALIZING) attributes.add("schemaHashCode");
      return "Cannot build Table, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code keyspace} attribute
   */
  @Override
  public String keyspace() {
    return keyspace;
  }

  /**
   * @return The value of the {@code columns} attribute
   */
  @Override
  public List<Column> columns() {
    return columns;
  }

  /**
   * @return The value of the {@code indexes} attribute
   */
  @Override
  public List<Index> indexes() {
    return indexes;
  }

  /**
   * @return The value of the {@code comment} attribute
   */
  @Override
  public String comment() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.comment()
        : this.comment;
  }

  /**
   * @return The value of the {@code ttl} attribute
   */
  @Override
  public int ttl() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.ttl()
        : this.ttl;
  }

  /**
   * @return The computed-at-construction value of the {@code schemaHashCode} attribute
   */
  @Override
  public int schemaHashCode() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.schemaHashCode()
        : this.schemaHashCode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableTable(newValue, this.keyspace, this.columns, this.indexes, this.comment, this.ttl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#keyspace() keyspace} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keyspace
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withKeyspace(String value) {
    String newValue = Objects.requireNonNull(value, "keyspace");
    if (this.keyspace.equals(newValue)) return this;
    return new ImmutableTable(this.name, newValue, this.columns, this.indexes, this.comment, this.ttl);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Table#columns() columns}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTable withColumns(Column... elements) {
    List<Column> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableTable(this.name, this.keyspace, newValue, this.indexes, this.comment, this.ttl);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Table#columns() columns}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of columns elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTable withColumns(Iterable<? extends Column> elements) {
    if (this.columns == elements) return this;
    List<Column> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableTable(this.name, this.keyspace, newValue, this.indexes, this.comment, this.ttl);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Table#indexes() indexes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTable withIndexes(Index... elements) {
    List<Index> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableTable(this.name, this.keyspace, this.columns, newValue, this.comment, this.ttl);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Table#indexes() indexes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of indexes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTable withIndexes(Iterable<? extends Index> elements) {
    if (this.indexes == elements) return this;
    List<Index> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableTable(this.name, this.keyspace, this.columns, newValue, this.comment, this.ttl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#comment() comment} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for comment
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withComment(String value) {
    String newValue = Objects.requireNonNull(value, "comment");
    if (this.comment.equals(newValue)) return this;
    return new ImmutableTable(this.name, this.keyspace, this.columns, this.indexes, newValue, this.ttl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#ttl() ttl} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ttl
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withTtl(int value) {
    if (this.ttl == value) return this;
    return new ImmutableTable(this.name, this.keyspace, this.columns, this.indexes, this.comment, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTable
        && equalTo((ImmutableTable) another);
  }

  private boolean equalTo(ImmutableTable another) {
    if (hashCode != another.hashCode) return false;
    return name.equals(another.name)
        && keyspace.equals(another.keyspace)
        && columns.equals(another.columns)
        && indexes.equals(another.indexes)
        && comment.equals(another.comment)
        && ttl == another.ttl;
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code name}, {@code keyspace}, {@code columns}, {@code indexes}, {@code comment}, {@code ttl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + keyspace.hashCode();
    h += (h << 5) + columns.hashCode();
    h += (h << 5) + indexes.hashCode();
    h += (h << 5) + comment.hashCode();
    h += (h << 5) + ttl;
    return h;
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long CQL_NAME_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient String cqlName;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Table#cqlName() cqlName} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code cqlName} attribute
   */
  @Override
  public String cqlName() {
    if ((lazyInitBitmap & CQL_NAME_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CQL_NAME_LAZY_INIT_BIT) == 0) {
          this.cqlName = Objects.requireNonNull(super.cqlName(), "cqlName");
          lazyInitBitmap |= CQL_NAME_LAZY_INIT_BIT;
        }
      }
    }
    return cqlName;
  }

  private static final long CQL_KEYSPACE_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient String cqlKeyspace;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Table#cqlKeyspace() cqlKeyspace} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code cqlKeyspace} attribute
   */
  @Override
  public String cqlKeyspace() {
    if ((lazyInitBitmap & CQL_KEYSPACE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CQL_KEYSPACE_LAZY_INIT_BIT) == 0) {
          this.cqlKeyspace = Objects.requireNonNull(super.cqlKeyspace(), "cqlKeyspace");
          lazyInitBitmap |= CQL_KEYSPACE_LAZY_INIT_BIT;
        }
      }
    }
    return cqlKeyspace;
  }

  private static final long CQL_QUALIFIED_NAME_LAZY_INIT_BIT = 0x4L;

  @SuppressWarnings("Immutable")
  private transient String cqlQualifiedName;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Table#cqlQualifiedName() cqlQualifiedName} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code cqlQualifiedName} attribute
   */
  @Override
  public String cqlQualifiedName() {
    if ((lazyInitBitmap & CQL_QUALIFIED_NAME_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CQL_QUALIFIED_NAME_LAZY_INIT_BIT) == 0) {
          this.cqlQualifiedName = Objects.requireNonNull(super.cqlQualifiedName(), "cqlQualifiedName");
          lazyInitBitmap |= CQL_QUALIFIED_NAME_LAZY_INIT_BIT;
        }
      }
    }
    return cqlQualifiedName;
  }

  private static final long COLUMN_MAP_LAZY_INIT_BIT = 0x8L;

  @SuppressWarnings("Immutable")
  private transient Map<String, Column> columnMap;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Table#columnMap() columnMap} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code columnMap} attribute
   */
  @Override
  Map<String, Column> columnMap() {
    if ((lazyInitBitmap & COLUMN_MAP_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & COLUMN_MAP_LAZY_INIT_BIT) == 0) {
          this.columnMap = Objects.requireNonNull(super.columnMap(), "columnMap");
          lazyInitBitmap |= COLUMN_MAP_LAZY_INIT_BIT;
        }
      }
    }
    return columnMap;
  }

  private static final long PARTITION_KEY_COLUMNS_LAZY_INIT_BIT = 0x10L;

  @SuppressWarnings("Immutable")
  private transient List<Column> partitionKeyColumns;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Table#partitionKeyColumns() partitionKeyColumns} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code partitionKeyColumns} attribute
   */
  @Override
  public List<Column> partitionKeyColumns() {
    if ((lazyInitBitmap & PARTITION_KEY_COLUMNS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & PARTITION_KEY_COLUMNS_LAZY_INIT_BIT) == 0) {
          this.partitionKeyColumns = Objects.requireNonNull(super.partitionKeyColumns(), "partitionKeyColumns");
          lazyInitBitmap |= PARTITION_KEY_COLUMNS_LAZY_INIT_BIT;
        }
      }
    }
    return partitionKeyColumns;
  }

  private static final long CLUSTERING_KEY_COLUMNS_LAZY_INIT_BIT = 0x20L;

  @SuppressWarnings("Immutable")
  private transient List<Column> clusteringKeyColumns;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Table#clusteringKeyColumns() clusteringKeyColumns} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code clusteringKeyColumns} attribute
   */
  @Override
  public List<Column> clusteringKeyColumns() {
    if ((lazyInitBitmap & CLUSTERING_KEY_COLUMNS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CLUSTERING_KEY_COLUMNS_LAZY_INIT_BIT) == 0) {
          this.clusteringKeyColumns = Objects.requireNonNull(super.clusteringKeyColumns(), "clusteringKeyColumns");
          lazyInitBitmap |= CLUSTERING_KEY_COLUMNS_LAZY_INIT_BIT;
        }
      }
    }
    return clusteringKeyColumns;
  }

  private static final long PRIMARY_KEY_COLUMNS_LAZY_INIT_BIT = 0x40L;

  @SuppressWarnings("Immutable")
  private transient List<Column> primaryKeyColumns;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Table#primaryKeyColumns() primaryKeyColumns} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code primaryKeyColumns} attribute
   */
  @Override
  public List<Column> primaryKeyColumns() {
    if ((lazyInitBitmap & PRIMARY_KEY_COLUMNS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & PRIMARY_KEY_COLUMNS_LAZY_INIT_BIT) == 0) {
          this.primaryKeyColumns = Objects.requireNonNull(super.primaryKeyColumns(), "primaryKeyColumns");
          lazyInitBitmap |= PRIMARY_KEY_COLUMNS_LAZY_INIT_BIT;
        }
      }
    }
    return primaryKeyColumns;
  }

  private static final long REGULAR_AND_STATIC_COLUMNS_LAZY_INIT_BIT = 0x80L;

  @SuppressWarnings("Immutable")
  private transient List<Column> regularAndStaticColumns;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Table#regularAndStaticColumns() regularAndStaticColumns} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code regularAndStaticColumns} attribute
   */
  @Override
  public List<Column> regularAndStaticColumns() {
    if ((lazyInitBitmap & REGULAR_AND_STATIC_COLUMNS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & REGULAR_AND_STATIC_COLUMNS_LAZY_INIT_BIT) == 0) {
          this.regularAndStaticColumns = Objects.requireNonNull(super.regularAndStaticColumns(), "regularAndStaticColumns");
          lazyInitBitmap |= REGULAR_AND_STATIC_COLUMNS_LAZY_INIT_BIT;
        }
      }
    }
    return regularAndStaticColumns;
  }

  private static final long REQUIRED_INDEX_COLUMNS_LAZY_INIT_BIT = 0x100L;

  @SuppressWarnings("Immutable")
  private transient Set<Column> requiredIndexColumns;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Table#getRequiredIndexColumns() requiredIndexColumns} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code requiredIndexColumns} attribute
   */
  @Override
  public Set<Column> getRequiredIndexColumns() {
    if ((lazyInitBitmap & REQUIRED_INDEX_COLUMNS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & REQUIRED_INDEX_COLUMNS_LAZY_INIT_BIT) == 0) {
          this.requiredIndexColumns = Objects.requireNonNull(super.getRequiredIndexColumns(), "requiredIndexColumns");
          lazyInitBitmap |= REQUIRED_INDEX_COLUMNS_LAZY_INIT_BIT;
        }
      }
    }
    return requiredIndexColumns;
  }

  private static final long OPTIONAL_INDEX_COLUMNS_LAZY_INIT_BIT = 0x200L;

  @SuppressWarnings("Immutable")
  private transient Set<Column> optionalIndexColumns;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Table#getOptionalIndexColumns() optionalIndexColumns} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code optionalIndexColumns} attribute
   */
  @Override
  public Set<Column> getOptionalIndexColumns() {
    if ((lazyInitBitmap & OPTIONAL_INDEX_COLUMNS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & OPTIONAL_INDEX_COLUMNS_LAZY_INIT_BIT) == 0) {
          this.optionalIndexColumns = Objects.requireNonNull(super.getOptionalIndexColumns(), "optionalIndexColumns");
          lazyInitBitmap |= OPTIONAL_INDEX_COLUMNS_LAZY_INIT_BIT;
        }
      }
    }
    return optionalIndexColumns;
  }

  private static final long INDEX_MAP_LAZY_INIT_BIT = 0x400L;

  @SuppressWarnings("Immutable")
  private transient Map<String, Index> indexMap;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Table#indexMap() indexMap} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code indexMap} attribute
   */
  @Override
  Map<String, Index> indexMap() {
    if ((lazyInitBitmap & INDEX_MAP_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & INDEX_MAP_LAZY_INIT_BIT) == 0) {
          this.indexMap = Objects.requireNonNull(super.indexMap(), "indexMap");
          lazyInitBitmap |= INDEX_MAP_LAZY_INIT_BIT;
        }
      }
    }
    return indexMap;
  }

  /**
   * Creates an immutable copy of a {@link Table} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Table instance
   */
  public static ImmutableTable copyOf(Table instance) {
    if (instance instanceof ImmutableTable) {
      return (ImmutableTable) instance;
    }
    return ImmutableTable.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 5913904335622827700L;

  private Object readResolve() throws ObjectStreamException {
    return new ImmutableTable(this.name, this.keyspace, this.columns, this.indexes, this.comment, this.ttl);
  }

  /**
   * Creates a builder for {@link ImmutableTable ImmutableTable}.
   * <pre>
   * ImmutableTable.builder()
   *    .name(String) // required {@link Table#name() name}
   *    .keyspace(String) // required {@link Table#keyspace() keyspace}
   *    .addColumns|addAllColumns(io.stargate.db.schema.Column) // {@link Table#columns() columns} elements
   *    .addIndexes|addAllIndexes(io.stargate.db.schema.Index) // {@link Table#indexes() indexes} elements
   *    .comment(String) // optional {@link Table#comment() comment}
   *    .ttl(int) // optional {@link Table#ttl() ttl}
   *    .build();
   * </pre>
   * @return A new ImmutableTable builder
   */
  public static ImmutableTable.Builder builder() {
    return new ImmutableTable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTable ImmutableTable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Table", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_KEYSPACE = 0x2L;
    private static final long OPT_BIT_TTL = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private @Nullable String name;
    private @Nullable String keyspace;
    private List<Column> columns = new ArrayList<Column>();
    private List<Index> indexes = new ArrayList<Index>();
    private @Nullable String comment;
    private int ttl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.SchemaEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SchemaEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.QualifiedSchemaEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(QualifiedSchemaEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.AbstractTable} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AbstractTable instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.Table} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Table instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof SchemaEntity) {
        SchemaEntity instance = (SchemaEntity) object;
        name(instance.name());
      }
      if (object instanceof QualifiedSchemaEntity) {
        QualifiedSchemaEntity instance = (QualifiedSchemaEntity) object;
        keyspace(instance.keyspace());
      }
      if (object instanceof AbstractTable) {
        AbstractTable instance = (AbstractTable) object;
        if ((bits & 0x2L) == 0) {
          ttl(instance.ttl());
          bits |= 0x2L;
        }
        addAllColumns(instance.columns());
        if ((bits & 0x1L) == 0) {
          comment(instance.comment());
          bits |= 0x1L;
        }
      }
      if (object instanceof Table) {
        Table instance = (Table) object;
        addAllIndexes(instance.indexes());
        if ((bits & 0x2L) == 0) {
          ttl(instance.ttl());
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          comment(instance.comment());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link Table#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#keyspace() keyspace} attribute.
     * @param keyspace The value for keyspace 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder keyspace(String keyspace) {
      this.keyspace = Objects.requireNonNull(keyspace, "keyspace");
      initBits &= ~INIT_BIT_KEYSPACE;
      return this;
    }

    /**
     * Adds one element to {@link Table#columns() columns} list.
     * @param element A columns element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addColumns(Column element) {
      this.columns.add(Objects.requireNonNull(element, "columns element"));
      return this;
    }

    /**
     * Adds elements to {@link Table#columns() columns} list.
     * @param elements An array of columns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addColumns(Column... elements) {
      for (Column element : elements) {
        this.columns.add(Objects.requireNonNull(element, "columns element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Table#columns() columns} list.
     * @param elements An iterable of columns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder columns(Iterable<? extends Column> elements) {
      this.columns.clear();
      return addAllColumns(elements);
    }

    /**
     * Adds elements to {@link Table#columns() columns} list.
     * @param elements An iterable of columns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllColumns(Iterable<? extends Column> elements) {
      for (Column element : elements) {
        this.columns.add(Objects.requireNonNull(element, "columns element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Table#indexes() indexes} list.
     * @param element A indexes element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addIndexes(Index element) {
      this.indexes.add(Objects.requireNonNull(element, "indexes element"));
      return this;
    }

    /**
     * Adds elements to {@link Table#indexes() indexes} list.
     * @param elements An array of indexes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addIndexes(Index... elements) {
      for (Index element : elements) {
        this.indexes.add(Objects.requireNonNull(element, "indexes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Table#indexes() indexes} list.
     * @param elements An iterable of indexes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder indexes(Iterable<? extends Index> elements) {
      this.indexes.clear();
      return addAllIndexes(elements);
    }

    /**
     * Adds elements to {@link Table#indexes() indexes} list.
     * @param elements An iterable of indexes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllIndexes(Iterable<? extends Index> elements) {
      for (Index element : elements) {
        this.indexes.add(Objects.requireNonNull(element, "indexes element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Table#comment() comment} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Table#comment() comment}.</em>
     * @param comment The value for comment 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder comment(String comment) {
      this.comment = Objects.requireNonNull(comment, "comment");
      return this;
    }

    /**
     * Initializes the value for the {@link Table#ttl() ttl} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Table#ttl() ttl}.</em>
     * @param ttl The value for ttl 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ttl(int ttl) {
      this.ttl = ttl;
      optBits |= OPT_BIT_TTL;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTable ImmutableTable}.
     * @return An immutable instance of Table
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTable build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTable(this);
    }

    private boolean ttlIsSet() {
      return (optBits & OPT_BIT_TTL) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_KEYSPACE) != 0) attributes.add("keyspace");
      return "Cannot build Table, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
