package io.stargate.db.schema;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TableName}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTableName.builder()}.
 */
@Generated(from = "TableName", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTableName implements TableName {
  private final String name;
  private final String keyspace;
  private final int schemaHashCode;

  private ImmutableTableName(String name, String keyspace) {
    this.name = name;
    this.keyspace = keyspace;
    this.schemaHashCode = TableName.super.schemaHashCode();
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code keyspace} attribute
   */
  @Override
  public String keyspace() {
    return keyspace;
  }

  /**
   * @return The computed-at-construction value of the {@code schemaHashCode} attribute
   */
  @Override
  public int schemaHashCode() {
    return schemaHashCode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TableName#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTableName withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableTableName(newValue, this.keyspace);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TableName#keyspace() keyspace} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keyspace
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTableName withKeyspace(String value) {
    String newValue = Objects.requireNonNull(value, "keyspace");
    if (this.keyspace.equals(newValue)) return this;
    return new ImmutableTableName(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTableName} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTableName
        && equalTo((ImmutableTableName) another);
  }

  private boolean equalTo(ImmutableTableName another) {
    return name.equals(another.name)
        && keyspace.equals(another.keyspace);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code keyspace}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + keyspace.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TableName} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TableName{"
        + "name=" + name
        + ", keyspace=" + keyspace
        + "}";
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long CQL_NAME_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient String cqlName;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link TableName#cqlName() cqlName} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code cqlName} attribute
   */
  @Override
  public String cqlName() {
    if ((lazyInitBitmap & CQL_NAME_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CQL_NAME_LAZY_INIT_BIT) == 0) {
          this.cqlName = Objects.requireNonNull(TableName.super.cqlName(), "cqlName");
          lazyInitBitmap |= CQL_NAME_LAZY_INIT_BIT;
        }
      }
    }
    return cqlName;
  }

  private static final long CQL_KEYSPACE_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient String cqlKeyspace;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link TableName#cqlKeyspace() cqlKeyspace} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code cqlKeyspace} attribute
   */
  @Override
  public String cqlKeyspace() {
    if ((lazyInitBitmap & CQL_KEYSPACE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CQL_KEYSPACE_LAZY_INIT_BIT) == 0) {
          this.cqlKeyspace = Objects.requireNonNull(TableName.super.cqlKeyspace(), "cqlKeyspace");
          lazyInitBitmap |= CQL_KEYSPACE_LAZY_INIT_BIT;
        }
      }
    }
    return cqlKeyspace;
  }

  private static final long CQL_QUALIFIED_NAME_LAZY_INIT_BIT = 0x4L;

  @SuppressWarnings("Immutable")
  private transient String cqlQualifiedName;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link TableName#cqlQualifiedName() cqlQualifiedName} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code cqlQualifiedName} attribute
   */
  @Override
  public String cqlQualifiedName() {
    if ((lazyInitBitmap & CQL_QUALIFIED_NAME_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CQL_QUALIFIED_NAME_LAZY_INIT_BIT) == 0) {
          this.cqlQualifiedName = Objects.requireNonNull(TableName.super.cqlQualifiedName(), "cqlQualifiedName");
          lazyInitBitmap |= CQL_QUALIFIED_NAME_LAZY_INIT_BIT;
        }
      }
    }
    return cqlQualifiedName;
  }

  /**
   * Creates an immutable copy of a {@link TableName} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TableName instance
   */
  public static ImmutableTableName copyOf(TableName instance) {
    if (instance instanceof ImmutableTableName) {
      return (ImmutableTableName) instance;
    }
    return ImmutableTableName.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTableName ImmutableTableName}.
   * <pre>
   * ImmutableTableName.builder()
   *    .name(String) // required {@link TableName#name() name}
   *    .keyspace(String) // required {@link TableName#keyspace() keyspace}
   *    .build();
   * </pre>
   * @return A new ImmutableTableName builder
   */
  public static ImmutableTableName.Builder builder() {
    return new ImmutableTableName.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTableName ImmutableTableName}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TableName", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_KEYSPACE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private @Nullable String keyspace;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.SchemaEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SchemaEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.QualifiedSchemaEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(QualifiedSchemaEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.TableName} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TableName instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SchemaEntity) {
        SchemaEntity instance = (SchemaEntity) object;
        name(instance.name());
      }
      if (object instanceof QualifiedSchemaEntity) {
        QualifiedSchemaEntity instance = (QualifiedSchemaEntity) object;
        keyspace(instance.keyspace());
      }
    }

    /**
     * Initializes the value for the {@link TableName#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link TableName#keyspace() keyspace} attribute.
     * @param keyspace The value for keyspace 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder keyspace(String keyspace) {
      this.keyspace = Objects.requireNonNull(keyspace, "keyspace");
      initBits &= ~INIT_BIT_KEYSPACE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTableName ImmutableTableName}.
     * @return An immutable instance of TableName
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTableName build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTableName(name, keyspace);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_KEYSPACE) != 0) attributes.add("keyspace");
      return "Cannot build TableName, some of required attributes are not set " + attributes;
    }
  }
}
