package io.stargate.db.schema;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ParameterizedType.TupleType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTupleType.builder()}.
 */
@Generated(from = "ParameterizedType.TupleType", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTupleType extends ParameterizedType.TupleType {
  private final List<Column.ColumnType> parameters;
  private final int schemaHashCode;
  private final int hashCode;

  private ImmutableTupleType(List<Column.ColumnType> parameters) {
    this.parameters = parameters;
    this.schemaHashCode = super.schemaHashCode();
    this.hashCode = computeHashCode();
  }

  /**
   * @return The value of the {@code parameters} attribute
   */
  @Override
  public List<Column.ColumnType> parameters() {
    return parameters;
  }

  /**
   * @return The computed-at-construction value of the {@code schemaHashCode} attribute
   */
  @Override
  public int schemaHashCode() {
    return schemaHashCode;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ParameterizedType.TupleType#parameters() parameters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTupleType withParameters(Column.ColumnType... elements) {
    List<Column.ColumnType> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableTupleType(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ParameterizedType.TupleType#parameters() parameters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of parameters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTupleType withParameters(Iterable<? extends Column.ColumnType> elements) {
    if (this.parameters == elements) return this;
    List<Column.ColumnType> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableTupleType(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTupleType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTupleType
        && equalTo((ImmutableTupleType) another);
  }

  private boolean equalTo(ImmutableTupleType another) {
    if (hashCode != another.hashCode) return false;
    return parameters.equals(another.parameters);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code parameters}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + parameters.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TupleType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TupleType{"
        + "parameters=" + parameters
        + "}";
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long PARAMETER_MAP_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Map<String, Column.ColumnType> parameterMap;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ParameterizedType.TupleType#parameterMap() parameterMap} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code parameterMap} attribute
   */
  @Override
  public Map<String, Column.ColumnType> parameterMap() {
    if ((lazyInitBitmap & PARAMETER_MAP_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & PARAMETER_MAP_LAZY_INIT_BIT) == 0) {
          this.parameterMap = Objects.requireNonNull(super.parameterMap(), "parameterMap");
          lazyInitBitmap |= PARAMETER_MAP_LAZY_INIT_BIT;
        }
      }
    }
    return parameterMap;
  }

  /**
   * Creates an immutable copy of a {@link ParameterizedType.TupleType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TupleType instance
   */
  public static ImmutableTupleType copyOf(ParameterizedType.TupleType instance) {
    if (instance instanceof ImmutableTupleType) {
      return (ImmutableTupleType) instance;
    }
    return ImmutableTupleType.builder()
        .from(instance)
        .build();
  }

  private Object readResolve() throws ObjectStreamException {
    return new ImmutableTupleType(this.parameters);
  }

  /**
   * Creates a builder for {@link ImmutableTupleType ImmutableTupleType}.
   * <pre>
   * ImmutableTupleType.builder()
   *    .addParameters|addAllParameters(io.stargate.db.schema.Column.ColumnType) // {@link ParameterizedType.TupleType#parameters() parameters} elements
   *    .build();
   * </pre>
   * @return A new ImmutableTupleType builder
   */
  public static ImmutableTupleType.Builder builder() {
    return new ImmutableTupleType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTupleType ImmutableTupleType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ParameterizedType.TupleType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder extends ParameterizedType.TupleType.Builder {
    private List<Column.ColumnType> parameters = new ArrayList<Column.ColumnType>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.Column.ColumnType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Column.ColumnType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.ParameterizedType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ParameterizedType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.ParameterizedType.TupleType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ParameterizedType.TupleType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof Column.ColumnType) {
        Column.ColumnType instance = (Column.ColumnType) object;
        if ((bits & 0x1L) == 0) {
          addAllParameters(instance.parameters());
          bits |= 0x1L;
        }
      }
      if (object instanceof ParameterizedType) {
        ParameterizedType instance = (ParameterizedType) object;
        if ((bits & 0x1L) == 0) {
          addAllParameters(instance.parameters());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Adds one element to {@link ParameterizedType.TupleType#parameters() parameters} list.
     * @param element A parameters element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addParameters(Column.ColumnType element) {
      this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      return this;
    }

    /**
     * Adds elements to {@link ParameterizedType.TupleType#parameters() parameters} list.
     * @param elements An array of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addParameters(Column.ColumnType... elements) {
      for (Column.ColumnType element : elements) {
        this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ParameterizedType.TupleType#parameters() parameters} list.
     * @param elements An iterable of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder parameters(Iterable<? extends Column.ColumnType> elements) {
      this.parameters.clear();
      return addAllParameters(elements);
    }

    /**
     * Adds elements to {@link ParameterizedType.TupleType#parameters() parameters} list.
     * @param elements An iterable of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllParameters(Iterable<? extends Column.ColumnType> elements) {
      for (Column.ColumnType element : elements) {
        this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableTupleType ImmutableTupleType}.
     * @return An immutable instance of TupleType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTupleType build() {
      return new ImmutableTupleType(createUnmodifiableList(true, parameters));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
