package io.stargate.db.schema;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UserDefinedType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUserDefinedType.builder()}.
 */
@Generated(from = "UserDefinedType", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableUserDefinedType extends UserDefinedType {
  private final boolean isFrozen;
  private final String name;
  private final String keyspace;
  private final List<Column> columns;
  private final int schemaHashCode;
  private final int hashCode;

  private ImmutableUserDefinedType(ImmutableUserDefinedType.Builder builder) {
    this.name = builder.name;
    this.keyspace = builder.keyspace;
    this.columns = createUnmodifiableList(true, builder.columns);
    if (builder.isFrozenIsSet()) {
      initShim.isFrozen(builder.isFrozen);
    }
    this.isFrozen = initShim.isFrozen();
    this.schemaHashCode = initShim.schemaHashCode();
    this.hashCode = computeHashCode();
    this.initShim = null;
  }

  private ImmutableUserDefinedType(
      boolean isFrozen,
      String name,
      String keyspace,
      List<Column> columns) {
    initShim.isFrozen(isFrozen);
    this.name = name;
    this.keyspace = keyspace;
    this.columns = columns;
    this.isFrozen = initShim.isFrozen();
    this.schemaHashCode = initShim.schemaHashCode();
    this.hashCode = computeHashCode();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "UserDefinedType", generator = "Immutables")
  private final class InitShim {
    private byte isFrozenBuildStage = STAGE_UNINITIALIZED;
    private boolean isFrozen;

    boolean isFrozen() {
      if (isFrozenBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isFrozenBuildStage == STAGE_UNINITIALIZED) {
        isFrozenBuildStage = STAGE_INITIALIZING;
        this.isFrozen = ImmutableUserDefinedType.super.isFrozen();
        isFrozenBuildStage = STAGE_INITIALIZED;
      }
      return this.isFrozen;
    }

    void isFrozen(boolean isFrozen) {
      this.isFrozen = isFrozen;
      isFrozenBuildStage = STAGE_INITIALIZED;
    }

    private byte schemaHashCodeBuildStage = STAGE_UNINITIALIZED;
    private int schemaHashCode;

    int schemaHashCode() {
      if (schemaHashCodeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (schemaHashCodeBuildStage == STAGE_UNINITIALIZED) {
        schemaHashCodeBuildStage = STAGE_INITIALIZING;
        this.schemaHashCode = ImmutableUserDefinedType.super.schemaHashCode();
        schemaHashCodeBuildStage = STAGE_INITIALIZED;
      }
      return this.schemaHashCode;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (isFrozenBuildStage == STAGE_INITIALIZING) attributes.add("isFrozen");
      if (schemaHashCodeBuildStage == STAGE_INITIALIZING) attributes.add("schemaHashCode");
      return "Cannot build UserDefinedType, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code isFrozen} attribute
   */
  @Override
  public boolean isFrozen() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFrozen()
        : this.isFrozen;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code keyspace} attribute
   */
  @Override
  public String keyspace() {
    return keyspace;
  }

  /**
   * @return The value of the {@code columns} attribute
   */
  @Override
  public List<Column> columns() {
    return columns;
  }

  /**
   * @return The computed-at-construction value of the {@code schemaHashCode} attribute
   */
  @Override
  public int schemaHashCode() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.schemaHashCode()
        : this.schemaHashCode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserDefinedType#isFrozen() isFrozen} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isFrozen
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserDefinedType withIsFrozen(boolean value) {
    if (this.isFrozen == value) return this;
    return new ImmutableUserDefinedType(value, this.name, this.keyspace, this.columns);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserDefinedType#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserDefinedType withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableUserDefinedType(this.isFrozen, newValue, this.keyspace, this.columns);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserDefinedType#keyspace() keyspace} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keyspace
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserDefinedType withKeyspace(String value) {
    String newValue = Objects.requireNonNull(value, "keyspace");
    if (this.keyspace.equals(newValue)) return this;
    return new ImmutableUserDefinedType(this.isFrozen, this.name, newValue, this.columns);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UserDefinedType#columns() columns}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUserDefinedType withColumns(Column... elements) {
    List<Column> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableUserDefinedType(this.isFrozen, this.name, this.keyspace, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UserDefinedType#columns() columns}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of columns elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUserDefinedType withColumns(Iterable<? extends Column> elements) {
    if (this.columns == elements) return this;
    List<Column> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableUserDefinedType(this.isFrozen, this.name, this.keyspace, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUserDefinedType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUserDefinedType
        && equalTo((ImmutableUserDefinedType) another);
  }

  private boolean equalTo(ImmutableUserDefinedType another) {
    if (hashCode != another.hashCode) return false;
    return isFrozen == another.isFrozen
        && name.equals(another.name)
        && keyspace.equals(another.keyspace)
        && columns.equals(another.columns);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code isFrozen}, {@code name}, {@code keyspace}, {@code columns}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + Boolean.hashCode(isFrozen);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + keyspace.hashCode();
    h += (h << 5) + columns.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UserDefinedType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UserDefinedType{"
        + "isFrozen=" + isFrozen
        + ", name=" + name
        + ", keyspace=" + keyspace
        + ", columns=" + columns
        + "}";
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long CQL_NAME_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient String cqlName;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link UserDefinedType#cqlName() cqlName} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code cqlName} attribute
   */
  @Override
  public String cqlName() {
    if ((lazyInitBitmap & CQL_NAME_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CQL_NAME_LAZY_INIT_BIT) == 0) {
          this.cqlName = Objects.requireNonNull(super.cqlName(), "cqlName");
          lazyInitBitmap |= CQL_NAME_LAZY_INIT_BIT;
        }
      }
    }
    return cqlName;
  }

  private static final long COLUMN_MAP_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient Map<String, Column> columnMap;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link UserDefinedType#columnMap() columnMap} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code columnMap} attribute
   */
  @Override
  public Map<String, Column> columnMap() {
    if ((lazyInitBitmap & COLUMN_MAP_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & COLUMN_MAP_LAZY_INIT_BIT) == 0) {
          this.columnMap = Objects.requireNonNull(super.columnMap(), "columnMap");
          lazyInitBitmap |= COLUMN_MAP_LAZY_INIT_BIT;
        }
      }
    }
    return columnMap;
  }

  private static final long CODEC_LAZY_INIT_BIT = 0x4L;

  @SuppressWarnings("Immutable")
  private transient TypeCodec codec;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link UserDefinedType#codec() codec} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code codec} attribute
   */
  @Override
  public TypeCodec codec() {
    if ((lazyInitBitmap & CODEC_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CODEC_LAZY_INIT_BIT) == 0) {
          this.codec = Objects.requireNonNull(super.codec(), "codec");
          lazyInitBitmap |= CODEC_LAZY_INIT_BIT;
        }
      }
    }
    return codec;
  }

  /**
   * Creates an immutable copy of a {@link UserDefinedType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UserDefinedType instance
   */
  public static ImmutableUserDefinedType copyOf(UserDefinedType instance) {
    if (instance instanceof ImmutableUserDefinedType) {
      return (ImmutableUserDefinedType) instance;
    }
    return ImmutableUserDefinedType.builder()
        .from(instance)
        .build();
  }

  private Object readResolve() throws ObjectStreamException {
    return new ImmutableUserDefinedType(this.isFrozen, this.name, this.keyspace, this.columns);
  }

  /**
   * Creates a builder for {@link ImmutableUserDefinedType ImmutableUserDefinedType}.
   * <pre>
   * ImmutableUserDefinedType.builder()
   *    .isFrozen(boolean) // optional {@link UserDefinedType#isFrozen() isFrozen}
   *    .name(String) // required {@link UserDefinedType#name() name}
   *    .keyspace(String) // required {@link UserDefinedType#keyspace() keyspace}
   *    .addColumns|addAllColumns(io.stargate.db.schema.Column) // {@link UserDefinedType#columns() columns} elements
   *    .build();
   * </pre>
   * @return A new ImmutableUserDefinedType builder
   */
  public static ImmutableUserDefinedType.Builder builder() {
    return new ImmutableUserDefinedType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUserDefinedType ImmutableUserDefinedType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UserDefinedType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_KEYSPACE = 0x2L;
    private static final long OPT_BIT_IS_FROZEN = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private boolean isFrozen;
    private @Nullable String name;
    private @Nullable String keyspace;
    private List<Column> columns = new ArrayList<Column>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.SchemaEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SchemaEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.UserDefinedType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UserDefinedType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.stargate.db.schema.Column.ColumnType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Column.ColumnType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof SchemaEntity) {
        SchemaEntity instance = (SchemaEntity) object;
        if ((bits & 0x1L) == 0) {
          name(instance.name());
          bits |= 0x1L;
        }
      }
      if (object instanceof UserDefinedType) {
        UserDefinedType instance = (UserDefinedType) object;
        keyspace(instance.keyspace());
        addAllColumns(instance.columns());
      }
      if (object instanceof Column.ColumnType) {
        Column.ColumnType instance = (Column.ColumnType) object;
        if ((bits & 0x1L) == 0) {
          name(instance.name());
          bits |= 0x1L;
        }
        isFrozen(instance.isFrozen());
      }
    }

    /**
     * Initializes the value for the {@link UserDefinedType#isFrozen() isFrozen} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link UserDefinedType#isFrozen() isFrozen}.</em>
     * @param isFrozen The value for isFrozen 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isFrozen(boolean isFrozen) {
      this.isFrozen = isFrozen;
      optBits |= OPT_BIT_IS_FROZEN;
      return this;
    }

    /**
     * Initializes the value for the {@link UserDefinedType#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UserDefinedType#keyspace() keyspace} attribute.
     * @param keyspace The value for keyspace 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder keyspace(String keyspace) {
      this.keyspace = Objects.requireNonNull(keyspace, "keyspace");
      initBits &= ~INIT_BIT_KEYSPACE;
      return this;
    }

    /**
     * Adds one element to {@link UserDefinedType#columns() columns} list.
     * @param element A columns element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addColumns(Column element) {
      this.columns.add(Objects.requireNonNull(element, "columns element"));
      return this;
    }

    /**
     * Adds elements to {@link UserDefinedType#columns() columns} list.
     * @param elements An array of columns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addColumns(Column... elements) {
      for (Column element : elements) {
        this.columns.add(Objects.requireNonNull(element, "columns element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UserDefinedType#columns() columns} list.
     * @param elements An iterable of columns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder columns(Iterable<? extends Column> elements) {
      this.columns.clear();
      return addAllColumns(elements);
    }

    /**
     * Adds elements to {@link UserDefinedType#columns() columns} list.
     * @param elements An iterable of columns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllColumns(Iterable<? extends Column> elements) {
      for (Column element : elements) {
        this.columns.add(Objects.requireNonNull(element, "columns element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableUserDefinedType ImmutableUserDefinedType}.
     * @return An immutable instance of UserDefinedType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUserDefinedType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUserDefinedType(this);
    }

    private boolean isFrozenIsSet() {
      return (optBits & OPT_BIT_IS_FROZEN) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_KEYSPACE) != 0) attributes.add("keyspace");
      return "Cannot build UserDefinedType, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
