/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.primitives.UnsignedBytes;
import com.datastax.oss.protocol.internal.util.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import net.jcip.annotations.Immutable;

@Immutable
public class ByteOrderedToken
implements Token {
    private final ByteBuffer value;

    public ByteOrderedToken(@NonNull ByteBuffer value) {
        this.value = ByteBuffer.wrap(Bytes.getArray((ByteBuffer)value)).asReadOnlyBuffer();
    }

    @NonNull
    public ByteBuffer getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ByteOrderedToken) {
            ByteOrderedToken that = (ByteOrderedToken)other;
            return this.value.equals(that.getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(@NonNull Token other) {
        Preconditions.checkArgument(other instanceof ByteOrderedToken, "Can only compare tokens of the same type");
        return UnsignedBytes.lexicographicalComparator().compare(Bytes.getArray((ByteBuffer)this.value), Bytes.getArray((ByteBuffer)((ByteOrderedToken)other).value));
    }

    public String toString() {
        return "ByteOrderedToken(" + Bytes.toHexString((ByteBuffer)this.value) + ")";
    }
}

