/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.datastax.dse.driver.api.core.metrics.DseNodeMetric;
import com.datastax.dse.driver.api.core.metrics.DseSessionMetric;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricPaths {
    private static final Logger LOG = LoggerFactory.getLogger(MetricPaths.class);

    public static Set<SessionMetric> parseSessionMetricPaths(List<String> paths, String logPrefix) {
        HashSet<DefaultSessionMetric> result = new HashSet<DefaultSessionMetric>();
        for (String path : paths) {
            try {
                result.add(DefaultSessionMetric.fromPath(path));
            }
            catch (IllegalArgumentException e) {
                try {
                    result.add((DefaultSessionMetric)DseSessionMetric.fromPath((String)path));
                }
                catch (IllegalArgumentException e1) {
                    LOG.warn("[{}] Unknown session metric {}, skipping", (Object)logPrefix, (Object)path);
                }
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public static Set<NodeMetric> parseNodeMetricPaths(List<String> paths, String logPrefix) {
        HashSet<DefaultNodeMetric> result = new HashSet<DefaultNodeMetric>();
        for (String path : paths) {
            try {
                result.add(DefaultNodeMetric.fromPath(path));
            }
            catch (IllegalArgumentException e) {
                try {
                    result.add((DefaultNodeMetric)DseNodeMetric.fromPath((String)path));
                }
                catch (IllegalArgumentException e1) {
                    LOG.warn("[{}] Unknown node metric {}, skipping", (Object)logPrefix, (Object)path);
                }
            }
        }
        return Collections.unmodifiableSet(result);
    }
}

