/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.ssl;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.ssl.SslEngineFactory;
import com.datastax.oss.driver.internal.core.metadata.SniEndPoint;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.InetSocketAddress;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class SniSslEngineFactory
implements SslEngineFactory {
    private static final int FAKE_PORT_OFFSET = 49152;
    private final SSLContext sslContext;
    private final CopyOnWriteArrayList<String> fakePorts = new CopyOnWriteArrayList();

    public SniSslEngineFactory(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Override
    @NonNull
    public SSLEngine newSslEngine(@NonNull EndPoint remoteEndpoint) {
        if (!(remoteEndpoint instanceof SniEndPoint)) {
            throw new IllegalArgumentException(String.format("Configuration error: can only use %s with SNI end points", this.getClass().getSimpleName()));
        }
        SniEndPoint sniEndPoint = (SniEndPoint)remoteEndpoint;
        InetSocketAddress address = sniEndPoint.resolve();
        String sniServerName = sniEndPoint.getServerName();
        SSLEngine engine = this.sslContext.createSSLEngine(address.getHostName(), this.getFakePort(sniServerName));
        engine.setUseClientMode(true);
        SSLParameters parameters = engine.getSSLParameters();
        parameters.setServerNames(ImmutableList.of(new SNIHostName(sniServerName)));
        parameters.setEndpointIdentificationAlgorithm("HTTPS");
        engine.setSSLParameters(parameters);
        return engine;
    }

    private int getFakePort(String sniServerName) {
        this.fakePorts.addIfAbsent(sniServerName);
        return 49152 + this.fakePorts.indexOf(sniServerName);
    }

    @Override
    public void close() {
    }
}

