/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.registry;

import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.CustomType;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.CodecNotFoundException;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.MutableCodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.reflect.TypeToken;
import com.datastax.oss.protocol.internal.util.IntMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class CachingCodecRegistry
implements MutableCodecRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(CachingCodecRegistry.class);
    protected final String logPrefix;
    private final TypeCodec<?>[] primitiveCodecs;
    private final CopyOnWriteArrayList<TypeCodec<?>> userCodecs = new CopyOnWriteArrayList();
    private final IntMap<TypeCodec<?>> primitiveCodecsByCode;
    private final Lock registerLock = new ReentrantLock();
    private static final GenericType<List<Boolean>> JAVA_TYPE_FOR_EMPTY_LISTS = GenericType.listOf(Boolean.class);
    private static final GenericType<Set<Boolean>> JAVA_TYPE_FOR_EMPTY_SETS = GenericType.setOf(Boolean.class);
    private static final GenericType<Map<Boolean, Boolean>> JAVA_TYPE_FOR_EMPTY_MAPS = GenericType.mapOf(Boolean.class, Boolean.class);
    private static final DataType CQL_TYPE_FOR_EMPTY_LISTS = DataTypes.listOf(DataTypes.BOOLEAN);
    private static final DataType CQL_TYPE_FOR_EMPTY_SETS = DataTypes.setOf(DataTypes.BOOLEAN);
    private static final DataType CQL_TYPE_FOR_EMPTY_MAPS = DataTypes.mapOf(DataTypes.BOOLEAN, DataTypes.BOOLEAN);

    protected CachingCodecRegistry(@NonNull String logPrefix, @NonNull TypeCodec<?>[] primitiveCodecs) {
        this.logPrefix = logPrefix;
        this.primitiveCodecs = primitiveCodecs;
        this.primitiveCodecsByCode = CachingCodecRegistry.sortByProtocolCode(primitiveCodecs);
    }

    @Deprecated
    protected CachingCodecRegistry(@NonNull String logPrefix, @NonNull TypeCodec<?>[] primitiveCodecs, @NonNull TypeCodec<?>[] userCodecs) {
        this(logPrefix, primitiveCodecs);
        this.register(userCodecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(TypeCodec<?> newCodec) {
        this.registerLock.lock();
        try {
            for (TypeCodec<?> primitiveCodec : this.primitiveCodecs) {
                if (!this.collides(newCodec, primitiveCodec)) continue;
                LOG.warn("[{}] Ignoring codec {} because it collides with built-in primitive codec {}", new Object[]{this.logPrefix, newCodec, primitiveCodec});
                return;
            }
            for (TypeCodec typeCodec : this.userCodecs) {
                if (!this.collides(newCodec, typeCodec)) continue;
                LOG.warn("[{}] Ignoring codec {} because it collides with previously registered codec {}", new Object[]{this.logPrefix, newCodec, typeCodec});
                return;
            }
            try {
                TypeCodec<?> cachedCodec = this.getCachedCodec(newCodec.getCqlType(), newCodec.getJavaType(), false);
                LOG.warn("[{}] Ignoring codec {} because it collides with previously generated codec {}", new Object[]{this.logPrefix, newCodec, cachedCodec});
                return;
            }
            catch (CodecNotFoundException codecNotFoundException) {
                this.userCodecs.add(newCodec);
                this.registerLock.unlock();
            }
        }
        finally {
            this.registerLock.unlock();
        }
    }

    private boolean collides(TypeCodec<?> newCodec, TypeCodec<?> oldCodec) {
        return oldCodec.accepts(newCodec.getCqlType()) && oldCodec.accepts(newCodec.getJavaType());
    }

    protected abstract TypeCodec<?> getCachedCodec(@Nullable DataType var1, @Nullable GenericType<?> var2, boolean var3);

    @Override
    @NonNull
    public <JavaTypeT> TypeCodec<JavaTypeT> codecFor(@NonNull DataType cqlType, @NonNull GenericType<JavaTypeT> javaType) {
        return this.codecFor(cqlType, javaType, false);
    }

    @NonNull
    protected <JavaTypeT> TypeCodec<JavaTypeT> codecFor(@NonNull DataType cqlType, @NonNull GenericType<JavaTypeT> javaType, boolean isJavaCovariant) {
        LOG.trace("[{}] Looking up codec for {} <-> {}", new Object[]{this.logPrefix, cqlType, javaType});
        TypeCodec primitiveCodec = (TypeCodec)this.primitiveCodecsByCode.get(cqlType.getProtocolCode());
        if (primitiveCodec != null && this.matches(primitiveCodec, javaType, isJavaCovariant)) {
            LOG.trace("[{}] Found matching primitive codec {}", (Object)this.logPrefix, (Object)primitiveCodec);
            return CachingCodecRegistry.uncheckedCast(primitiveCodec);
        }
        for (TypeCodec<?> userCodec : this.userCodecs) {
            if (!userCodec.accepts(cqlType) || !this.matches(userCodec, javaType, isJavaCovariant)) continue;
            LOG.trace("[{}] Found matching user codec {}", (Object)this.logPrefix, userCodec);
            return CachingCodecRegistry.uncheckedCast(userCodec);
        }
        return CachingCodecRegistry.uncheckedCast(this.getCachedCodec(cqlType, javaType, isJavaCovariant));
    }

    @Override
    @NonNull
    public <JavaTypeT> TypeCodec<JavaTypeT> codecFor(@NonNull DataType cqlType, @NonNull Class<JavaTypeT> javaType) {
        LOG.trace("[{}] Looking up codec for {} <-> {}", new Object[]{this.logPrefix, cqlType, javaType});
        TypeCodec primitiveCodec = (TypeCodec)this.primitiveCodecsByCode.get(cqlType.getProtocolCode());
        if (primitiveCodec != null && primitiveCodec.accepts(javaType)) {
            LOG.trace("[{}] Found matching primitive codec {}", (Object)this.logPrefix, (Object)primitiveCodec);
            return CachingCodecRegistry.uncheckedCast(primitiveCodec);
        }
        for (TypeCodec<JavaTypeT> typeCodec : this.userCodecs) {
            if (!typeCodec.accepts(cqlType) || !typeCodec.accepts(javaType)) continue;
            LOG.trace("[{}] Found matching user codec {}", (Object)this.logPrefix, typeCodec);
            return CachingCodecRegistry.uncheckedCast(typeCodec);
        }
        return CachingCodecRegistry.uncheckedCast(this.getCachedCodec(cqlType, GenericType.of(javaType), false));
    }

    @Override
    @NonNull
    public <JavaTypeT> TypeCodec<JavaTypeT> codecFor(@NonNull DataType cqlType) {
        LOG.trace("[{}] Looking up codec for CQL type {}", (Object)this.logPrefix, (Object)cqlType);
        TypeCodec primitiveCodec = (TypeCodec)this.primitiveCodecsByCode.get(cqlType.getProtocolCode());
        if (primitiveCodec != null) {
            LOG.trace("[{}] Found matching primitive codec {}", (Object)this.logPrefix, (Object)primitiveCodec);
            return CachingCodecRegistry.uncheckedCast(primitiveCodec);
        }
        for (TypeCodec<?> userCodec : this.userCodecs) {
            if (!userCodec.accepts(cqlType)) continue;
            LOG.trace("[{}] Found matching user codec {}", (Object)this.logPrefix, userCodec);
            return CachingCodecRegistry.uncheckedCast(userCodec);
        }
        return CachingCodecRegistry.uncheckedCast(this.getCachedCodec(cqlType, null, false));
    }

    @Override
    @NonNull
    public <JavaTypeT> TypeCodec<JavaTypeT> codecFor(@NonNull DataType cqlType, @NonNull JavaTypeT value) {
        Preconditions.checkNotNull(cqlType);
        Preconditions.checkNotNull(value);
        LOG.trace("[{}] Looking up codec for CQL type {} and object {}", new Object[]{this.logPrefix, cqlType, value});
        TypeCodec primitiveCodec = (TypeCodec)this.primitiveCodecsByCode.get(cqlType.getProtocolCode());
        if (primitiveCodec != null && primitiveCodec.accepts(value)) {
            LOG.trace("[{}] Found matching primitive codec {}", (Object)this.logPrefix, (Object)primitiveCodec);
            return CachingCodecRegistry.uncheckedCast(primitiveCodec);
        }
        for (TypeCodec<?> userCodec : this.userCodecs) {
            if (!userCodec.accepts(cqlType) || !userCodec.accepts(value)) continue;
            LOG.trace("[{}] Found matching user codec {}", (Object)this.logPrefix, userCodec);
            return CachingCodecRegistry.uncheckedCast(userCodec);
        }
        GenericType<?> javaType = this.inspectType(value, cqlType);
        LOG.trace("[{}] Continuing based on inferred type {}", (Object)this.logPrefix, javaType);
        return CachingCodecRegistry.uncheckedCast(this.getCachedCodec(cqlType, javaType, true));
    }

    @Override
    @NonNull
    public <JavaTypeT> TypeCodec<JavaTypeT> codecFor(@NonNull JavaTypeT value) {
        Preconditions.checkNotNull(value);
        LOG.trace("[{}] Looking up codec for object {}", (Object)this.logPrefix, value);
        for (TypeCodec<?> primitiveCodec : this.primitiveCodecs) {
            if (!primitiveCodec.accepts(value)) continue;
            LOG.trace("[{}] Found matching primitive codec {}", (Object)this.logPrefix, primitiveCodec);
            return CachingCodecRegistry.uncheckedCast(primitiveCodec);
        }
        for (TypeCodec typeCodec : this.userCodecs) {
            if (!typeCodec.accepts(value)) continue;
            LOG.trace("[{}] Found matching user codec {}", (Object)this.logPrefix, (Object)typeCodec);
            return CachingCodecRegistry.uncheckedCast(typeCodec);
        }
        DataType cqlType = this.inferCqlTypeFromValue(value);
        GenericType<?> genericType = this.inspectType(value, cqlType);
        LOG.trace("[{}] Continuing based on inferred CQL type {} and Java type {}", new Object[]{this.logPrefix, cqlType, genericType});
        return CachingCodecRegistry.uncheckedCast(this.getCachedCodec(cqlType, genericType, true));
    }

    @Override
    @NonNull
    public <JavaTypeT> TypeCodec<JavaTypeT> codecFor(@NonNull GenericType<JavaTypeT> javaType) {
        return this.codecFor(javaType, false);
    }

    @NonNull
    protected <JavaTypeT> TypeCodec<JavaTypeT> codecFor(@NonNull GenericType<JavaTypeT> javaType, boolean isJavaCovariant) {
        LOG.trace("[{}] Looking up codec for Java type {} (covariant = {})", new Object[]{this.logPrefix, javaType, isJavaCovariant});
        for (TypeCodec<?> primitiveCodec : this.primitiveCodecs) {
            if (!this.matches(primitiveCodec, javaType, isJavaCovariant)) continue;
            LOG.trace("[{}] Found matching primitive codec {}", (Object)this.logPrefix, primitiveCodec);
            return CachingCodecRegistry.uncheckedCast(primitiveCodec);
        }
        for (TypeCodec typeCodec : this.userCodecs) {
            if (!this.matches(typeCodec, javaType, isJavaCovariant)) continue;
            LOG.trace("[{}] Found matching user codec {}", (Object)this.logPrefix, (Object)typeCodec);
            return CachingCodecRegistry.uncheckedCast(typeCodec);
        }
        return CachingCodecRegistry.uncheckedCast(this.getCachedCodec(null, javaType, isJavaCovariant));
    }

    protected boolean matches(@NonNull TypeCodec<?> codec, @NonNull GenericType<?> javaType, boolean isJavaCovariant) {
        return isJavaCovariant ? codec.getJavaType().isSupertypeOf(javaType) : codec.accepts(javaType);
    }

    @NonNull
    protected GenericType<?> inspectType(@NonNull Object value, @Nullable DataType cqlType) {
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                return cqlType == null ? JAVA_TYPE_FOR_EMPTY_LISTS : this.inferJavaTypeFromCqlType(cqlType);
            }
            Object firstElement = list.get(0);
            if (firstElement == null) {
                throw new IllegalArgumentException("Can't infer list codec because the first element is null (note that CQL does not allow null values in collections)");
            }
            GenericType<?> elementType = this.inspectType(firstElement, cqlType == null ? null : ((ListType)cqlType).getElementType());
            return GenericType.listOf(elementType);
        }
        if (value instanceof Set) {
            Set set = (Set)value;
            if (set.isEmpty()) {
                return cqlType == null ? JAVA_TYPE_FOR_EMPTY_SETS : this.inferJavaTypeFromCqlType(cqlType);
            }
            Object firstElement = set.iterator().next();
            if (firstElement == null) {
                throw new IllegalArgumentException("Can't infer set codec because the first element is null (note that CQL does not allow null values in collections)");
            }
            GenericType<?> elementType = this.inspectType(firstElement, cqlType == null ? null : ((SetType)cqlType).getElementType());
            return GenericType.setOf(elementType);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            if (map.isEmpty()) {
                return cqlType == null ? JAVA_TYPE_FOR_EMPTY_MAPS : this.inferJavaTypeFromCqlType(cqlType);
            }
            Map.Entry firstEntry = map.entrySet().iterator().next();
            Object firstKey = firstEntry.getKey();
            Object firstValue = firstEntry.getValue();
            if (firstKey == null || firstValue == null) {
                throw new IllegalArgumentException("Can't infer map codec because the first key and/or value is null (note that CQL does not allow null values in collections)");
            }
            GenericType<?> keyType = this.inspectType(firstKey, cqlType == null ? null : ((MapType)cqlType).getKeyType());
            GenericType<?> valueType = this.inspectType(firstValue, cqlType == null ? null : ((MapType)cqlType).getValueType());
            return GenericType.mapOf(keyType, valueType);
        }
        return GenericType.of(value.getClass());
    }

    @NonNull
    protected GenericType<?> inferJavaTypeFromCqlType(@NonNull DataType cqlType) {
        if (cqlType instanceof ListType) {
            DataType elementType = ((ListType)cqlType).getElementType();
            return GenericType.listOf(this.inferJavaTypeFromCqlType(elementType));
        }
        if (cqlType instanceof SetType) {
            DataType elementType = ((SetType)cqlType).getElementType();
            return GenericType.setOf(this.inferJavaTypeFromCqlType(elementType));
        }
        if (cqlType instanceof MapType) {
            DataType keyType = ((MapType)cqlType).getKeyType();
            DataType valueType = ((MapType)cqlType).getValueType();
            return GenericType.mapOf(this.inferJavaTypeFromCqlType(keyType), this.inferJavaTypeFromCqlType(valueType));
        }
        switch (cqlType.getProtocolCode()) {
            case 0: 
            case 3: {
                return GenericType.BYTE_BUFFER;
            }
            case 1: 
            case 13: {
                return GenericType.STRING;
            }
            case 2: 
            case 5: {
                return GenericType.LONG;
            }
            case 4: {
                return GenericType.BOOLEAN;
            }
            case 6: {
                return GenericType.BIG_DECIMAL;
            }
            case 7: {
                return GenericType.DOUBLE;
            }
            case 8: {
                return GenericType.FLOAT;
            }
            case 9: {
                return GenericType.INTEGER;
            }
            case 11: {
                return GenericType.INSTANT;
            }
            case 12: 
            case 15: {
                return GenericType.UUID;
            }
            case 14: {
                return GenericType.BIG_INTEGER;
            }
            case 16: {
                return GenericType.INET_ADDRESS;
            }
            case 17: {
                return GenericType.LOCAL_DATE;
            }
            case 18: {
                return GenericType.LOCAL_TIME;
            }
            case 19: {
                return GenericType.SHORT;
            }
            case 20: {
                return GenericType.BYTE;
            }
            case 21: {
                return GenericType.CQL_DURATION;
            }
            case 48: {
                return GenericType.UDT_VALUE;
            }
            case 49: {
                return GenericType.TUPLE_VALUE;
            }
        }
        throw new CodecNotFoundException(cqlType, null);
    }

    @Nullable
    protected DataType inferCqlTypeFromValue(@NonNull Object value) {
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                return CQL_TYPE_FOR_EMPTY_LISTS;
            }
            Object firstElement = list.get(0);
            if (firstElement == null) {
                throw new IllegalArgumentException("Can't infer list codec because the first element is null (note that CQL does not allow null values in collections)");
            }
            DataType elementType = this.inferCqlTypeFromValue(firstElement);
            if (elementType == null) {
                return null;
            }
            return DataTypes.listOf(elementType);
        }
        if (value instanceof Set) {
            Set set = (Set)value;
            if (set.isEmpty()) {
                return CQL_TYPE_FOR_EMPTY_SETS;
            }
            Object firstElement = set.iterator().next();
            if (firstElement == null) {
                throw new IllegalArgumentException("Can't infer set codec because the first element is null (note that CQL does not allow null values in collections)");
            }
            DataType elementType = this.inferCqlTypeFromValue(firstElement);
            if (elementType == null) {
                return null;
            }
            return DataTypes.setOf(elementType);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            if (map.isEmpty()) {
                return CQL_TYPE_FOR_EMPTY_MAPS;
            }
            Map.Entry firstEntry = map.entrySet().iterator().next();
            Object firstKey = firstEntry.getKey();
            Object firstValue = firstEntry.getValue();
            if (firstKey == null || firstValue == null) {
                throw new IllegalArgumentException("Can't infer map codec because the first key and/or value is null (note that CQL does not allow null values in collections)");
            }
            DataType keyType = this.inferCqlTypeFromValue(firstKey);
            DataType valueType = this.inferCqlTypeFromValue(firstValue);
            if (keyType == null || valueType == null) {
                return null;
            }
            return DataTypes.mapOf(keyType, valueType);
        }
        Class<?> javaClass = value.getClass();
        if (ByteBuffer.class.isAssignableFrom(javaClass)) {
            return DataTypes.BLOB;
        }
        if (String.class.equals(javaClass)) {
            return DataTypes.TEXT;
        }
        if (Long.class.equals(javaClass)) {
            return DataTypes.BIGINT;
        }
        if (Boolean.class.equals(javaClass)) {
            return DataTypes.BOOLEAN;
        }
        if (BigDecimal.class.equals(javaClass)) {
            return DataTypes.DECIMAL;
        }
        if (Double.class.equals(javaClass)) {
            return DataTypes.DOUBLE;
        }
        if (Float.class.equals(javaClass)) {
            return DataTypes.FLOAT;
        }
        if (Integer.class.equals(javaClass)) {
            return DataTypes.INT;
        }
        if (Instant.class.equals(javaClass)) {
            return DataTypes.TIMESTAMP;
        }
        if (UUID.class.equals(javaClass)) {
            return DataTypes.UUID;
        }
        if (BigInteger.class.equals(javaClass)) {
            return DataTypes.VARINT;
        }
        if (InetAddress.class.isAssignableFrom(javaClass)) {
            return DataTypes.INET;
        }
        if (LocalDate.class.equals(javaClass)) {
            return DataTypes.DATE;
        }
        if (LocalTime.class.equals(javaClass)) {
            return DataTypes.TIME;
        }
        if (Short.class.equals(javaClass)) {
            return DataTypes.SMALLINT;
        }
        if (Byte.class.equals(javaClass)) {
            return DataTypes.TINYINT;
        }
        if (CqlDuration.class.equals(javaClass)) {
            return DataTypes.DURATION;
        }
        if (UdtValue.class.isAssignableFrom(javaClass)) {
            return ((UdtValue)value).getType();
        }
        if (TupleValue.class.isAssignableFrom(javaClass)) {
            return ((TupleValue)value).getType();
        }
        return null;
    }

    @NonNull
    protected TypeCodec<?> createCodec(@Nullable DataType cqlType, @Nullable GenericType<?> javaType, boolean isJavaCovariant) {
        LOG.trace("[{}] Cache miss, creating codec", (Object)this.logPrefix);
        if (javaType == null) {
            assert (cqlType != null);
            return this.createCodec(cqlType);
        }
        if (cqlType == null) {
            return this.createCodec(javaType, isJavaCovariant);
        }
        TypeToken<?> token = javaType.__getToken();
        if (cqlType instanceof ListType && List.class.isAssignableFrom(token.getRawType())) {
            TypeCodec<DataType> elementCodec;
            DataType elementCqlType = ((ListType)cqlType).getElementType();
            if (token.getType() instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)token.getType()).getActualTypeArguments();
                GenericType<?> elementJavaType = GenericType.of(typeArguments[0]);
                elementCodec = CachingCodecRegistry.uncheckedCast(this.codecFor(elementCqlType, elementJavaType, isJavaCovariant));
            } else {
                elementCodec = this.codecFor((Object)elementCqlType);
            }
            return TypeCodecs.listOf(elementCodec);
        }
        if (cqlType instanceof SetType && Set.class.isAssignableFrom(token.getRawType())) {
            TypeCodec<DataType> elementCodec;
            DataType elementCqlType = ((SetType)cqlType).getElementType();
            if (token.getType() instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)token.getType()).getActualTypeArguments();
                GenericType<?> elementJavaType = GenericType.of(typeArguments[0]);
                elementCodec = CachingCodecRegistry.uncheckedCast(this.codecFor(elementCqlType, elementJavaType, isJavaCovariant));
            } else {
                elementCodec = this.codecFor((Object)elementCqlType);
            }
            return TypeCodecs.setOf(elementCodec);
        }
        if (cqlType instanceof MapType && Map.class.isAssignableFrom(token.getRawType())) {
            TypeCodec<DataType> valueCodec;
            TypeCodec<DataType> keyCodec;
            DataType keyCqlType = ((MapType)cqlType).getKeyType();
            DataType valueCqlType = ((MapType)cqlType).getValueType();
            if (token.getType() instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)token.getType()).getActualTypeArguments();
                GenericType<?> keyJavaType = GenericType.of(typeArguments[0]);
                GenericType<?> valueJavaType = GenericType.of(typeArguments[1]);
                keyCodec = CachingCodecRegistry.uncheckedCast(this.codecFor(keyCqlType, keyJavaType, isJavaCovariant));
                valueCodec = CachingCodecRegistry.uncheckedCast(this.codecFor(valueCqlType, valueJavaType, isJavaCovariant));
            } else {
                keyCodec = this.codecFor((Object)keyCqlType);
                valueCodec = this.codecFor((Object)valueCqlType);
            }
            return TypeCodecs.mapOf(keyCodec, valueCodec);
        }
        if (cqlType instanceof TupleType && TupleValue.class.isAssignableFrom(token.getRawType())) {
            return TypeCodecs.tupleOf((TupleType)cqlType);
        }
        if (cqlType instanceof UserDefinedType && UdtValue.class.isAssignableFrom(token.getRawType())) {
            return TypeCodecs.udtOf((UserDefinedType)cqlType);
        }
        if (cqlType instanceof CustomType && ByteBuffer.class.isAssignableFrom(token.getRawType())) {
            return TypeCodecs.custom(cqlType);
        }
        throw new CodecNotFoundException(cqlType, javaType);
    }

    @NonNull
    protected TypeCodec<?> createCodec(@NonNull GenericType<?> javaType, boolean isJavaCovariant) {
        TypeToken<?> token = javaType.__getToken();
        if (List.class.isAssignableFrom(token.getRawType()) && token.getType() instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)token.getType()).getActualTypeArguments();
            GenericType<?> elementType = GenericType.of(typeArguments[0]);
            TypeCodec<?> elementCodec = this.codecFor(elementType, isJavaCovariant);
            return TypeCodecs.listOf(elementCodec);
        }
        if (Set.class.isAssignableFrom(token.getRawType()) && token.getType() instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)token.getType()).getActualTypeArguments();
            GenericType<?> elementType = GenericType.of(typeArguments[0]);
            TypeCodec<?> elementCodec = this.codecFor(elementType, isJavaCovariant);
            return TypeCodecs.setOf(elementCodec);
        }
        if (Map.class.isAssignableFrom(token.getRawType()) && token.getType() instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)token.getType()).getActualTypeArguments();
            GenericType<?> keyType = GenericType.of(typeArguments[0]);
            GenericType<?> valueType = GenericType.of(typeArguments[1]);
            TypeCodec<?> keyCodec = this.codecFor(keyType, isJavaCovariant);
            TypeCodec<?> valueCodec = this.codecFor(valueType, isJavaCovariant);
            return TypeCodecs.mapOf(keyCodec, valueCodec);
        }
        throw new CodecNotFoundException(null, javaType);
    }

    @NonNull
    protected TypeCodec<?> createCodec(@NonNull DataType cqlType) {
        if (cqlType instanceof ListType) {
            DataType elementType = ((ListType)cqlType).getElementType();
            TypeCodec<DataType> elementCodec = this.codecFor((Object)elementType);
            return TypeCodecs.listOf(elementCodec);
        }
        if (cqlType instanceof SetType) {
            DataType elementType = ((SetType)cqlType).getElementType();
            TypeCodec<DataType> elementCodec = this.codecFor((Object)elementType);
            return TypeCodecs.setOf(elementCodec);
        }
        if (cqlType instanceof MapType) {
            DataType keyType = ((MapType)cqlType).getKeyType();
            DataType valueType = ((MapType)cqlType).getValueType();
            TypeCodec<DataType> keyCodec = this.codecFor((Object)keyType);
            TypeCodec<DataType> valueCodec = this.codecFor((Object)valueType);
            return TypeCodecs.mapOf(keyCodec, valueCodec);
        }
        if (cqlType instanceof TupleType) {
            return TypeCodecs.tupleOf((TupleType)cqlType);
        }
        if (cqlType instanceof UserDefinedType) {
            return TypeCodecs.udtOf((UserDefinedType)cqlType);
        }
        if (cqlType instanceof CustomType) {
            return TypeCodecs.custom(cqlType);
        }
        throw new CodecNotFoundException(cqlType, null);
    }

    private static IntMap<TypeCodec<?>> sortByProtocolCode(TypeCodec<?>[] codecs) {
        IntMap.Builder builder = IntMap.builder();
        for (TypeCodec<?> codec : codecs) {
            builder.put(codec.getCqlType().getProtocolCode(), codec);
        }
        return builder.build();
    }

    private static <DeclaredT, RuntimeT> TypeCodec<DeclaredT> uncheckedCast(TypeCodec<RuntimeT> codec) {
        TypeCodec<RuntimeT> result = codec;
        return result;
    }
}

