/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.AuthenticatedUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AuthenticatedUser", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableAuthenticatedUser
implements AuthenticatedUser {
    private final String name;
    @Nullable
    private final String token;
    private final boolean isFromExternalAuth;
    private final Map<String, String> customProperties;

    private ImmutableAuthenticatedUser(String name, @Nullable String token, boolean isFromExternalAuth, Map<String, String> customProperties) {
        this.name = name;
        this.token = token;
        this.isFromExternalAuth = isFromExternalAuth;
        this.customProperties = customProperties;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public String token() {
        return this.token;
    }

    @Override
    public boolean isFromExternalAuth() {
        return this.isFromExternalAuth;
    }

    @Override
    public Map<String, String> customProperties() {
        return this.customProperties;
    }

    public final ImmutableAuthenticatedUser withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthenticatedUser(newValue, this.token, this.isFromExternalAuth, this.customProperties);
    }

    public final ImmutableAuthenticatedUser withToken(@Nullable String value) {
        if (Objects.equals(this.token, value)) {
            return this;
        }
        return new ImmutableAuthenticatedUser(this.name, value, this.isFromExternalAuth, this.customProperties);
    }

    public final ImmutableAuthenticatedUser withIsFromExternalAuth(boolean value) {
        if (this.isFromExternalAuth == value) {
            return this;
        }
        return new ImmutableAuthenticatedUser(this.name, this.token, value, this.customProperties);
    }

    public final ImmutableAuthenticatedUser withCustomProperties(Map<String, ? extends String> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableAuthenticatedUser.createUnmodifiableMap(true, false, entries);
        return new ImmutableAuthenticatedUser(this.name, this.token, this.isFromExternalAuth, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthenticatedUser && this.equalTo((ImmutableAuthenticatedUser)another);
    }

    private boolean equalTo(ImmutableAuthenticatedUser another) {
        return this.name.equals(another.name) && Objects.equals(this.token, another.token) && this.isFromExternalAuth == another.isFromExternalAuth && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.token);
        h += (h << 5) + Boolean.hashCode(this.isFromExternalAuth);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return "AuthenticatedUser{name=" + this.name + ", token=" + this.token + ", isFromExternalAuth=" + this.isFromExternalAuth + ", customProperties=" + this.customProperties + "}";
    }

    public static ImmutableAuthenticatedUser copyOf(AuthenticatedUser instance) {
        if (instance instanceof ImmutableAuthenticatedUser) {
            return (ImmutableAuthenticatedUser)instance;
        }
        return ImmutableAuthenticatedUser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="AuthenticatedUser", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_IS_FROM_EXTERNAL_AUTH = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private String token;
        private boolean isFromExternalAuth;
        private Map<String, String> customProperties = new LinkedHashMap<String, String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AuthenticatedUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            String tokenValue = instance.token();
            if (tokenValue != null) {
                this.token(tokenValue);
            }
            this.isFromExternalAuth(instance.isFromExternalAuth());
            this.putAllCustomProperties(instance.customProperties());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder token(@Nullable String token) {
            this.token = token;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isFromExternalAuth(boolean isFromExternalAuth) {
            this.isFromExternalAuth = isFromExternalAuth;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperties(String key, String value) {
            this.customProperties.put(Objects.requireNonNull(key, "customProperties key"), Objects.requireNonNull(value, "customProperties value"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperties(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.customProperties.put(Objects.requireNonNull(k, "customProperties key"), Objects.requireNonNull(v, "customProperties value"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends String> entries) {
            this.customProperties.clear();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.customProperties.put(Objects.requireNonNull(k, "customProperties key"), Objects.requireNonNull(v, "customProperties value"));
            }
            return this;
        }

        public ImmutableAuthenticatedUser build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAuthenticatedUser(this.name, this.token, this.isFromExternalAuth, ImmutableAuthenticatedUser.createUnmodifiableMap(false, false, this.customProperties));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("isFromExternalAuth");
            }
            return "Cannot build AuthenticatedUser, some of required attributes are not set " + attributes;
        }
    }
}

