/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.PagingPosition;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.TableName;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PagingPosition", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutablePagingPosition
implements PagingPosition {
    private final Map<Column, ByteBuffer> currentRow;
    private final PagingPosition.ResumeMode resumeFrom;
    private final int remainingRows;
    private final int remainingRowsInPartition;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long CURRENT_ROW_VALUES_BY_COLUMN_NAME_LAZY_INIT_BIT = 1L;
    private transient Map<String, ByteBuffer> currentRowValuesByColumnName;
    private static final long TABLE_NAME_LAZY_INIT_BIT = 2L;
    private transient TableName tableName;

    private ImmutablePagingPosition(Builder builder) {
        this.currentRow = ImmutablePagingPosition.createUnmodifiableMap(false, false, builder.currentRow);
        this.resumeFrom = builder.resumeFrom;
        if (builder.remainingRowsIsSet()) {
            this.initShim.remainingRows(builder.remainingRows);
        }
        if (builder.remainingRowsInPartitionIsSet()) {
            this.initShim.remainingRowsInPartition(builder.remainingRowsInPartition);
        }
        this.remainingRows = this.initShim.remainingRows();
        this.remainingRowsInPartition = this.initShim.remainingRowsInPartition();
        this.initShim = null;
    }

    private ImmutablePagingPosition(Map<Column, ByteBuffer> currentRow, PagingPosition.ResumeMode resumeFrom, int remainingRows, int remainingRowsInPartition) {
        this.currentRow = currentRow;
        this.resumeFrom = resumeFrom;
        this.remainingRows = remainingRows;
        this.remainingRowsInPartition = remainingRowsInPartition;
        this.initShim = null;
    }

    private int remainingRowsInitialize() {
        return PagingPosition.super.remainingRows();
    }

    private int remainingRowsInPartitionInitialize() {
        return PagingPosition.super.remainingRowsInPartition();
    }

    @Override
    public Map<Column, ByteBuffer> currentRow() {
        return this.currentRow;
    }

    @Override
    public PagingPosition.ResumeMode resumeFrom() {
        return this.resumeFrom;
    }

    @Override
    public int remainingRows() {
        InitShim shim = this.initShim;
        return shim != null ? shim.remainingRows() : this.remainingRows;
    }

    @Override
    public int remainingRowsInPartition() {
        InitShim shim = this.initShim;
        return shim != null ? shim.remainingRowsInPartition() : this.remainingRowsInPartition;
    }

    public final ImmutablePagingPosition withCurrentRow(Map<? extends Column, ? extends ByteBuffer> entries) {
        if (this.currentRow == entries) {
            return this;
        }
        Map<Column, ByteBuffer> newValue = ImmutablePagingPosition.createUnmodifiableMap(true, false, entries);
        return new ImmutablePagingPosition(newValue, this.resumeFrom, this.remainingRows, this.remainingRowsInPartition);
    }

    public final ImmutablePagingPosition withResumeFrom(PagingPosition.ResumeMode value) {
        if (this.resumeFrom == value) {
            return this;
        }
        PagingPosition.ResumeMode newValue = Objects.requireNonNull(value, "resumeFrom");
        if (this.resumeFrom.equals((Object)newValue)) {
            return this;
        }
        return new ImmutablePagingPosition(this.currentRow, newValue, this.remainingRows, this.remainingRowsInPartition);
    }

    public final ImmutablePagingPosition withRemainingRows(int value) {
        if (this.remainingRows == value) {
            return this;
        }
        return new ImmutablePagingPosition(this.currentRow, this.resumeFrom, value, this.remainingRowsInPartition);
    }

    public final ImmutablePagingPosition withRemainingRowsInPartition(int value) {
        if (this.remainingRowsInPartition == value) {
            return this;
        }
        return new ImmutablePagingPosition(this.currentRow, this.resumeFrom, this.remainingRows, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePagingPosition && this.equalTo((ImmutablePagingPosition)another);
    }

    private boolean equalTo(ImmutablePagingPosition another) {
        return this.currentRow.equals(another.currentRow) && this.resumeFrom.equals((Object)another.resumeFrom) && this.remainingRows == another.remainingRows && this.remainingRowsInPartition == another.remainingRowsInPartition;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.currentRow.hashCode();
        h += (h << 5) + this.resumeFrom.hashCode();
        h += (h << 5) + this.remainingRows;
        h += (h << 5) + this.remainingRowsInPartition;
        return h;
    }

    public String toString() {
        return "PagingPosition{currentRow=" + this.currentRow + ", resumeFrom=" + (Object)((Object)this.resumeFrom) + ", remainingRows=" + this.remainingRows + ", remainingRowsInPartition=" + this.remainingRowsInPartition + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ByteBuffer> currentRowValuesByColumnName() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutablePagingPosition immutablePagingPosition = this;
            synchronized (immutablePagingPosition) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.currentRowValuesByColumnName = Objects.requireNonNull(PagingPosition.super.currentRowValuesByColumnName(), "currentRowValuesByColumnName");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.currentRowValuesByColumnName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableName tableName() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutablePagingPosition immutablePagingPosition = this;
            synchronized (immutablePagingPosition) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.tableName = Objects.requireNonNull(PagingPosition.super.tableName(), "tableName");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.tableName;
    }

    public static ImmutablePagingPosition copyOf(PagingPosition instance) {
        if (instance instanceof ImmutablePagingPosition) {
            return (ImmutablePagingPosition)instance;
        }
        return ImmutablePagingPosition.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="PagingPosition", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RESUME_FROM = 1L;
        private static final long OPT_BIT_REMAINING_ROWS = 1L;
        private static final long OPT_BIT_REMAINING_ROWS_IN_PARTITION = 2L;
        private long initBits = 1L;
        private long optBits;
        private Map<Column, ByteBuffer> currentRow = new LinkedHashMap<Column, ByteBuffer>();
        @Nullable
        private PagingPosition.ResumeMode resumeFrom;
        private int remainingRows;
        private int remainingRowsInPartition;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PagingPosition instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllCurrentRow(instance.currentRow());
            this.resumeFrom(instance.resumeFrom());
            this.remainingRows(instance.remainingRows());
            this.remainingRowsInPartition(instance.remainingRowsInPartition());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCurrentRow(Column key, ByteBuffer value) {
            this.currentRow.put(Objects.requireNonNull(key, "currentRow key"), Objects.requireNonNull(value, "currentRow value"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCurrentRow(Map.Entry<? extends Column, ? extends ByteBuffer> entry) {
            Column k = entry.getKey();
            ByteBuffer v = entry.getValue();
            this.currentRow.put(Objects.requireNonNull(k, "currentRow key"), Objects.requireNonNull(v, "currentRow value"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder currentRow(Map<? extends Column, ? extends ByteBuffer> entries) {
            this.currentRow.clear();
            return this.putAllCurrentRow(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCurrentRow(Map<? extends Column, ? extends ByteBuffer> entries) {
            for (Map.Entry<? extends Column, ? extends ByteBuffer> e : entries.entrySet()) {
                Column k = e.getKey();
                ByteBuffer v = e.getValue();
                this.currentRow.put(Objects.requireNonNull(k, "currentRow key"), Objects.requireNonNull(v, "currentRow value"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder resumeFrom(PagingPosition.ResumeMode resumeFrom) {
            this.resumeFrom = Objects.requireNonNull(resumeFrom, "resumeFrom");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder remainingRows(int remainingRows) {
            this.remainingRows = remainingRows;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder remainingRowsInPartition(int remainingRowsInPartition) {
            this.remainingRowsInPartition = remainingRowsInPartition;
            this.optBits |= 2L;
            return this;
        }

        public ImmutablePagingPosition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePagingPosition(this);
        }

        private boolean remainingRowsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean remainingRowsInPartitionIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resumeFrom");
            }
            return "Cannot build PagingPosition, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="PagingPosition", generator="Immutables")
    private final class InitShim {
        private byte remainingRowsBuildStage = 0;
        private int remainingRows;
        private byte remainingRowsInPartitionBuildStage = 0;
        private int remainingRowsInPartition;

        private InitShim() {
        }

        int remainingRows() {
            if (this.remainingRowsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.remainingRowsBuildStage == 0) {
                this.remainingRowsBuildStage = (byte)-1;
                this.remainingRows = ImmutablePagingPosition.this.remainingRowsInitialize();
                this.remainingRowsBuildStage = 1;
            }
            return this.remainingRows;
        }

        void remainingRows(int remainingRows) {
            this.remainingRows = remainingRows;
            this.remainingRowsBuildStage = 1;
        }

        int remainingRowsInPartition() {
            if (this.remainingRowsInPartitionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.remainingRowsInPartitionBuildStage == 0) {
                this.remainingRowsInPartitionBuildStage = (byte)-1;
                this.remainingRowsInPartition = ImmutablePagingPosition.this.remainingRowsInPartitionInitialize();
                this.remainingRowsInPartitionBuildStage = 1;
            }
            return this.remainingRowsInPartition;
        }

        void remainingRowsInPartition(int remainingRowsInPartition) {
            this.remainingRowsInPartition = remainingRowsInPartition;
            this.remainingRowsInPartitionBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.remainingRowsBuildStage == -1) {
                attributes.add("remainingRows");
            }
            if (this.remainingRowsInPartitionBuildStage == -1) {
                attributes.add("remainingRowsInPartition");
            }
            return "Cannot build PagingPosition, attribute initializers form cycle " + attributes;
        }
    }
}

