/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db;

import io.stargate.db.AuthenticatedUser;
import io.stargate.db.Authenticator;
import io.stargate.db.Batch;
import io.stargate.db.ClientInfo;
import io.stargate.db.EventListener;
import io.stargate.db.PagingPosition;
import io.stargate.db.Parameters;
import io.stargate.db.Result;
import io.stargate.db.RowDecorator;
import io.stargate.db.SchemaAgreementChecker;
import io.stargate.db.Statement;
import io.stargate.db.schema.Schema;
import io.stargate.db.schema.TableName;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.cassandra.stargate.exceptions.AuthenticationException;

public interface Persistence
extends SchemaAgreementChecker {
    public static final boolean SUPPORTS_SECONDARY_INDEX = Boolean.parseBoolean(System.getProperty("stargate.persistence.2i.support.default", "true"));

    public String name();

    public Schema schema();

    public void registerEventListener(EventListener var1);

    public Authenticator getAuthenticator();

    public void setRpcReady(boolean var1);

    public Connection newConnection(ClientInfo var1);

    public Connection newConnection();

    public ByteBuffer unsetValue();

    public boolean isInSchemaAgreementWithStorage();

    default public boolean supportsSecondaryIndex() {
        return SUPPORTS_SECONDARY_INDEX;
    }

    public boolean supportsSAI();

    default public boolean supportsLoggedBatches() {
        return true;
    }

    public boolean isSchemaAgreementAchievable();

    public Map<String, List<String>> cqlSupportedOptions();

    public void executeAuthResponse(Runnable var1);

    default public String decorateKeyspaceName(String keyspaceName, Map<String, String> connectionProperties) {
        return keyspaceName;
    }

    public static interface Connection
    extends SchemaAgreementChecker {
        public Persistence persistence();

        public void login(AuthenticatedUser var1) throws AuthenticationException;

        public Optional<AuthenticatedUser> loggedUser();

        public Optional<ClientInfo> clientInfo();

        public Optional<String> usedKeyspace();

        default public Result.Prepared getPrepared(String query, Parameters parameters) {
            return null;
        }

        public CompletableFuture<Result.Prepared> prepare(String var1, Parameters var2);

        public CompletableFuture<Result> execute(Statement var1, Parameters var2, long var3);

        public CompletableFuture<Result> batch(Batch var1, Parameters var2, long var3);

        default public void setCustomProperties(Map<String, String> customProperties) {
        }

        public ByteBuffer makePagingState(PagingPosition var1, Parameters var2);

        public RowDecorator makeRowDecorator(TableName var1);

        @Override
        default public boolean isInSchemaAgreement() {
            return this.persistence().isInSchemaAgreement();
        }
    }
}

