/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db;

import com.datastax.oss.driver.shaded.guava.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.TimeUnit;

public interface SchemaAgreementChecker {
    public static final int SCHEMA_AGREEMENT_WAIT_RETRIES = Integer.getInteger("stargate.persistence.schema.agreement.wait.retries", 900);

    public boolean isInSchemaAgreement();

    default public void waitForSchemaAgreement() {
        for (int count = 0; count < SCHEMA_AGREEMENT_WAIT_RETRIES; ++count) {
            if (this.isInSchemaAgreement()) {
                return;
            }
            Uninterruptibles.sleepUninterruptibly(200L, TimeUnit.MILLISECONDS);
        }
        throw new IllegalStateException("Failed to reach schema agreement after " + 200 * SCHEMA_AGREEMENT_WAIT_RETRIES + " milliseconds.");
    }
}

