/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.datastore;

import io.stargate.db.PagingPosition;
import io.stargate.db.RowDecorator;
import io.stargate.db.datastore.Row;
import io.stargate.db.schema.Column;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public interface ResultSet
extends Iterable<Row> {
    public static final ResultSet EMPTY_NO_SCHEMA_AGREEMENT = new Empty(false);
    public static final ResultSet EMPTY_WITH_SCHEMA_AGREEMENT = new Empty(true);

    public ResultSet withRowInspector(Predicate<Row> var1);

    public static ResultSet empty(boolean waitedForSchemaAgreement) {
        return waitedForSchemaAgreement ? EMPTY_WITH_SCHEMA_AGREEMENT : EMPTY_NO_SCHEMA_AGREEMENT;
    }

    public static ResultSet empty() {
        return EMPTY_NO_SCHEMA_AGREEMENT;
    }

    public List<Column> columns();

    @Override
    public Iterator<Row> iterator();

    public Row one();

    public List<Row> rows();

    public List<Row> currentPageRows();

    public boolean hasNoMoreFetchedRows();

    public ByteBuffer getPagingState();

    public ByteBuffer makePagingState(PagingPosition var1);

    public RowDecorator makeRowDecorator();

    default public boolean waitedForSchemaAgreement() {
        return false;
    }

    public static class Empty
    implements ResultSet {
        private final boolean waitedForSchemaAgreement;

        private Empty(boolean waitedForSchemaAgreement) {
            this.waitedForSchemaAgreement = waitedForSchemaAgreement;
        }

        @Override
        public ResultSet withRowInspector(Predicate<Row> authzFilter) {
            return this;
        }

        @Override
        public List<Column> columns() {
            return Collections.emptyList();
        }

        @Override
        public Iterator<Row> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public Row one() {
            throw new NoSuchElementException();
        }

        @Override
        public List<Row> rows() {
            return Collections.emptyList();
        }

        @Override
        public List<Row> currentPageRows() {
            return Collections.emptyList();
        }

        @Override
        public boolean hasNoMoreFetchedRows() {
            return true;
        }

        @Override
        public ByteBuffer getPagingState() {
            return null;
        }

        @Override
        public ByteBuffer makePagingState(PagingPosition position) {
            return null;
        }

        @Override
        public RowDecorator makeRowDecorator() {
            throw new UnsupportedOperationException("Obtaining partition key comparators from an empty result set is not supported");
        }

        @Override
        public boolean waitedForSchemaAgreement() {
            return this.waitedForSchemaAgreement;
        }
    }
}

