/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.limiter;

import io.stargate.db.limiter.AsyncRateLimiter;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.cassandra.stargate.exceptions.UnauthorizedException;

public abstract class RateLimitingDecision {
    private RateLimitingDecision() {
    }

    public static Unlimited unlimited() {
        return Unlimited.INSTANCE;
    }

    public static Limited limit(AsyncRateLimiter limiter, long permitsToAcquire) {
        return new Limited(limiter, permitsToAcquire);
    }

    public static Rejected reject(String rejectionMessage) {
        return new Rejected(rejectionMessage);
    }

    public abstract <T> CompletableFuture<T> apply(Supplier<CompletableFuture<T>> var1);

    public static class Rejected
    extends RateLimitingDecision {
        private final String rejectionMessage;

        private Rejected(String rejectionMessage) {
            this.rejectionMessage = rejectionMessage;
        }

        @Override
        public <T> CompletableFuture<T> apply(Supplier<CompletableFuture<T>> task) {
            CompletableFuture exceptionalFuture = new CompletableFuture();
            exceptionalFuture.completeExceptionally(new UnauthorizedException(this.rejectionMessage));
            return exceptionalFuture;
        }
    }

    public static class Limited
    extends RateLimitingDecision {
        private final AsyncRateLimiter limiter;
        private final long permitsToAcquire;

        private Limited(AsyncRateLimiter limiter, long permitsToAcquire) {
            this.limiter = limiter;
            this.permitsToAcquire = permitsToAcquire;
        }

        @Override
        public <T> CompletableFuture<T> apply(Supplier<CompletableFuture<T>> task) {
            return this.limiter.acquireAndExecute(this.permitsToAcquire, task);
        }
    }

    public static class Unlimited
    extends RateLimitingDecision {
        private static final Unlimited INSTANCE = new Unlimited();

        @Override
        public <T> CompletableFuture<T> apply(Supplier<CompletableFuture<T>> task) {
            return task.get();
        }
    }
}

