/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query;

import io.stargate.db.BatchType;
import io.stargate.db.Parameters;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.query.BoundQuery;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import org.apache.cassandra.stargate.db.ConsistencyLevel;

public interface AsyncQueryExecutor {
    default public CompletableFuture<ResultSet> execute(BoundQuery query) {
        return this.execute(query, p -> p);
    }

    default public CompletableFuture<ResultSet> execute(BoundQuery query, ConsistencyLevel consistencyLevel) {
        return this.execute(query, p -> p.withConsistencyLevel(consistencyLevel));
    }

    public CompletableFuture<ResultSet> execute(BoundQuery var1, UnaryOperator<Parameters> var2);

    default public CompletableFuture<ResultSet> batch(Collection<BoundQuery> queries) {
        return this.batch(queries, p -> p);
    }

    default public CompletableFuture<ResultSet> unloggedBatch(Collection<BoundQuery> queries) {
        return this.batch(queries, BatchType.UNLOGGED, p -> p);
    }

    default public CompletableFuture<ResultSet> batch(Collection<BoundQuery> queries, ConsistencyLevel consistencyLevel) {
        return this.batch(queries, p -> p.withConsistencyLevel(consistencyLevel));
    }

    default public CompletableFuture<ResultSet> unloggedBatch(Collection<BoundQuery> queries, ConsistencyLevel consistencyLevel) {
        return this.batch(queries, BatchType.UNLOGGED, p -> p.withConsistencyLevel(consistencyLevel));
    }

    default public CompletableFuture<ResultSet> batch(Collection<BoundQuery> queries, UnaryOperator<Parameters> parametersModifier) {
        return this.batch(queries, BatchType.LOGGED, parametersModifier);
    }

    public CompletableFuture<ResultSet> batch(Collection<BoundQuery> var1, BatchType var2, UnaryOperator<Parameters> var3);
}

