/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query;

import io.stargate.db.query.Query;
import io.stargate.db.query.QueryType;
import io.stargate.db.query.TypedValue;
import java.util.List;
import java.util.Objects;

public interface BoundQuery {
    public QueryType type();

    public Source<?> source();

    default public String queryString() {
        return this.source().query().queryStringForPreparation();
    }

    public List<TypedValue> values();

    public static final class Source<Q extends Query<?>> {
        private final Q sourceQuery;
        private final List<TypedValue> sourceValues;

        public Source(Q boundedQuery, List<TypedValue> sourceValues) {
            this.sourceQuery = boundedQuery;
            this.sourceValues = sourceValues;
        }

        public Q query() {
            return this.sourceQuery;
        }

        public List<TypedValue> values() {
            return this.sourceValues;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Source)) {
                return false;
            }
            Source source = (Source)o;
            return this.sourceQuery.equals(source.sourceQuery) && this.sourceValues.equals(source.sourceValues);
        }

        public int hashCode() {
            return Objects.hash(this.sourceQuery, this.sourceValues);
        }

        public String toString() {
            return String.format("%s with values=%s", this.sourceQuery, this.sourceValues);
        }
    }
}

