/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import io.stargate.db.query.Predicate;
import io.stargate.db.query.TypedValue;
import io.stargate.db.schema.Column;
import java.util.List;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Value.Immutable
public interface Condition {
    public LHS lhs();

    public Predicate predicate();

    @Nullable
    public TypedValue value();

    public static abstract class LHS {
        private final Kind kind;

        private LHS(Kind kind) {
            this.kind = kind;
        }

        public Kind kind() {
            return this.kind;
        }

        public abstract Column.ColumnType valueType();

        public boolean isUnset() {
            return false;
        }

        public static LHS column(Column column) {
            return new SimpleColumn(column);
        }

        public static LHS mapAccess(Column column, TypedValue key) {
            return new MapAccess(column, key);
        }

        public static LHS columnTuple(List<Column> columns) {
            throw new UnsupportedOperationException();
        }

        public static LHS token(List<Column> columns) {
            throw new UnsupportedOperationException();
        }

        private static class MapAccess
        extends LHS {
            private final Column column;
            private final TypedValue keyValue;

            private MapAccess(Column column, TypedValue keyValue) {
                super(Kind.MAP_ACCESS);
                Preconditions.checkArgument(column.type().isMap());
                Preconditions.checkArgument(column.type().parameters().get(0).equals(keyValue.type()));
                this.column = column;
                this.keyValue = keyValue;
            }

            public Column column() {
                return this.column;
            }

            @Override
            public Column.ColumnType valueType() {
                return this.column.type().parameters().get(1);
            }

            @Override
            public boolean isUnset() {
                return this.keyValue.isUnset();
            }

            public String toString() {
                return String.format("%s[%s]", this.column.cqlName(), this.keyValue);
            }
        }

        public static class SimpleColumn
        extends LHS {
            private final Column column;

            private SimpleColumn(Column column) {
                super(Kind.COLUMN);
                this.column = column;
            }

            public Column column() {
                return this.column;
            }

            public String toString() {
                return this.column.cqlName();
            }

            @Override
            public Column.ColumnType valueType() {
                return this.column.type();
            }
        }

        static enum Kind {
            COLUMN,
            MAP_ACCESS,
            TUPLE,
            TOKEN;

        }
    }
}

