/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.query.Condition;
import io.stargate.db.query.Predicate;
import io.stargate.db.query.TypedValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Condition", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableCondition
implements Condition {
    private final Condition.LHS lhs;
    private final Predicate predicate;
    @Nullable
    private final TypedValue value;

    private ImmutableCondition(Condition.LHS lhs, Predicate predicate, @Nullable TypedValue value) {
        this.lhs = lhs;
        this.predicate = predicate;
        this.value = value;
    }

    @Override
    public Condition.LHS lhs() {
        return this.lhs;
    }

    @Override
    public Predicate predicate() {
        return this.predicate;
    }

    @Override
    @Nullable
    public TypedValue value() {
        return this.value;
    }

    public final ImmutableCondition withLhs(Condition.LHS value) {
        if (this.lhs == value) {
            return this;
        }
        Condition.LHS newValue = Objects.requireNonNull(value, "lhs");
        return new ImmutableCondition(newValue, this.predicate, this.value);
    }

    public final ImmutableCondition withPredicate(Predicate value) {
        if (this.predicate == value) {
            return this;
        }
        Predicate newValue = Objects.requireNonNull(value, "predicate");
        if (this.predicate.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableCondition(this.lhs, newValue, this.value);
    }

    public final ImmutableCondition withValue(@Nullable TypedValue value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableCondition(this.lhs, this.predicate, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCondition && this.equalTo((ImmutableCondition)another);
    }

    private boolean equalTo(ImmutableCondition another) {
        return this.lhs.equals(another.lhs) && this.predicate.equals((Object)another.predicate) && Objects.equals(this.value, another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.lhs.hashCode();
        h += (h << 5) + this.predicate.hashCode();
        h += (h << 5) + Objects.hashCode(this.value);
        return h;
    }

    public String toString() {
        return "Condition{lhs=" + this.lhs + ", predicate=" + (Object)((Object)this.predicate) + ", value=" + this.value + "}";
    }

    public static ImmutableCondition copyOf(Condition instance) {
        if (instance instanceof ImmutableCondition) {
            return (ImmutableCondition)instance;
        }
        return ImmutableCondition.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Condition", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LHS = 1L;
        private static final long INIT_BIT_PREDICATE = 2L;
        private long initBits = 3L;
        @Nullable
        private Condition.LHS lhs;
        @Nullable
        private Predicate predicate;
        @Nullable
        private TypedValue value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Condition instance) {
            Objects.requireNonNull(instance, "instance");
            this.lhs(instance.lhs());
            this.predicate(instance.predicate());
            TypedValue valueValue = instance.value();
            if (valueValue != null) {
                this.value(valueValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lhs(Condition.LHS lhs) {
            this.lhs = Objects.requireNonNull(lhs, "lhs");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder predicate(Predicate predicate) {
            this.predicate = Objects.requireNonNull(predicate, "predicate");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(@Nullable TypedValue value) {
            this.value = value;
            return this;
        }

        public ImmutableCondition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCondition(this.lhs, this.predicate, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("lhs");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("predicate");
            }
            return "Cannot build Condition, some of required attributes are not set " + attributes;
        }
    }
}

