/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query;

import io.stargate.db.query.TypedValue;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.UserDefinedType;
import java.util.Objects;

public abstract class ModifiableEntity {
    private final Kind kind;
    protected final io.stargate.db.schema.Column column;

    private ModifiableEntity(Kind kind, io.stargate.db.schema.Column column) {
        this.kind = kind;
        this.column = column;
    }

    public Kind kind() {
        return this.kind;
    }

    public abstract Column.ColumnType type();

    public static Column of(io.stargate.db.schema.Column column) {
        return new Column(column);
    }

    public static UdtField udtType(io.stargate.db.schema.Column udtColumn, String fieldName) {
        return new UdtField(udtColumn, fieldName);
    }

    public static MapValue mapValue(io.stargate.db.schema.Column mapColumn, TypedValue key) {
        return new MapValue(mapColumn, key);
    }

    public static class MapValue
    extends ModifiableEntity {
        private final TypedValue key;
        private final Column.ColumnType valueType;

        private MapValue(io.stargate.db.schema.Column column, TypedValue key) {
            super(Kind.MAP_VALUE, column);
            this.key = key;
            Column.ColumnType type = column.type();
            if (type == null) {
                throw new IllegalArgumentException("Provided column does not have its type set");
            }
            if (!type.isMap()) {
                throw new IllegalArgumentException(String.format("Cannot access elements of column %s of type %s, it is not a map", column.cqlName(), type));
            }
            Column.ColumnType keyType = type.parameters().get(0);
            if (keyType.id() != key.type().id()) {
                throw new IllegalArgumentException(String.format("Cannot access value of map %s: expecting keys of type %s, but given a key of type %s", column.cqlName(), keyType, key.type()));
            }
            this.valueType = type.parameters().get(1);
        }

        @Override
        public Column.ColumnType type() {
            return this.valueType;
        }

        public TypedValue key() {
            return this.key;
        }

        public io.stargate.db.schema.Column parent() {
            return this.column;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind(), this.column, this.key});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MapValue)) {
                return false;
            }
            MapValue that = (MapValue)obj;
            return this.column.equals(that.column) && this.key.equals(that.key);
        }

        public String toString() {
            return String.format("%s[%s]", this.column.cqlName(), this.key);
        }
    }

    public static class UdtField
    extends ModifiableEntity {
        private final String fieldName;
        private final Column.ColumnType fieldType;

        private UdtField(io.stargate.db.schema.Column column, String fieldName) {
            super(Kind.UDT_FIELD, column);
            this.fieldName = fieldName;
            Column.ColumnType type = column.type();
            if (type == null) {
                throw new IllegalArgumentException("Provided column does not have its type set");
            }
            if (!type.isUserDefined()) {
                throw new IllegalArgumentException(String.format("Cannot access field %s of column %s of type %s, it is not a UDT", fieldName, column.cqlName(), type));
            }
            io.stargate.db.schema.Column field = ((UserDefinedType)type).columnMap().get(fieldName);
            if (field == null) {
                throw new IllegalArgumentException(String.format("Cannot access undefined field %s of column %s of type %s", fieldName, column.cqlName(), type));
            }
            this.fieldType = field.type();
            if (this.fieldType == null) {
                throw new IllegalArgumentException(String.format("The UDT type of %s is incomplete: it does not have a type for field %s", column.cqlName(), fieldName));
            }
        }

        @Override
        public Column.ColumnType type() {
            return this.fieldType;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public io.stargate.db.schema.Column parent() {
            return this.column;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind(), this.column, this.fieldName});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UdtField)) {
                return false;
            }
            UdtField that = (UdtField)obj;
            return this.column.equals(that.column) && this.fieldName.equals(that.fieldName);
        }

        public String toString() {
            return String.format("%s.%s", this.column.cqlName(), this.fieldName);
        }
    }

    public static class Column
    extends ModifiableEntity {
        private Column(io.stargate.db.schema.Column column) {
            super(Kind.COLUMN, column);
        }

        @Override
        public Column.ColumnType type() {
            return this.column.type();
        }

        public io.stargate.db.schema.Column column() {
            return this.column;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind(), this.column});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Column)) {
                return false;
            }
            Column that = (Column)obj;
            return this.column.equals(that.column);
        }

        public String toString() {
            return this.column.cqlName();
        }
    }

    public static enum Kind {
        COLUMN,
        UDT_FIELD,
        MAP_VALUE;

    }
}

