/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query;

import io.stargate.db.query.BindMarker;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.query.TypedValue;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.cassandra.stargate.utils.MD5Digest;

public interface Query<B extends BoundQuery> {
    public TypedValue.Codec valueCodec();

    public List<BindMarker> bindMarkers();

    public Optional<MD5Digest> preparedId();

    public Query<B> withPreparedId(MD5Digest var1);

    public String queryStringForPreparation();

    public B bindValues(List<TypedValue> var1);

    default public B bind(Object ... values) {
        return this.bind(Arrays.asList(values));
    }

    default public B bind(List<Object> values) {
        return this.bindValues(TypedValue.forJavaValues(this.valueCodec(), this.bindMarkers(), values));
    }

    default public B bindBuffers(ByteBuffer ... values) {
        return this.bindBuffers(Arrays.asList(values));
    }

    default public B bindBuffers(List<ByteBuffer> values) {
        return this.bindValues(TypedValue.forBytesValues(this.valueCodec(), this.bindMarkers(), values));
    }

    public String toString();
}

