/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query.builder;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import io.stargate.db.Parameters;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.query.AsyncQueryExecutor;
import io.stargate.db.query.BindMarker;
import io.stargate.db.query.Query;
import io.stargate.db.query.QueryType;
import io.stargate.db.query.TypedValue;
import io.stargate.db.query.builder.AbstractBound;
import io.stargate.db.query.builder.Value;
import io.stargate.db.schema.Column;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.apache.cassandra.stargate.db.ConsistencyLevel;
import org.apache.cassandra.stargate.utils.MD5Digest;

public abstract class BuiltQuery<B extends AbstractBound<?>>
implements Query<B> {
    private final QueryType queryType;
    private final TypedValue.Codec codec;
    @Nullable
    private final MD5Digest preparedId;
    private final List<BindMarker> bindMarkers;
    private final AsyncQueryExecutor executor;

    protected BuiltQuery(QueryType queryType, TypedValue.Codec codec, @Nullable MD5Digest preparedId, AsyncQueryExecutor executor, List<BindMarker> bindMarkers) {
        this.queryType = queryType;
        this.codec = codec;
        this.preparedId = preparedId;
        this.bindMarkers = bindMarkers;
        this.executor = executor;
    }

    AsyncQueryExecutor executor() {
        return this.executor;
    }

    public QueryType type() {
        return this.queryType;
    }

    @Override
    public TypedValue.Codec valueCodec() {
        return this.codec;
    }

    @Override
    public Optional<MD5Digest> preparedId() {
        return Optional.ofNullable(this.preparedId);
    }

    @Override
    public List<BindMarker> bindMarkers() {
        return this.bindMarkers;
    }

    @Override
    public final B bindValues(List<TypedValue> values) {
        Preconditions.checkArgument(values.size() == this.bindMarkers.size(), "Unexpected number of arguments. Expected %s but got %s. Statement: %s.", (Object)this.bindMarkers.size(), (Object)values.size(), (Object)this.queryStringForPreparation());
        return this.createBoundQuery(values);
    }

    protected abstract B createBoundQuery(List<TypedValue> var1);

    protected TypedValue createTyped(String description, Column.ColumnType type, Object value) {
        return TypedValue.forJavaValue(this.valueCodec(), description, type, value);
    }

    private int externalIndex(Value<?> marker) {
        return ((Value.Marker)marker).externalIndex();
    }

    protected TypedValue convertValue(Value<?> value, String receiverName, Column.ColumnType type, List<TypedValue> externalBoundValues) {
        return value.isMarker() ? externalBoundValues.get(this.externalIndex(value)) : this.createTyped(receiverName, type, value.get());
    }

    public CompletableFuture<ResultSet> execute(Object ... values) {
        return this.execute(p -> p, values);
    }

    public CompletableFuture<ResultSet> execute(ConsistencyLevel consistency, Object ... values) {
        return this.execute(p -> p.withConsistencyLevel(consistency), values);
    }

    public CompletableFuture<ResultSet> execute(UnaryOperator<Parameters> parametersModifier, Object ... values) {
        return ((AbstractBound)this.bind(values)).execute(parametersModifier);
    }
}

