/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query.builder;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import io.stargate.db.query.AsyncQueryExecutor;
import io.stargate.db.query.BindMarker;
import io.stargate.db.query.BoundSelect;
import io.stargate.db.query.Query;
import io.stargate.db.query.QueryType;
import io.stargate.db.query.RowsImpacted;
import io.stargate.db.query.TypedValue;
import io.stargate.db.query.builder.AbstractBound;
import io.stargate.db.query.builder.BuiltCondition;
import io.stargate.db.query.builder.BuiltQuery;
import io.stargate.db.query.builder.QueryStringBuilder;
import io.stargate.db.query.builder.Value;
import io.stargate.db.query.builder.WhereProcessor;
import io.stargate.db.schema.AbstractTable;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.SchemaEntity;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.stargate.utils.MD5Digest;

public class BuiltSelect
extends BuiltQuery<Bound> {
    private final AbstractTable table;
    private final String externalQueryString;
    private final String internalQueryString;
    private final Set<Column> selectedColumns;
    private final List<Value<?>> internalWhereValues;
    private final List<BindMarker> internalBindMarkers;
    private final List<BuiltCondition> whereClause;
    @Nullable
    private final Value<Integer> limit;
    @Nullable
    private final Value<Integer> perPartitionLimit;

    protected BuiltSelect(AbstractTable table, TypedValue.Codec codec, AsyncQueryExecutor executor, QueryStringBuilder builder, Set<Column> selectedColumns, List<Value<?>> internalWhereValues, List<BindMarker> internalBindMarkers, List<BuiltCondition> whereClause, @Nullable Value<Integer> limit, @Nullable Value<Integer> perPartitionLimit) {
        this(table, codec, null, executor, builder.externalQueryString(), builder.externalBindMarkers(), builder.internalQueryString(), selectedColumns, internalWhereValues, internalBindMarkers, whereClause, limit, perPartitionLimit);
        int internalBoundValuesCount = internalWhereValues.size() + (limit == null ? 0 : 1) + (perPartitionLimit == null ? 0 : 1);
        Preconditions.checkArgument(builder.internalBindMarkers() == internalBoundValuesCount, "Provided %s values, but the builder has seen %s values", internalWhereValues.size(), builder.internalBindMarkers());
    }

    private BuiltSelect(AbstractTable table, TypedValue.Codec codec, @Nullable MD5Digest preparedId, AsyncQueryExecutor executor, String externalQueryString, List<BindMarker> unboundMarkers, String internalQueryString, Set<Column> selectedColumns, List<Value<?>> internalWhereValues, List<BindMarker> internalBindMarkers, List<BuiltCondition> whereClause, @Nullable Value<Integer> limit, @Nullable Value<Integer> perPartitionLimit) {
        super(QueryType.SELECT, codec, preparedId, executor, unboundMarkers);
        this.table = table;
        this.internalQueryString = internalQueryString;
        this.externalQueryString = externalQueryString;
        this.selectedColumns = selectedColumns;
        this.internalWhereValues = internalWhereValues;
        this.internalBindMarkers = internalBindMarkers;
        this.whereClause = whereClause;
        this.limit = limit;
        this.perPartitionLimit = perPartitionLimit;
    }

    public AbstractTable table() {
        return this.table;
    }

    public Set<Column> selectedColumns() {
        return this.selectedColumns;
    }

    @Override
    public String queryStringForPreparation() {
        return this.internalQueryString;
    }

    @Override
    protected Bound createBoundQuery(final List<TypedValue> values) {
        TypedValue[] internalBoundValues = new TypedValue[this.internalBindMarkers.size()];
        for (int i = 0; i < this.internalWhereValues.size(); ++i) {
            Value<?> internalValue = this.internalWhereValues.get(i);
            BindMarker internalMarker = this.internalBindMarkers.get(i);
            TypedValue v = this.convertValue(internalValue, internalMarker.receiver(), internalMarker.type(), values);
            int internalIndex = internalValue.internalIndex();
            Preconditions.checkState(internalIndex >= 0);
            internalBoundValues[internalIndex] = v;
        }
        WhereProcessor whereProcessor = new WhereProcessor(this.table, this.valueCodec()){

            @Override
            protected TypedValue handleValue(String name, Column.ColumnType type, Value<?> value) {
                return BuiltSelect.this.convertValue(value, name, type, values);
            }
        };
        OptionalInt optLimit = OptionalInt.empty();
        if (this.limit != null) {
            TypedValue v = this.convertValue(this.limit, "[limit]", Column.Type.Int, values);
            int internalIndex = this.limit.internalIndex();
            if (internalIndex >= 0) {
                internalBoundValues[internalIndex] = v;
            }
            if (!v.isUnset()) {
                Integer lvalue = (Integer)v.javaValue();
                if (lvalue == null) {
                    throw new IllegalArgumentException("Cannot pass null as bound value for the LIMIT");
                }
                optLimit = OptionalInt.of(lvalue);
            }
        }
        OptionalInt optPerPartitionLimit = OptionalInt.empty();
        if (this.perPartitionLimit != null) {
            TypedValue v = this.convertValue(this.perPartitionLimit, "[per-partition-limit]", Column.Type.Int, values);
            int internalIndex = this.perPartitionLimit.internalIndex();
            if (internalIndex >= 0) {
                internalBoundValues[internalIndex] = v;
            }
            if (!v.isUnset()) {
                Integer lvalue = (Integer)v.javaValue();
                if (lvalue == null) {
                    throw new IllegalArgumentException("Cannot pass null as bound value for the PER PARTITION LIMIT");
                }
                optPerPartitionLimit = OptionalInt.of(lvalue);
            }
        }
        return new Bound(this, values, Arrays.asList(internalBoundValues), whereProcessor.process(this.whereClause), optLimit, optPerPartitionLimit);
    }

    @Override
    public Query<Bound> withPreparedId(MD5Digest preparedId) {
        return new BuiltSelect(this.table(), this.valueCodec(), preparedId, this.executor(), this.externalQueryString, this.bindMarkers(), this.internalQueryString, this.selectedColumns, this.internalWhereValues, this.internalBindMarkers, this.whereClause, this.limit, this.perPartitionLimit);
    }

    @Override
    public final String toString() {
        return this.externalQueryString;
    }

    public static class Bound
    extends AbstractBound<BuiltSelect>
    implements BoundSelect {
        @Nullable
        private final RowsImpacted selectedRows;
        private final OptionalInt limit;
        private final OptionalInt perPartitionLimit;

        private Bound(BuiltSelect builtQuery, List<TypedValue> boundedValues, List<TypedValue> values, @Nullable RowsImpacted selectedRows, OptionalInt limit, OptionalInt perPartitionLimit) {
            super(builtQuery, boundedValues, values);
            this.selectedRows = selectedRows;
            this.limit = limit;
            this.perPartitionLimit = perPartitionLimit;
        }

        @Override
        public AbstractTable table() {
            return ((BuiltSelect)this.source().query()).table();
        }

        @Override
        public Set<Column> selectedColumns() {
            return ((BuiltSelect)this.source().query()).selectedColumns();
        }

        @Override
        public Optional<RowsImpacted> selectedRows() {
            return Optional.ofNullable(this.selectedRows);
        }

        private String addColumnsToQueryString(Set<Column> toAdd, String queryString, boolean isStarSelect) {
            StringBuilder sb = new StringBuilder();
            if (isStarSelect) {
                int idx = queryString.indexOf(42);
                Preconditions.checkState(idx > 0, "Should have found '*' in %s", (Object)queryString);
                sb.append(queryString, 0, idx);
                sb.append(toAdd.stream().map(SchemaEntity::cqlName).collect(Collectors.joining(", ")));
                sb.append(queryString, idx + 1, queryString.length());
            } else {
                int idx = queryString.indexOf(" FROM ");
                Preconditions.checkState(idx > 0, "Should have found 'FROM' in %s", (Object)queryString);
                sb.append(queryString, 0, idx);
                for (Column c : toAdd) {
                    sb.append(", ").append(c.cqlName());
                }
                sb.append(queryString, idx, queryString.length());
            }
            return sb.toString();
        }

        @Override
        public BoundSelect withAddedSelectedColumns(Set<Column> columns) {
            Set<Column> toAdd = columns.stream().filter(c -> !this.selectedColumns().contains(c)).collect(Collectors.toSet());
            if (toAdd.isEmpty()) {
                return this;
            }
            HashSet<Column> newSelectedColumns = new HashSet<Column>(this.selectedColumns());
            newSelectedColumns.addAll(toAdd);
            BuiltSelect oldBuilt = (BuiltSelect)this.source().query();
            BuiltSelect newBuilt = new BuiltSelect(this.table(), oldBuilt.valueCodec(), null, oldBuilt.executor(), this.addColumnsToQueryString(toAdd, oldBuilt.externalQueryString, this.isStarSelect()), oldBuilt.bindMarkers(), this.addColumnsToQueryString(toAdd, oldBuilt.internalQueryString, this.isStarSelect()), newSelectedColumns, oldBuilt.internalWhereValues, oldBuilt.internalBindMarkers, oldBuilt.whereClause, this.limit.isPresent() ? Value.of(this.limit.getAsInt()) : null, this.perPartitionLimit.isPresent() ? Value.of(this.perPartitionLimit.getAsInt()) : null);
            return new Bound(newBuilt, this.source().values(), this.values(), this.selectedRows, this.limit, this.perPartitionLimit);
        }

        @Override
        public OptionalInt limit() {
            return this.limit;
        }
    }
}

