/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query.builder;

import com.datastax.oss.driver.internal.core.util.Strings;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import io.stargate.db.query.AsyncQueryExecutor;
import io.stargate.db.query.BindMarker;
import io.stargate.db.query.Modification;
import io.stargate.db.query.Predicate;
import io.stargate.db.query.TypedValue;
import io.stargate.db.query.builder.BuiltCondition;
import io.stargate.db.query.builder.BuiltDelete;
import io.stargate.db.query.builder.BuiltInsert;
import io.stargate.db.query.builder.BuiltOther;
import io.stargate.db.query.builder.BuiltQuery;
import io.stargate.db.query.builder.BuiltSelect;
import io.stargate.db.query.builder.BuiltUpdate;
import io.stargate.db.query.builder.ColumnOrder;
import io.stargate.db.query.builder.QueryStringBuilder;
import io.stargate.db.query.builder.Replication;
import io.stargate.db.query.builder.Value;
import io.stargate.db.query.builder.ValueModifier;
import io.stargate.db.schema.AbstractTable;
import io.stargate.db.schema.CollectionIndexingType;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ColumnUtils;
import io.stargate.db.schema.ImmutableColumn;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.Schema;
import io.stargate.db.schema.SchemaEntity;
import io.stargate.db.schema.SecondaryIndex;
import io.stargate.db.schema.Table;
import io.stargate.db.schema.UserDefinedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.javatuples.Pair;

public class QueryBuilderImpl {
    private final Schema schema;
    private final TypedValue.Codec valueCodec;
    @Nullable
    private final AsyncQueryExecutor executor;
    private int markerIndex;
    private boolean isCreate;
    private boolean isAlter;
    private boolean isInsert;
    private boolean isUpdate;
    private boolean isDelete;
    private boolean isSelect;
    private boolean isDrop;
    private boolean isKeyspace;
    private boolean isTable;
    private boolean isMaterializedView;
    private boolean isType;
    private boolean isIndex;
    private boolean isTruncate;
    private boolean indexKeys;
    private boolean indexValues;
    private boolean indexEntries;
    private boolean indexFull;
    private String keyspaceName;
    private String tableName;
    private String indexName;
    private final List<Column> createColumns = new ArrayList<Column>();
    private final List<Column> addColumns = new ArrayList<Column>();
    private final List<String> dropColumns = new ArrayList<String>();
    private final List<Pair<String, String>> columnRenames = new ArrayList<Pair<String, String>>();
    private final List<ValueModifier> dmlModifications = new ArrayList<ValueModifier>();
    private final List<String> selection = new ArrayList<String>();
    private final List<FunctionCall> functionCalls = new ArrayList<FunctionCall>();
    private final List<BuiltCondition> wheres = new ArrayList<BuiltCondition>();
    private final List<BuiltCondition> ifs = new ArrayList<BuiltCondition>();
    @Nullable
    private Value<Integer> limit;
    @Nullable
    private Value<Integer> perPartitionLimit;
    private final List<Column> groupBys = new ArrayList<Column>();
    private List<ColumnOrder> orders = new ArrayList<ColumnOrder>();
    private Replication replication;
    private boolean ifNotExists;
    private boolean ifExists;
    @Nullable
    private Boolean durableWrites;
    private String comment;
    private Integer defaultTTL;
    private String indexCreateColumn;
    private String customIndexClass;
    private Map<String, String> customIndexOptions;
    private UserDefinedType type;
    private Value<Integer> ttl;
    private Value<Long> timestamp;
    private boolean allowFiltering;

    public QueryBuilderImpl(Schema schema, TypedValue.Codec valueCodec, @Nullable AsyncQueryExecutor executor) {
        this.schema = schema;
        this.valueCodec = valueCodec;
        this.executor = executor;
    }

    private void preprocessValue(Value<?> v) {
        if (v != null && v.isMarker()) {
            ((Value.Marker)v).setExternalIndex(this.markerIndex++);
        }
    }

    public void create() {
        this.isCreate = true;
    }

    public void alter() {
        this.isAlter = true;
    }

    public void drop() {
        this.isDrop = true;
    }

    public void truncate() {
        this.isTruncate = true;
    }

    public void keyspace(String keyspace) {
        this.keyspaceName = keyspace;
        this.isKeyspace = true;
    }

    public void table(String keyspace, String table) {
        this.keyspaceName = keyspace;
        this.table(table);
    }

    public void table(String table) {
        Preconditions.checkArgument(this.keyspaceName != null, "Keyspace must be specified");
        this.tableName = table;
        this.isTable = true;
    }

    public void withReplication(Replication replication) {
        this.replication = replication;
    }

    public void andDurableWrites(boolean durableWrites) {
        this.durableWrites = durableWrites;
    }

    public void ifNotExists() {
        this.ifNotExists(true);
    }

    public void ifNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void ifExists() {
        this.ifExists(true);
    }

    public void ifExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    public void withComment(String comment) {
        this.comment = comment;
    }

    public void withDefaultTTL(int defaultTTL) {
        this.defaultTTL = defaultTTL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void column(String column) {
        if (this.isCreate) {
            Preconditions.checkArgument(!this.isTable, "Column '%s' type must be specified for table '%s'", (Object)column, (Object)this.tableName);
            if (this.isMaterializedView) {
                this.createColumns.add(Column.reference(column));
                return;
            } else {
                if (!this.isIndex) throw new AssertionError((Object)"This shouldn't have been called");
                Preconditions.checkArgument(this.indexCreateColumn == null, "Index column has already been set");
                this.indexCreateColumn = column;
            }
            return;
        } else {
            if (!this.isSelect && !this.isDelete) throw new AssertionError((Object)"This shouldn't have been called");
            this.selection.add(column);
        }
    }

    public void column(String ... columns) {
        for (String c : columns) {
            this.column(c);
        }
    }

    public void column(Column column) {
        this.checkMaterializedViewColumn(column);
        this.checkTableColumn(column);
        if (this.isCreate && (this.isTable || this.isMaterializedView)) {
            this.createColumns.add(column);
        } else {
            this.column(column.name());
        }
    }

    public void column(Collection<Column> columns) {
        for (Column c : columns) {
            this.column(c);
        }
    }

    public void column(String column, Column.ColumnType type, Column.Kind kind) {
        this.column(ImmutableColumn.builder().name(column).type(type).kind(kind).build());
    }

    public void column(String column, Column.ColumnType type, Column.Kind kind, Column.Order order) {
        this.column(ImmutableColumn.builder().name(column).type(type).kind(kind).order(order).build());
    }

    public void column(String column, Class<?> type, Column.Kind kind) {
        this.column(ImmutableColumn.builder().name(column).type(type).kind(kind).build());
    }

    public void column(String column, Class<?> type, Column.Kind kind, Column.Order order) {
        this.column(ImmutableColumn.builder().name(column).type(type).kind(kind).order(order).build());
    }

    public void column(String column, Column.Kind kind) {
        this.column(ImmutableColumn.builder().name(column).kind(kind).build());
    }

    public void column(String column, Column.Kind kind, Column.Order order) {
        this.column(ImmutableColumn.builder().name(column).kind(kind).order(order).build());
    }

    public void column(String column, Column.ColumnType type) {
        this.column(column, type, Column.Kind.Regular);
    }

    public void as(String alias) {
        if (this.functionCalls.isEmpty()) {
            throw new IllegalStateException("The as() method cannot be called without a preceding function call.");
        }
        FunctionCall functionCall = this.functionCalls.get(this.functionCalls.size() - 1);
        functionCall.setAlias(alias);
    }

    public void writeTimeColumn(String columnName) {
        this.functionCalls.add(FunctionCall.writeTime(columnName));
    }

    public void writeTimeColumn(Column columnName) {
        this.writeTimeColumn(columnName.name());
    }

    public void count(String columnName) {
        this.functionCalls.add(FunctionCall.count(columnName));
    }

    public void count(Column columnName) {
        this.count(columnName.name());
    }

    public void max(String maxColumnName) {
        this.functionCalls.add(FunctionCall.max(maxColumnName));
    }

    public void max(Column maxColumnName) {
        this.max(maxColumnName.name());
    }

    public void min(String minColumnName) {
        this.functionCalls.add(FunctionCall.min(minColumnName));
    }

    public void min(Column minColumnName) {
        this.min(minColumnName.name());
    }

    public void sum(String sumColumnName) {
        this.functionCalls.add(FunctionCall.sum(sumColumnName));
    }

    public void sum(Column sumColumnName) {
        this.sum(sumColumnName.name());
    }

    public void avg(String avgColumnName) {
        this.functionCalls.add(FunctionCall.avg(avgColumnName));
    }

    public void avg(Column avgColumnName) {
        this.avg(avgColumnName.name());
    }

    public void function(Collection<FunctionCall> calls) {
        this.functionCalls.addAll(calls);
    }

    public void star() {
        Preconditions.checkArgument(this.selection.isEmpty(), "Cannot use * when other columns are selected");
    }

    private void checkMaterializedViewColumn(Column column) {
        Preconditions.checkArgument(!this.isCreate || !this.isMaterializedView || column.type() == null, "Column '%s' type should not be specified for materialized view '%s'", (Object)column.name(), (Object)(this.indexName != null ? this.indexName : ""));
    }

    private void checkTableColumn(Column column) {
        Preconditions.checkArgument(!this.isCreate || !this.isTable || column.type() != null, "Column '%s' type must be specified for table '%s'", (Object)column.name(), (Object)(this.tableName != null ? this.tableName : ""));
    }

    public void column(String column, Class<?> type) {
        this.column(column, type, Column.Kind.Regular);
    }

    public void addColumn(String column, Column.ColumnType type) {
        this.addColumn(ImmutableColumn.builder().name(column).type(type).kind(Column.Kind.Regular).build());
    }

    public void addColumn(Column column) {
        this.addColumns.add(column);
    }

    public void addColumn(Collection<Column> columns) {
        for (Column column : columns) {
            this.addColumn(column);
        }
    }

    public void dropColumn(String column) {
        this.dropColumns.add(column);
    }

    public void dropColumn(Collection<String> columns) {
        for (String column : columns) {
            this.dropColumn(column);
        }
    }

    public void dropColumn(Column column) {
        this.dropColumn(column.name());
    }

    public void renameColumn(String from, String to) {
        this.columnRenames.add(Pair.with(from, to));
    }

    public void renameColumn(List<Pair<String, String>> columnRenames) {
        this.columnRenames.addAll(columnRenames);
    }

    public void insertInto(String keyspace, String table) {
        this.keyspaceName = keyspace;
        this.tableName = table;
        this.isInsert = true;
    }

    public void insertInto(Table table) {
        this.insertInto(table.keyspace(), table.name());
    }

    public void update(String keyspace, String table) {
        this.keyspaceName = keyspace;
        this.tableName = table;
        this.isUpdate = true;
    }

    public void update(Table table) {
        this.update(table.keyspace(), table.name());
    }

    public void delete() {
        this.isDelete = true;
    }

    public void select() {
        this.isSelect = true;
    }

    public void from(String keyspace, String table) {
        this.keyspaceName = keyspace;
        this.from(table);
    }

    public void from(String table) {
        Preconditions.checkArgument(this.keyspaceName != null, "Keyspace must be specified");
        this.tableName = table;
    }

    public void from(AbstractTable table) {
        this.from(table.keyspace(), table.name());
    }

    public void value(String column, Object value) {
        this.value(ValueModifier.set(column, value));
    }

    public void value(String column) {
        this.value(ValueModifier.marker(column));
    }

    public void value(Column column) {
        this.value(column.name());
    }

    public void value(Column column, Object value) {
        this.value(column.name(), value);
    }

    public void value(ValueModifier modifier) {
        this.preprocessValue(modifier.target().mapKey());
        this.preprocessValue(modifier.value());
        this.dmlModifications.add(modifier);
    }

    public void value(Collection<ValueModifier> setters) {
        for (ValueModifier setter : setters) {
            this.value(setter);
        }
    }

    public void where(Column column, Predicate predicate, Object value) {
        this.where(column.name(), predicate, value);
    }

    public void where(Column column, Predicate predicate) {
        this.where(column.name(), predicate);
    }

    public void where(String columnName, Predicate predicate, Object value) {
        this.where(BuiltCondition.of(columnName, predicate, value));
    }

    public void where(String columnName, Predicate predicate) {
        this.where(BuiltCondition.ofMarker(columnName, predicate));
    }

    public void where(BuiltCondition where) {
        where.lhs().value().ifPresent(this::preprocessValue);
        this.preprocessValue(where.value());
        this.wheres.add(where);
    }

    public void where(Collection<? extends BuiltCondition> where) {
        for (BuiltCondition builtCondition : where) {
            this.where(builtCondition);
        }
    }

    public void ifs(String columnName, Predicate predicate, Object value) {
        this.ifs(BuiltCondition.of(columnName, predicate, value));
    }

    public void ifs(String columnName, Predicate predicate) {
        this.ifs(BuiltCondition.ofMarker(columnName, predicate));
    }

    public void ifs(BuiltCondition condition) {
        condition.lhs().value().ifPresent(this::preprocessValue);
        this.preprocessValue(condition.value());
        this.ifs.add(condition);
    }

    public void ifs(Collection<? extends BuiltCondition> conditions) {
        for (BuiltCondition builtCondition : conditions) {
            this.ifs(builtCondition);
        }
    }

    public void materializedView(String keyspace, String name) {
        this.keyspaceName = keyspace;
        this.materializedView(name);
    }

    public void materializedView(String name) {
        Preconditions.checkArgument(this.keyspaceName != null, "Keyspace must be specified");
        this.indexName = name;
        this.isMaterializedView = true;
    }

    public void materializedView(Keyspace keyspace, String name) {
        this.materializedView(keyspace.name(), name);
    }

    public void asSelect() {
    }

    public void on(String keyspace, String table) {
        this.keyspaceName = keyspace;
        this.on(table);
    }

    public void on(String table) {
        Preconditions.checkArgument(this.keyspaceName != null, "Keyspace must be specified");
        this.tableName = table;
    }

    public void on(Table table) {
        this.on(table.keyspace(), table.name());
    }

    public void index(String index) {
        this.indexName = index;
        this.isIndex = true;
    }

    public void index() {
        this.index((String)null);
    }

    public void index(SecondaryIndex index) {
        this.index(index.name());
    }

    public void index(String keyspace, String index) {
        this.keyspaceName = keyspace;
        this.index(index);
    }

    public void index(Keyspace keyspace, SecondaryIndex index) {
        this.index(keyspace.name(), index.name());
    }

    public void indexingType(CollectionIndexingType indexingType) {
        if (indexingType.indexEntries()) {
            this.indexEntries();
        } else if (indexingType.indexFull()) {
            this.indexFull();
        } else if (indexingType.indexKeys()) {
            this.indexKeys();
        } else if (indexingType.indexValues()) {
            this.indexValues();
        }
    }

    public void indexKeys() {
        this.indexKeys = true;
    }

    public void indexValues() {
        this.indexValues = true;
    }

    public void indexEntries() {
        this.indexEntries = true;
    }

    public void indexFull() {
        this.indexFull = true;
    }

    public void custom(String customIndexClass) {
        this.customIndexClass = customIndexClass;
    }

    public void custom(String customIndexClass, Map<String, String> customIndexOptions) {
        this.custom(customIndexClass);
        this.customIndexOptions = customIndexOptions;
    }

    public void options(Map<String, String> customIndexOptions) {
        this.customIndexOptions = customIndexOptions;
    }

    public void type(String keyspace, UserDefinedType type) {
        this.keyspaceName = keyspace;
        this.type = type;
        this.isType = true;
    }

    public void limit() {
        this.limit = Value.marker();
        this.preprocessValue(this.limit);
    }

    public void limit(Integer limit) {
        if (limit != null) {
            this.limit = Value.of(limit);
        }
    }

    public void perPartitionLimit() {
        this.perPartitionLimit = Value.marker();
        this.preprocessValue(this.perPartitionLimit);
    }

    public void perPartitionLimit(Integer limit) {
        if (limit != null) {
            this.perPartitionLimit = Value.of(limit);
        }
    }

    public void groupBy(Column column) {
        this.groupBys.add(column);
    }

    public void groupBy(String name) {
        this.groupBy(Column.reference(name));
    }

    public void groupBy(Iterable<Column> columns) {
        columns.forEach(this::groupBy);
    }

    public void groupBy(Column ... columns) {
        for (Column column : columns) {
            this.groupBy(column);
        }
    }

    public void orderBy(Column column, Column.Order order) {
        this.orderBy(column.name(), order);
    }

    public void orderBy(ColumnOrder ... orders) {
        Collections.addAll(this.orders, orders);
    }

    public void orderBy(List<ColumnOrder> orders) {
        this.orders = orders;
    }

    public void orderBy(String column, Column.Order order) {
        this.orderBy(ColumnOrder.of(column, order));
    }

    public void orderBy(String column) {
        this.orderBy(column, Column.Order.ASC);
    }

    public void orderBy(Column column) {
        this.orderBy(column, Column.Order.ASC);
    }

    public void allowFiltering() {
        this.allowFiltering = true;
    }

    public void allowFiltering(boolean allowFiltering) {
        this.allowFiltering = allowFiltering;
    }

    public void ttl() {
        this.ttl = Value.marker();
        this.preprocessValue(this.ttl);
    }

    public void ttl(Integer ttl) {
        if (ttl != null) {
            this.ttl = Value.of(ttl);
        }
    }

    public void timestamp() {
        this.timestamp = Value.marker();
        this.preprocessValue(this.timestamp);
    }

    public void timestamp(Long timestamp) {
        if (timestamp != null) {
            this.timestamp = Value.of(timestamp);
        }
    }

    public BuiltQuery<?> build() {
        if (this.isKeyspace && this.isCreate) {
            return this.createKeyspace();
        }
        if (this.isKeyspace && this.isAlter) {
            return this.alterKeyspace();
        }
        if (this.isKeyspace && this.isDrop) {
            return this.dropKeyspace();
        }
        if (this.isTable && this.isCreate) {
            return this.createTable();
        }
        if (this.isTable && this.isAlter) {
            return this.alterTable();
        }
        if (this.isTable && this.isDrop) {
            return this.dropTable();
        }
        if (this.isTable && this.isTruncate) {
            return this.truncateTable();
        }
        if (this.isIndex && this.isCreate) {
            return this.createIndex();
        }
        if (this.isIndex && this.isDrop) {
            return this.dropIndex();
        }
        if (this.isMaterializedView && this.isCreate) {
            return this.createMaterializedView();
        }
        if (this.isMaterializedView && this.isDrop) {
            return this.dropMaterializedView();
        }
        if (this.isType && this.isCreate) {
            return this.createType();
        }
        if (this.isType && this.isDrop) {
            return this.dropType();
        }
        if (this.isType && this.isAlter) {
            if (!this.columnRenames.isEmpty()) {
                return this.renameTypeColumns();
            }
            return this.alterType();
        }
        if (this.isInsert) {
            return this.insertQuery();
        }
        if (this.isUpdate) {
            return this.updateQuery();
        }
        if (this.isDelete) {
            return this.deleteQuery();
        }
        if (this.isSelect) {
            return this.selectQuery();
        }
        throw new AssertionError((Object)"Unknown query type");
    }

    @FormatMethod
    private static IllegalArgumentException invalid(@FormatString String format, Object ... args) {
        return new IllegalArgumentException(String.format(format, args));
    }

    private Keyspace schemaKeyspace() {
        Keyspace ks = this.schema.keyspace(this.keyspaceName);
        if (ks == null) {
            throw QueryBuilderImpl.invalid("Unknown keyspace %s", QueryBuilderImpl.cqlName(this.keyspaceName));
        }
        return ks;
    }

    private Table schemaTable() {
        Table table = this.schemaKeyspace().table(this.tableName);
        if (table == null) {
            throw QueryBuilderImpl.invalid("Unknown table %s.%s ", QueryBuilderImpl.cqlName(this.keyspaceName), QueryBuilderImpl.cqlName(this.tableName));
        }
        return table;
    }

    private AbstractTable tableOrMaterializedView() {
        AbstractTable table = this.schemaKeyspace().tableOrMaterializedView(this.tableName);
        if (table == null) {
            throw QueryBuilderImpl.invalid("Unknown table %s.%s ", QueryBuilderImpl.cqlName(this.keyspaceName), QueryBuilderImpl.cqlName(this.tableName));
        }
        return table;
    }

    private static String cqlName(String name) {
        return ColumnUtils.maybeQuote(name);
    }

    private BuiltQuery<?> createKeyspace() {
        StringBuilder query = new StringBuilder();
        query.append("CREATE KEYSPACE ");
        String ksName = QueryBuilderImpl.cqlName(this.keyspaceName);
        if (this.ifNotExists) {
            query.append("IF NOT EXISTS ");
        }
        query.append(ksName);
        query.append(" WITH replication = ").append(this.replication);
        if (this.durableWrites != null) {
            query.append(" AND durable_writes = ").append(this.durableWrites);
        }
        return new BuiltOther(this.valueCodec, this.executor, query.toString());
    }

    private BuiltQuery<?> alterKeyspace() {
        StringBuilder query = new StringBuilder();
        Keyspace keyspace = this.schemaKeyspace();
        query.append("ALTER KEYSPACE ").append(keyspace.cqlName());
        WithAdder with = new WithAdder(query);
        if (null != this.replication) {
            with.add().append(" replication = ").append(this.replication);
        }
        if (null != this.durableWrites) {
            with.add().append(" durable_writes = ").append(this.durableWrites);
        }
        return new BuiltOther(this.valueCodec, this.executor, query.toString());
    }

    private BuiltQuery<?> dropKeyspace() {
        StringBuilder query = new StringBuilder();
        query.append("DROP KEYSPACE ");
        String ksName = QueryBuilderImpl.cqlName(this.keyspaceName);
        if (this.ifExists) {
            query.append("IF EXISTS ");
        } else if (this.schema.keyspace(this.keyspaceName) == null) {
            throw QueryBuilderImpl.invalid("Keyspace %s does not exists", ksName);
        }
        query.append(ksName);
        return new BuiltOther(this.valueCodec, this.executor, query.toString());
    }

    private void addPrimaryKey(StringBuilder query, List<Column> columns, String name) {
        Preconditions.checkArgument(columns.stream().anyMatch(c -> c.kind() == Column.Kind.valueOf(Column.Kind.PartitionKey.name())), "At least one partition key must be specified for table or materialized view '%s' %s", (Object)name, (Object)Arrays.deepToString(columns.toArray()));
        query.append("PRIMARY KEY ((");
        query.append(columns.stream().filter(c -> c.kind() == Column.Kind.PartitionKey).map(SchemaEntity::cqlName).collect(Collectors.joining(", ")));
        query.append(")");
        if (columns.stream().anyMatch(c -> c.kind() == Column.Kind.Clustering)) {
            query.append(", ");
        }
        query.append(columns.stream().filter(c -> c.kind() == Column.Kind.Clustering).map(SchemaEntity::cqlName).collect(Collectors.joining(", ")));
        query.append(")");
    }

    private void addClusteringOrder(WithAdder with, List<Column> columns) {
        if (columns.stream().anyMatch(c -> c.kind() == Column.Kind.Clustering && c.order() != null)) {
            StringBuilder query = with.add();
            query.append(" CLUSTERING ORDER BY (");
            query.append(columns.stream().filter(c -> c.kind() == Column.Kind.Clustering).map(c -> c.cqlName() + " " + c.order().name().toUpperCase()).collect(Collectors.joining(", ")));
            query.append(")");
        }
    }

    private void addComment(WithAdder with) {
        if (this.comment != null) {
            String quotedComment = Strings.quote(this.comment);
            with.add().append(" comment = ").append(quotedComment);
        }
    }

    private void addDefaultTTL(WithAdder with) {
        if (this.defaultTTL != null) {
            with.add().append(" default_time_to_live = ").append(this.defaultTTL);
        }
    }

    private BuiltQuery<?> createTable() {
        StringBuilder query = new StringBuilder();
        Keyspace ks = this.schemaKeyspace();
        String tableName = QueryBuilderImpl.cqlName(this.tableName);
        query.append("CREATE TABLE ");
        if (this.ifNotExists) {
            query.append("IF NOT EXISTS ");
        } else if (ks.table(this.tableName) != null) {
            throw QueryBuilderImpl.invalid("A table named %s already exists", tableName);
        }
        query.append(ks.cqlName()).append('.').append(tableName);
        query.append(" (");
        query.append(this.createColumns.stream().map(c -> c.cqlName() + " " + c.type().cqlDefinition() + (c.kind() == Column.Kind.Static ? " STATIC" : "")).collect(Collectors.joining(", ")));
        query.append(", ");
        this.addPrimaryKey(query, this.createColumns, tableName);
        query.append(")");
        WithAdder with = new WithAdder(query);
        this.addClusteringOrder(with, this.createColumns);
        this.addComment(with);
        this.addDefaultTTL(with);
        return new BuiltOther(this.valueCodec, this.executor, query.toString());
    }

    private void addName(StringBuilder query, Table table) {
        query.append(table.cqlKeyspace()).append('.').append(table.cqlName());
    }

    private BuiltQuery<?> alterTable() {
        StringBuilder query = new StringBuilder();
        Table table = this.schemaTable();
        this.addName(query.append("ALTER TABLE "), table);
        if (!this.addColumns.isEmpty()) {
            query.append(" ADD (");
            query.append(this.addColumns.stream().map(c -> c.cqlName() + " " + c.type().cqlDefinition() + (c.kind() == Column.Kind.Static ? " STATIC" : "")).collect(Collectors.joining(", ")));
            query.append(")");
        }
        if (!this.dropColumns.isEmpty()) {
            query.append(" DROP (");
            query.append(this.dropColumns.stream().map(QueryBuilderImpl::cqlName).collect(Collectors.joining(", ")));
            query.append(")");
        }
        if (!this.columnRenames.isEmpty()) {
            query.append(" RENAME ");
            boolean isFirst = true;
            for (Pair<String, String> rename : this.columnRenames) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    query.append(" AND ");
                }
                query.append(QueryBuilderImpl.cqlName(rename.getValue0())).append(" TO ").append(QueryBuilderImpl.cqlName(rename.getValue1()));
            }
        }
        WithAdder with = new WithAdder(query);
        this.addComment(with);
        this.addDefaultTTL(with);
        return new BuiltOther(this.valueCodec, this.executor, query.toString());
    }

    private BuiltQuery<?> dropTable() {
        StringBuilder query = new StringBuilder();
        Keyspace keyspace = this.schemaKeyspace();
        String name = QueryBuilderImpl.cqlName(this.tableName);
        query.append("DROP TABLE ");
        if (this.ifExists) {
            query.append("IF EXISTS ");
        } else if (keyspace.table(this.tableName) == null) {
            throw QueryBuilderImpl.invalid("Table %s.%s does not exists", keyspace.cqlName(), name);
        }
        query.append(keyspace.cqlName()).append('.').append(name);
        return new BuiltOther(this.valueCodec, this.executor, query.toString());
    }

    private BuiltQuery<?> truncateTable() {
        StringBuilder query = new StringBuilder();
        query.append("TRUNCATE ");
        this.addName(query, this.schemaTable());
        return new BuiltOther(this.valueCodec, this.executor, query.toString());
    }

    private boolean indexExists(Keyspace keyspace, String indexName) {
        return keyspace.tables().stream().flatMap(t -> t.indexes().stream()).anyMatch(i -> indexName.equals(i.name()));
    }

    private BuiltQuery<?> createIndex() {
        StringBuilder query = new StringBuilder();
        Table table = this.schemaTable();
        query.append("CREATE");
        if (this.customIndexClass != null) {
            query.append(" CUSTOM");
        }
        query.append(" INDEX");
        if (this.ifNotExists) {
            query.append(" IF NOT EXISTS");
        } else if (this.indexName != null && this.indexExists(this.schemaKeyspace(), this.indexName)) {
            throw QueryBuilderImpl.invalid("An index named %s already exists", this.indexName);
        }
        if (this.indexName != null) {
            query.append(" " + QueryBuilderImpl.cqlName(this.indexName));
        }
        query.append(" ON ");
        this.addName(query, table);
        query.append(" (");
        Column column = table.column(this.indexCreateColumn);
        if (column == null) {
            throw QueryBuilderImpl.invalid("Unknown column %s in table %s.%s", this.indexCreateColumn, table.cqlKeyspace(), table.cqlName());
        }
        if (this.indexKeys) {
            Preconditions.checkArgument(column.ofTypeMap(), "Indexing keys can only be used with a map");
            query.append("KEYS(");
        } else if (this.indexValues) {
            Preconditions.checkArgument(column.isCollection(), "Indexing values can only be used on collections");
            query.append("VALUES(");
        } else if (this.indexEntries) {
            Preconditions.checkArgument(column.ofTypeMap(), "Indexing entries can only be used with a map");
            query.append("ENTRIES(");
        } else if (this.indexFull) {
            query.append("FULL(");
            Preconditions.checkArgument(column.isFrozenCollection(), "Full indexing can only be used with a frozen list/map/set");
        }
        query.append(column.cqlName());
        if (this.indexKeys || this.indexValues || this.indexEntries || this.indexFull) {
            query.append(")");
        }
        query.append(")");
        if (this.customIndexClass != null) {
            query.append(" USING").append(String.format(" '%s'", this.customIndexClass));
            if (this.customIndexOptions != null && !this.customIndexOptions.isEmpty()) {
                query.append(this.customIndexOptions.entrySet().stream().map(e -> String.format("'%s': '%s'", e.getKey(), e.getValue())).collect(Collectors.joining(", ", " WITH OPTIONS = { ", " }")));
            }
        }
        return new BuiltOther(this.valueCodec, this.executor, query.toString());
    }

    private BuiltQuery<?> dropIndex() {
        StringBuilder query = new StringBuilder();
        Keyspace keyspace = this.schemaKeyspace();
        query.append("DROP INDEX ");
        if (this.ifExists) {
            query.append("IF EXISTS ");
        } else if (!this.indexExists(keyspace, this.indexName)) {
            throw QueryBuilderImpl.invalid("Index %s does not exists", this.indexName);
        }
        query.append(keyspace.cqlName()).append('.').append(QueryBuilderImpl.cqlName(this.indexName));
        return new BuiltOther(this.valueCodec, this.executor, query.toString());
    }

    private static List<Column> validateColumns(Table table, Collection<String> columnNames) {
        return columnNames.stream().map(table::existingColumn).collect(Collectors.toList());
    }

    private static List<Column> convertToColumns(AbstractTable table, Collection<String> columnNames) {
        return columnNames.stream().map(table::column).collect(Collectors.toList());
    }

    private Set<String> names(Collection<Column> columns) {
        return columns.stream().map(SchemaEntity::name).collect(Collectors.toSet());
    }

    private BuiltQuery<?> createMaterializedView() {
        StringBuilder query = new StringBuilder();
        Table baseTable = this.schemaTable();
        Set<String> baseTablePkColumnNames = this.names(baseTable.primaryKeyColumns());
        Set<String> mvColumnNames = this.names(this.createColumns);
        QueryBuilderImpl.validateColumns(baseTable, mvColumnNames);
        Sets.SetView<String> missingColumns = Sets.difference(baseTablePkColumnNames, mvColumnNames);
        Preconditions.checkArgument(missingColumns.isEmpty(), "Materialized view %s primary key was missing components %s", (Object)QueryBuilderImpl.cqlName(this.indexName), missingColumns);
        List mvPrimaryKeyColumns = this.createColumns.stream().filter(c -> c.kind() != null && c.isPrimaryKeyComponent()).map(SchemaEntity::name).collect(Collectors.toList());
        Preconditions.checkArgument(!mvPrimaryKeyColumns.isEmpty(), "Materialized view %s must have at least 1 primary key column", (Object)QueryBuilderImpl.cqlName(this.indexName));
        List nonPrimaryKeysThatArePartOfMvPrimaryKey = mvPrimaryKeyColumns.stream().map(baseTable::column).filter(c -> !c.isPrimaryKeyComponent()).map(SchemaEntity::name).collect(Collectors.toList());
        Preconditions.checkArgument(nonPrimaryKeysThatArePartOfMvPrimaryKey.size() <= 1, "Materialized view %s supports only one source non-primary key component but it defined more than one: %s", (Object)QueryBuilderImpl.cqlName(this.indexName), nonPrimaryKeysThatArePartOfMvPrimaryKey);
        query.append("CREATE MATERIALIZED VIEW ");
        if (this.ifNotExists) {
            query.append("IF NOT EXISTS ");
        } else if (this.schemaKeyspace().table(this.indexName) != null) {
            throw QueryBuilderImpl.invalid("A table named %s already exists", QueryBuilderImpl.cqlName(this.indexName));
        }
        query.append(baseTable.cqlKeyspace()).append('.').append(QueryBuilderImpl.cqlName(this.indexName));
        query.append(" AS SELECT ");
        query.append(this.createColumns.stream().map(SchemaEntity::cqlName).collect(Collectors.joining(", ")));
        query.append(" FROM ");
        this.addName(query, baseTable);
        query.append(" WHERE ");
        query.append(this.createColumns.stream().map(c -> c.cqlName() + " IS NOT NULL").collect(Collectors.joining(" AND ")));
        query.append(" ");
        this.addPrimaryKey(query, this.createColumns, this.indexName);
        WithAdder with = new WithAdder(query);
        this.addClusteringOrder(with, this.createColumns);
        this.addComment(with);
        this.addDefaultTTL(with);
        return new BuiltOther(this.valueCodec, this.executor, query.toString());
    }

    private BuiltQuery<?> dropMaterializedView() {
        StringBuilder query = new StringBuilder();
        Keyspace keyspace = this.schemaKeyspace();
        query.append("DROP MATERIALIZED VIEW ");
        if (this.ifExists) {
            query.append("IF EXISTS ");
        } else if (keyspace.table(this.indexName) == null) {
            throw QueryBuilderImpl.invalid("Materialized view %s.%s does not exists", keyspace.cqlName(), QueryBuilderImpl.cqlName(this.indexName));
        }
        query.append(keyspace.cqlName()).append('.').append(QueryBuilderImpl.cqlName(this.indexName));
        return new BuiltOther(this.valueCodec, this.executor, query.toString());
    }

    private BuiltQuery<?> createType() {
        StringBuilder query = new StringBuilder();
        Keyspace keyspace = this.schemaKeyspace();
        query.append("CREATE TYPE ");
        if (this.ifNotExists) {
            query.append("IF NOT EXISTS ");
        } else if (keyspace.userDefinedType(this.type.name()) != null) {
            throw QueryBuilderImpl.invalid("A type named %s.%s already exists", keyspace.cqlName(), this.type.cqlName());
        }
        query.append(keyspace.cqlName()).append('.').append(this.type.cqlName());
        query.append(this.type.columns().stream().map(c -> c.cqlName() + " " + c.type().cqlDefinition()).collect(Collectors.joining(", ", " (", ")")));
        return new BuiltOther(this.valueCodec, this.executor, query.toString());
    }

    private BuiltQuery<?> renameTypeColumns() {
        StringBuilder query = new StringBuilder();
        Keyspace keyspace = this.schemaKeyspace();
        query.append("ALTER TYPE ");
        query.append(keyspace.cqlName()).append('.').append(this.type.cqlName()).append(" ");
        query.append("RENAME ");
        query.append(this.columnRenames.stream().map(n -> (String)n.getValue0() + " TO " + (String)n.getValue1()).collect(Collectors.joining(" AND ")));
        return new BuiltOther(this.valueCodec, this.executor, query.toString());
    }

    private BuiltQuery<?> dropType() {
        StringBuilder query = new StringBuilder();
        Keyspace keyspace = this.schemaKeyspace();
        query.append("DROP TYPE ");
        if (this.ifExists) {
            query.append("IF EXISTS ");
        } else if (keyspace.userDefinedType(this.type.name()) == null) {
            throw QueryBuilderImpl.invalid("User type %s.%s does not exists", keyspace.cqlName(), this.type.cqlName());
        }
        query.append(keyspace.cqlName()).append('.').append(this.type.cqlName());
        return new BuiltOther(this.valueCodec, this.executor, query.toString());
    }

    private BuiltQuery<?> alterType() {
        StringBuilder query = new StringBuilder();
        Keyspace keyspace = this.schemaKeyspace();
        query.append("ALTER TYPE ");
        query.append(keyspace.cqlName()).append('.').append(this.type.cqlName());
        assert (!this.addColumns.isEmpty());
        query.append(" ADD ");
        query.append(this.addColumns.stream().map(c -> c.cqlName() + " " + c.type().cqlDefinition()).collect(Collectors.joining(", ")));
        return new BuiltOther(this.valueCodec, this.executor, query.toString());
    }

    private BuiltInsert insertQuery() {
        Table table = this.schemaTable();
        QueryStringBuilder builder = new QueryStringBuilder(this.markerIndex);
        builder.append("INSERT INTO").append(table);
        List columns = this.dmlModifications.stream().map(m -> {
            Preconditions.checkArgument(m.target().fieldName() == null && m.target().mapKey() == null);
            return table.existingColumn(m.target().columnName());
        }).collect(Collectors.toList());
        ArrayList<ValueModifier> regularAndStaticModifiers = new ArrayList<ValueModifier>();
        ArrayList<BuiltCondition> where = new ArrayList<BuiltCondition>();
        builder.start("(").addAll(columns).end(")");
        builder.append("VALUES");
        builder.start("(").addAllWithIdx(this.dmlModifications, (modifier, i) -> {
            Column column = (Column)columns.get((int)i);
            Value<?> value = modifier.value();
            builder.append(BindMarker.markerFor(column), value);
            if (column.isPrimaryKeyComponent()) {
                where.add(BuiltCondition.ofModifier(modifier));
            } else {
                regularAndStaticModifiers.add((ValueModifier)modifier);
            }
        }).end(")");
        if (this.ifNotExists) {
            builder.append("IF NOT EXISTS");
        }
        this.addUsingClause(builder);
        return new BuiltInsert(table, this.valueCodec, this.executor, builder, where, regularAndStaticModifiers, this.ifNotExists, this.ttl, this.timestamp);
    }

    private void addUsingClause(QueryStringBuilder builder) {
        builder.lazyStart("USING", "AND").addIfNotNull(this.ttl, ttl -> builder.append("TTL").append(BindMarker.markerFor(Column.TTL), (Value<?>)ttl)).addIfNotNull(this.timestamp, timestamp -> builder.append("TIMESTAMP").append(BindMarker.markerFor(Column.TIMESTAMP), (Value<?>)timestamp)).end();
    }

    private void addModifier(Column column, ValueModifier modifier, QueryStringBuilder builder) {
        builder.append(column);
        Column.ColumnType type = column.type();
        Preconditions.checkArgument(type != null, "Column %s does not have its type set", (Object)column.cqlName());
        String fieldName = modifier.target().fieldName();
        Value<?> mapKey = modifier.target().mapKey();
        String valueDescription = column.cqlName();
        Column.ColumnType valueType = type;
        if (fieldName != null) {
            Preconditions.checkArgument(type.isUserDefined(), "Cannot update field %s of column %s of type %s, it is not a UDT", (Object)fieldName, (Object)column.cqlName(), (Object)type);
            Column field = ((UserDefinedType)type).columnMap().get(fieldName);
            Preconditions.checkArgument(field != null, "Column %s (of type %s) has no field %s", (Object)column.cqlName(), (Object)type, (Object)fieldName);
            builder.append('.' + fieldName);
            valueDescription = valueDescription + '.' + fieldName;
            valueType = field.type();
        } else if (mapKey != null) {
            Preconditions.checkArgument(type.isMap(), "Cannot update values of column %s of type %s, it is not a map", (Object)column.cqlName(), (Object)type);
            builder.append(BindMarker.markerFor(String.format("key(%s)", column.cqlName()), type.parameters().get(0)), mapKey);
            valueDescription = String.format("value(%s)", column.cqlName());
            valueType = type.parameters().get(1);
        }
        builder.append(this.operationStr(modifier.operation()));
        builder.append(BindMarker.markerFor(valueDescription, valueType), modifier.value());
        if (modifier.operation() == Modification.Operation.PREPEND) {
            builder.append("+").append(column);
        }
    }

    private String operationStr(Modification.Operation operation) {
        switch (operation) {
            case PREPEND: 
            case SET: {
                return "=";
            }
            case APPEND: 
            case INCREMENT: {
                return "+=";
            }
            case REMOVE: {
                return "-=";
            }
        }
        throw new UnsupportedOperationException();
    }

    private BuiltUpdate updateQuery() {
        Table table = this.schemaTable();
        QueryStringBuilder builder = new QueryStringBuilder(this.markerIndex);
        builder.append("UPDATE").append(table);
        this.addUsingClause(builder);
        builder.start("SET").addAll(this.dmlModifications, modifier -> {
            Column column = table.existingColumn(modifier.target().columnName());
            this.addModifier(column, (ValueModifier)modifier, builder);
        });
        this.handleDMLWhere(table, builder);
        this.handleDMLConditions(table, builder);
        return new BuiltUpdate(table, this.valueCodec, this.executor, builder, this.wheres, this.dmlModifications, this.ifExists, this.ifs, this.ttl, this.timestamp);
    }

    private void handleDMLWhere(Table table, QueryStringBuilder builder) {
        builder.lazyStart("WHERE", "AND").addAll(this.wheres, where -> where.addToBuilder(table, builder, m -> {})).end();
    }

    private void handleDMLConditions(Table table, QueryStringBuilder builder) {
        builder.lazyStart("IF", "AND").addIf(this.ifExists, () -> builder.append("EXISTS")).addAll(this.ifs, condition -> condition.addToBuilder(table, builder, m -> {})).end();
    }

    private BuiltDelete deleteQuery() {
        Table table = this.schemaTable();
        QueryStringBuilder builder = new QueryStringBuilder(this.markerIndex);
        List<Column> deletedColumns = QueryBuilderImpl.validateColumns(table, this.selection);
        builder.append("DELETE");
        builder.start().addAll(deletedColumns).end();
        deletedColumns.forEach(c -> this.dmlModifications.add(ValueModifier.of(c.name(), Value.of(null))));
        builder.append("FROM").append(table);
        if (this.timestamp != null) {
            builder.append("USING TIMESTAMP").append(BindMarker.markerFor(Column.TIMESTAMP), this.timestamp);
        }
        this.handleDMLWhere(table, builder);
        this.handleDMLConditions(table, builder);
        return new BuiltDelete(table, this.valueCodec, this.executor, builder, this.wheres, this.dmlModifications, this.ifExists, this.ifs, this.timestamp);
    }

    protected BuiltSelect selectQuery() {
        BindMarker marker;
        AbstractTable table = this.tableOrMaterializedView();
        QueryStringBuilder builder = new QueryStringBuilder(this.markerIndex);
        List<Column> selectedColumns = QueryBuilderImpl.convertToColumns(table, this.selection);
        LinkedHashSet<Column> allSelected = new LinkedHashSet<Column>(selectedColumns);
        for (FunctionCall functionCall : this.functionCalls) {
            allSelected.add(table.column(functionCall.columnName));
        }
        builder.append("SELECT");
        if (selectedColumns.isEmpty() && this.functionCalls.isEmpty()) {
            builder.append("*");
        } else {
            QueryStringBuilder.ListBuilder listBuilder = builder.start().addAll(selectedColumns);
            for (FunctionCall functionCall : this.functionCalls) {
                listBuilder.addIfNotNull(functionCall.getColumnName(), __ -> QueryBuilderImpl.addFunctionCallWithAliasIfPresent(builder, functionCall));
            }
        }
        builder.append("FROM").append(table);
        ArrayList internalWhereValues = new ArrayList();
        ArrayList<BindMarker> arrayList = new ArrayList<BindMarker>();
        builder.lazyStart("WHERE", "AND").addAll(this.wheres, where -> {
            where.addToBuilder(table, builder, internalBindMarkers::add);
            where.lhs().value().ifPresent(internalWhereValues::add);
            internalWhereValues.add(where.value());
        }).end();
        builder.lazyStart("GROUP BY").addAll(this.groupBys, builder::append).end();
        builder.lazyStart("ORDER BY").addAll(this.orders, order -> builder.append(order.column()).append(order.order().name().toUpperCase()));
        if (this.perPartitionLimit != null) {
            marker = BindMarker.markerFor("[per-partition-limit]", Column.Type.Int);
            builder.append("PER PARTITION LIMIT").append(marker, this.perPartitionLimit);
            arrayList.add(marker);
        }
        if (this.limit != null) {
            marker = BindMarker.markerFor("[limit]", Column.Type.Int);
            builder.append("LIMIT").append(marker, this.limit);
            arrayList.add(marker);
        }
        if (this.allowFiltering) {
            builder.append("ALLOW FILTERING");
        }
        return new BuiltSelect(table, this.valueCodec, this.executor, builder, allSelected, internalWhereValues, arrayList, this.wheres, this.limit, this.perPartitionLimit);
    }

    private static void addFunctionCallWithAliasIfPresent(QueryStringBuilder builder, FunctionCall functionCall) {
        builder.append(functionCall.getFunctionName() + "(").append(QueryBuilderImpl.cqlName(functionCall.getColumnName())).append(")");
        if (functionCall.getAlias() != null) {
            builder.append("AS").append(QueryBuilderImpl.cqlName(functionCall.getAlias()));
        }
    }

    public static class FunctionCall {
        final String columnName;
        @Nullable
        String alias;
        final String functionName;

        private FunctionCall(String columnName, String alias, String functionName) {
            this.columnName = columnName;
            this.alias = alias;
            this.functionName = functionName;
        }

        public static FunctionCall function(String name, String alias, String functionName) {
            return new FunctionCall(name, alias, functionName);
        }

        public static FunctionCall count(String columnName) {
            return FunctionCall.count(columnName, null);
        }

        public static FunctionCall count(String columnName, String alias) {
            return FunctionCall.function(columnName, alias, "COUNT");
        }

        public static FunctionCall max(String columnName) {
            return FunctionCall.max(columnName, null);
        }

        public static FunctionCall max(String columnName, String alias) {
            return FunctionCall.function(columnName, alias, "MAX");
        }

        public static FunctionCall min(String columnName) {
            return FunctionCall.min(columnName, null);
        }

        public static FunctionCall min(String columnName, String alias) {
            return FunctionCall.function(columnName, alias, "MIN");
        }

        public static FunctionCall avg(String columnName) {
            return FunctionCall.avg(columnName, null);
        }

        public static FunctionCall avg(String columnName, String alias) {
            return FunctionCall.function(columnName, alias, "AVG");
        }

        public static FunctionCall sum(String columnName) {
            return FunctionCall.sum(columnName, null);
        }

        public static FunctionCall sum(String columnName, String alias) {
            return FunctionCall.function(columnName, alias, "SUM");
        }

        public static FunctionCall ttl(String columnName) {
            return FunctionCall.ttl(columnName, null);
        }

        public static FunctionCall ttl(String columnName, String alias) {
            return FunctionCall.function(columnName, alias, "TTL");
        }

        public static FunctionCall writeTime(String columnName) {
            return FunctionCall.writeTime(columnName, null);
        }

        public static FunctionCall writeTime(String columnName, String alias) {
            return FunctionCall.function(columnName, alias, "WRITETIME");
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        @Nullable
        public String getAlias() {
            return this.alias;
        }
    }

    private static class WithAdder {
        private final StringBuilder builder;
        private boolean withAdded;

        private WithAdder(StringBuilder builder) {
            this.builder = builder;
        }

        private StringBuilder add() {
            if (!this.withAdded) {
                this.builder.append(" WITH");
                this.withAdded = true;
            } else {
                this.builder.append(" AND");
            }
            return this.builder;
        }
    }
}

