/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query.builder;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import io.stargate.db.query.TypedValue;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class Value<T> {
    private int internalIndex = -1;

    public static <T> Value<T> marker() {
        return new Marker();
    }

    public static <T> Value<T> of(T value) {
        return new Concrete(value);
    }

    public abstract boolean isMarker();

    public abstract T get();

    void setInternalIndex(int index) {
        Preconditions.checkArgument(index >= 0);
        this.internalIndex = index;
    }

    int internalIndex() {
        return this.internalIndex;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Value)) {
            return false;
        }
        Value that = (Value)obj;
        if (this.isMarker() != that.isMarker()) {
            return false;
        }
        return this.isMarker() || Objects.equals(this.get(), that.get());
    }

    public int hashCode() {
        return Objects.hash(this.isMarker(), this.isMarker() ? null : this.get());
    }

    static class Marker<T>
    extends Value<T> {
        private int externalIndex = -1;

        private Marker() {
        }

        void setExternalIndex(int externalIndex) {
            this.externalIndex = externalIndex;
        }

        int externalIndex() {
            Preconditions.checkState(this.externalIndex >= 0, "Marker has not bet set properly");
            return this.externalIndex;
        }

        @Override
        public boolean isMarker() {
            return true;
        }

        @Override
        public T get() {
            throw new UnsupportedOperationException("Cannot get the value of a marker");
        }

        public String toString() {
            return "?";
        }
    }

    private static class Concrete<T>
    extends Value<T> {
        @Nullable
        private final T value;

        private Concrete(T value) {
            Preconditions.checkArgument(value != TypedValue.UNSET, "Cannot set a column to <unset>. <unset> should only be used when binding value to prepared bind marker");
            this.value = value;
        }

        @Override
        public boolean isMarker() {
            return false;
        }

        @Override
        @Nullable
        public T get() {
            return this.value;
        }

        public String toString() {
            return this.value == null ? "null" : this.value.toString();
        }
    }
}

