/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.schema.Index;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.MaterializedView;
import io.stargate.db.schema.SchemaEntity;
import io.stargate.db.schema.SecondaryIndex;
import io.stargate.db.schema.Table;
import io.stargate.db.schema.UserDefinedType;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Keyspace", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableKeyspace
extends Keyspace {
    private final String name;
    private final Set<Table> tables;
    private final List<UserDefinedType> userDefinedTypes;
    private final Map<String, String> replication;
    @Nullable
    private final Boolean durableWrites;
    private final int schemaHashCode;
    private final int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long CQL_NAME_LAZY_INIT_BIT = 1L;
    private transient String cqlName;
    private static final long TABLE_MAP_LAZY_INIT_BIT = 2L;
    private transient Map<String, Table> tableMap;
    private static final long USER_DEFINED_TYPE_MAP_LAZY_INIT_BIT = 4L;
    private transient Map<String, UserDefinedType> userDefinedTypeMap;
    private static final long MATERIALIZED_VIEW_MAP_LAZY_INIT_BIT = 8L;
    private transient Map<String, MaterializedView> materializedViewMap;
    private static final long SECONDARY_INDEX_MAP_LAZY_INIT_BIT = 16L;
    private transient Map<String, SecondaryIndex> secondaryIndexMap;
    private static final long REVERSE_INDEX_MAP_LAZY_INIT_BIT = 32L;
    private transient Map<Index, Table> reverseIndexMap;
    private static final long serialVersionUID = -337891773492616286L;

    private ImmutableKeyspace(String name, Set<Table> tables, List<UserDefinedType> userDefinedTypes, Map<String, String> replication, @Nullable Boolean durableWrites) {
        this.name = name;
        this.tables = tables;
        this.userDefinedTypes = userDefinedTypes;
        this.replication = replication;
        this.durableWrites = durableWrites;
        this.schemaHashCode = super.schemaHashCode();
        this.hashCode = this.computeHashCode();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Set<Table> tables() {
        return this.tables;
    }

    @Override
    public List<UserDefinedType> userDefinedTypes() {
        return this.userDefinedTypes;
    }

    @Override
    public Map<String, String> replication() {
        return this.replication;
    }

    @Override
    public Optional<Boolean> durableWrites() {
        return Optional.ofNullable(this.durableWrites);
    }

    @Override
    public int schemaHashCode() {
        return this.schemaHashCode;
    }

    public final ImmutableKeyspace withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableKeyspace(newValue, this.tables, this.userDefinedTypes, this.replication, this.durableWrites);
    }

    public final ImmutableKeyspace withTables(Table ... elements) {
        Set<Table> newValue = ImmutableKeyspace.createUnmodifiableSet(ImmutableKeyspace.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableKeyspace(this.name, newValue, this.userDefinedTypes, this.replication, this.durableWrites);
    }

    public final ImmutableKeyspace withTables(Iterable<? extends Table> elements) {
        if (this.tables == elements) {
            return this;
        }
        Set<Table> newValue = ImmutableKeyspace.createUnmodifiableSet(ImmutableKeyspace.createSafeList(elements, true, false));
        return new ImmutableKeyspace(this.name, newValue, this.userDefinedTypes, this.replication, this.durableWrites);
    }

    public final ImmutableKeyspace withUserDefinedTypes(UserDefinedType ... elements) {
        List<UserDefinedType> newValue = ImmutableKeyspace.createUnmodifiableList(false, ImmutableKeyspace.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableKeyspace(this.name, this.tables, newValue, this.replication, this.durableWrites);
    }

    public final ImmutableKeyspace withUserDefinedTypes(Iterable<? extends UserDefinedType> elements) {
        if (this.userDefinedTypes == elements) {
            return this;
        }
        List<UserDefinedType> newValue = ImmutableKeyspace.createUnmodifiableList(false, ImmutableKeyspace.createSafeList(elements, true, false));
        return new ImmutableKeyspace(this.name, this.tables, newValue, this.replication, this.durableWrites);
    }

    public final ImmutableKeyspace withReplication(Map<String, ? extends String> entries) {
        if (this.replication == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableKeyspace.createUnmodifiableMap(true, false, entries);
        return new ImmutableKeyspace(this.name, this.tables, this.userDefinedTypes, newValue, this.durableWrites);
    }

    public final ImmutableKeyspace withDurableWrites(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.durableWrites, newValue)) {
            return this;
        }
        return new ImmutableKeyspace(this.name, this.tables, this.userDefinedTypes, this.replication, newValue);
    }

    public final ImmutableKeyspace withDurableWrites(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.durableWrites, value)) {
            return this;
        }
        return new ImmutableKeyspace(this.name, this.tables, this.userDefinedTypes, this.replication, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyspace && this.equalTo((ImmutableKeyspace)another);
    }

    private boolean equalTo(ImmutableKeyspace another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.name.equals(another.name) && this.tables.equals(another.tables) && this.userDefinedTypes.equals(another.userDefinedTypes) && this.replication.equals(another.replication) && Objects.equals(this.durableWrites, another.durableWrites);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.tables.hashCode();
        h += (h << 5) + this.userDefinedTypes.hashCode();
        h += (h << 5) + this.replication.hashCode();
        h += (h << 5) + Objects.hashCode(this.durableWrites);
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String cqlName() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableKeyspace immutableKeyspace = this;
            synchronized (immutableKeyspace) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.cqlName = Objects.requireNonNull(super.cqlName(), "cqlName");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.cqlName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Map<String, Table> tableMap() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableKeyspace immutableKeyspace = this;
            synchronized (immutableKeyspace) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.tableMap = Objects.requireNonNull(super.tableMap(), "tableMap");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.tableMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Map<String, UserDefinedType> userDefinedTypeMap() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableKeyspace immutableKeyspace = this;
            synchronized (immutableKeyspace) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.userDefinedTypeMap = Objects.requireNonNull(super.userDefinedTypeMap(), "userDefinedTypeMap");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.userDefinedTypeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Map<String, MaterializedView> materializedViewMap() {
        if ((this.lazyInitBitmap & 8L) == 0L) {
            ImmutableKeyspace immutableKeyspace = this;
            synchronized (immutableKeyspace) {
                if ((this.lazyInitBitmap & 8L) == 0L) {
                    this.materializedViewMap = Objects.requireNonNull(super.materializedViewMap(), "materializedViewMap");
                    this.lazyInitBitmap |= 8L;
                }
            }
        }
        return this.materializedViewMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Map<String, SecondaryIndex> secondaryIndexMap() {
        if ((this.lazyInitBitmap & 0x10L) == 0L) {
            ImmutableKeyspace immutableKeyspace = this;
            synchronized (immutableKeyspace) {
                if ((this.lazyInitBitmap & 0x10L) == 0L) {
                    this.secondaryIndexMap = Objects.requireNonNull(super.secondaryIndexMap(), "secondaryIndexMap");
                    this.lazyInitBitmap |= 0x10L;
                }
            }
        }
        return this.secondaryIndexMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Map<Index, Table> reverseIndexMap() {
        if ((this.lazyInitBitmap & 0x20L) == 0L) {
            ImmutableKeyspace immutableKeyspace = this;
            synchronized (immutableKeyspace) {
                if ((this.lazyInitBitmap & 0x20L) == 0L) {
                    this.reverseIndexMap = Objects.requireNonNull(super.reverseIndexMap(), "reverseIndexMap");
                    this.lazyInitBitmap |= 0x20L;
                }
            }
        }
        return this.reverseIndexMap;
    }

    public static ImmutableKeyspace copyOf(Keyspace instance) {
        if (instance instanceof ImmutableKeyspace) {
            return (ImmutableKeyspace)instance;
        }
        return ImmutableKeyspace.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return new ImmutableKeyspace(this.name, this.tables, this.userDefinedTypes, this.replication, this.durableWrites);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="Keyspace", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        private List<Table> tables = new ArrayList<Table>();
        private List<UserDefinedType> userDefinedTypes = new ArrayList<UserDefinedType>();
        private Map<String, String> replication = new LinkedHashMap<String, String>();
        @Nullable
        private Boolean durableWrites;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SchemaEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Keyspace instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SchemaEntity instance;
            if (object instanceof SchemaEntity) {
                instance = (SchemaEntity)object;
                this.name(instance.name());
            }
            if (object instanceof Keyspace) {
                instance = (Keyspace)object;
                this.putAllReplication(((Keyspace)instance).replication());
                Optional<Boolean> durableWritesOptional = ((Keyspace)instance).durableWrites();
                if (durableWritesOptional.isPresent()) {
                    this.durableWrites(durableWritesOptional);
                }
                this.addAllTables(((Keyspace)instance).tables());
                this.addAllUserDefinedTypes(((Keyspace)instance).userDefinedTypes());
            }
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTables(Table element) {
            this.tables.add(Objects.requireNonNull(element, "tables element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTables(Table ... elements) {
            for (Table element : elements) {
                this.tables.add(Objects.requireNonNull(element, "tables element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tables(Iterable<? extends Table> elements) {
            this.tables.clear();
            return this.addAllTables(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTables(Iterable<? extends Table> elements) {
            for (Table table : elements) {
                this.tables.add(Objects.requireNonNull(table, "tables element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addUserDefinedTypes(UserDefinedType element) {
            this.userDefinedTypes.add(Objects.requireNonNull(element, "userDefinedTypes element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addUserDefinedTypes(UserDefinedType ... elements) {
            for (UserDefinedType element : elements) {
                this.userDefinedTypes.add(Objects.requireNonNull(element, "userDefinedTypes element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder userDefinedTypes(Iterable<? extends UserDefinedType> elements) {
            this.userDefinedTypes.clear();
            return this.addAllUserDefinedTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllUserDefinedTypes(Iterable<? extends UserDefinedType> elements) {
            for (UserDefinedType userDefinedType : elements) {
                this.userDefinedTypes.add(Objects.requireNonNull(userDefinedType, "userDefinedTypes element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putReplication(String key, String value) {
            this.replication.put(Objects.requireNonNull(key, "replication key"), Objects.requireNonNull(value, "replication value"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putReplication(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.replication.put(Objects.requireNonNull(k, "replication key"), Objects.requireNonNull(v, "replication value"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder replication(Map<String, ? extends String> entries) {
            this.replication.clear();
            return this.putAllReplication(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllReplication(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.replication.put(Objects.requireNonNull(k, "replication key"), Objects.requireNonNull(v, "replication value"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder durableWrites(boolean durableWrites) {
            this.durableWrites = durableWrites;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder durableWrites(Optional<Boolean> durableWrites) {
            this.durableWrites = durableWrites.orElse(null);
            return this;
        }

        public ImmutableKeyspace build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeyspace(this.name, ImmutableKeyspace.createUnmodifiableSet(this.tables), ImmutableKeyspace.createUnmodifiableList(true, this.userDefinedTypes), ImmutableKeyspace.createUnmodifiableMap(false, false, this.replication), this.durableWrites);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Keyspace, some of required attributes are not set " + attributes;
        }
    }
}

