/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ParameterizedType;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ParameterizedType.TupleType", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableTupleType
extends ParameterizedType.TupleType {
    private final List<Column.ColumnType> parameters;
    private final int schemaHashCode;
    private final int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long PARAMETER_MAP_LAZY_INIT_BIT = 1L;
    private transient Map<String, Column.ColumnType> parameterMap;

    private ImmutableTupleType(List<Column.ColumnType> parameters) {
        this.parameters = parameters;
        this.schemaHashCode = super.schemaHashCode();
        this.hashCode = this.computeHashCode();
    }

    @Override
    public List<Column.ColumnType> parameters() {
        return this.parameters;
    }

    @Override
    public int schemaHashCode() {
        return this.schemaHashCode;
    }

    public final ImmutableTupleType withParameters(Column.ColumnType ... elements) {
        List<Column.ColumnType> newValue = ImmutableTupleType.createUnmodifiableList(false, ImmutableTupleType.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableTupleType(newValue);
    }

    public final ImmutableTupleType withParameters(Iterable<? extends Column.ColumnType> elements) {
        if (this.parameters == elements) {
            return this;
        }
        List<Column.ColumnType> newValue = ImmutableTupleType.createUnmodifiableList(false, ImmutableTupleType.createSafeList(elements, true, false));
        return new ImmutableTupleType(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTupleType && this.equalTo((ImmutableTupleType)another);
    }

    private boolean equalTo(ImmutableTupleType another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.parameters.equals(another.parameters);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.parameters.hashCode();
        return h;
    }

    public String toString() {
        return "TupleType{parameters=" + this.parameters + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Column.ColumnType> parameterMap() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableTupleType immutableTupleType = this;
            synchronized (immutableTupleType) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.parameterMap = Objects.requireNonNull(super.parameterMap(), "parameterMap");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.parameterMap;
    }

    public static ImmutableTupleType copyOf(ParameterizedType.TupleType instance) {
        if (instance instanceof ImmutableTupleType) {
            return (ImmutableTupleType)instance;
        }
        return ImmutableTupleType.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return new ImmutableTupleType(this.parameters);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ParameterizedType.TupleType", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends ParameterizedType.TupleType.Builder {
        private List<Column.ColumnType> parameters = new ArrayList<Column.ColumnType>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Column.ColumnType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ParameterizedType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ParameterizedType.TupleType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Column.ColumnType instance;
            long bits = 0L;
            if (object instanceof Column.ColumnType) {
                instance = (Column.ColumnType)object;
                if ((bits & 1L) == 0L) {
                    this.addAllParameters(instance.parameters());
                    bits |= 1L;
                }
            }
            if (object instanceof ParameterizedType) {
                instance = (ParameterizedType)object;
                if ((bits & 1L) == 0L) {
                    this.addAllParameters(((ParameterizedType)instance).parameters());
                    bits |= 1L;
                }
            }
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addParameters(Column.ColumnType element) {
            this.parameters.add(Objects.requireNonNull(element, "parameters element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParameters(Column.ColumnType ... elements) {
            for (Column.ColumnType element : elements) {
                this.parameters.add(Objects.requireNonNull(element, "parameters element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parameters(Iterable<? extends Column.ColumnType> elements) {
            this.parameters.clear();
            return this.addAllParameters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllParameters(Iterable<? extends Column.ColumnType> elements) {
            for (Column.ColumnType columnType : elements) {
                this.parameters.add(Objects.requireNonNull(columnType, "parameters element"));
            }
            return this;
        }

        @Override
        public ImmutableTupleType build() {
            return new ImmutableTupleType(ImmutableTupleType.createUnmodifiableList(true, this.parameters));
        }
    }
}

