/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import io.stargate.db.schema.AbstractTable;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableKeyspace;
import io.stargate.db.schema.Index;
import io.stargate.db.schema.MaterializedView;
import io.stargate.db.schema.SchemaEntity;
import io.stargate.db.schema.SchemaHashable;
import io.stargate.db.schema.SecondaryIndex;
import io.stargate.db.schema.Table;
import io.stargate.db.schema.UserDefinedType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.javatuples.Pair;

@Value.Immutable(prehash=true)
public abstract class Keyspace
implements SchemaEntity {
    private static final long serialVersionUID = -337891773492616286L;

    public abstract Set<Table> tables();

    public abstract List<UserDefinedType> userDefinedTypes();

    public abstract Map<String, String> replication();

    public abstract Optional<Boolean> durableWrites();

    @Value.Lazy
    Map<String, Table> tableMap() {
        return this.tables().stream().collect(Collectors.toMap(SchemaEntity::name, Function.identity()));
    }

    public Table table(String name) {
        return this.tableMap().get(name);
    }

    @Value.Lazy
    Map<String, UserDefinedType> userDefinedTypeMap() {
        return this.userDefinedTypes().stream().collect(Collectors.toMap(Column.ColumnType::name, Function.identity()));
    }

    public UserDefinedType userDefinedType(String typeName) {
        return this.userDefinedTypeMap().get(typeName);
    }

    @Value.Lazy
    Map<String, MaterializedView> materializedViewMap() {
        return this.tables().stream().flatMap(t -> t.indexes().stream()).filter(i -> i instanceof MaterializedView).collect(Collectors.toMap(SchemaEntity::name, i -> (MaterializedView)i));
    }

    public MaterializedView materializedView(String name) {
        return this.materializedViewMap().get(name);
    }

    @Value.Lazy
    Map<String, SecondaryIndex> secondaryIndexMap() {
        return this.tables().stream().flatMap(t -> t.indexes().stream()).filter(i -> i instanceof SecondaryIndex).collect(Collectors.toMap(SchemaEntity::name, i -> (SecondaryIndex)i));
    }

    public SecondaryIndex secondaryIndex(String name) {
        return this.secondaryIndexMap().get(name);
    }

    @Value.Lazy
    Map<Index, Table> reverseIndexMap() {
        return this.tables().stream().flatMap(t -> t.indexes().stream().map(i -> new Pair<Table, Index>((Table)t, (Index)i))).collect(Collectors.toMap(Pair::getValue1, Pair::getValue0));
    }

    public Column getColumnFromTableOrIndex(String cf, String name) {
        Table table = this.table(cf);
        if (table != null) {
            Column c = table.column(name);
            if (c == null) {
                throw new IllegalArgumentException(String.format("%s does not contain the requested column %s", table, name));
            }
            return c;
        }
        MaterializedView mv = this.materializedView(cf);
        if (mv != null) {
            Column c = mv.column(name);
            if (c == null) {
                throw new IllegalArgumentException(String.format("materialized view %s does not contain the requested column %s", mv, name));
            }
            return c;
        }
        SecondaryIndex si = this.secondaryIndex(cf);
        if (si != null) {
            if (si.column().name().equals(name)) {
                return si.column();
            }
            throw new RuntimeException("Secondary index does not contain the requested column");
        }
        throw new RuntimeException("No table, MV, or secondary index matched the requested column");
    }

    public static Keyspace create(String name, Iterable<Table> tables, Iterable<UserDefinedType> userDefinedTypes, Map<String, String> replication, Optional<Boolean> durableWrites) {
        return ImmutableKeyspace.builder().name(name).addAllTables(tables).addAllUserDefinedTypes(userDefinedTypes).putAllReplication(replication).durableWrites(durableWrites).build();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Keyspace '").append(this.name()).append("'\n");
        this.tables().forEach(table -> builder.append("  ").append(table.toString()));
        return builder.toString();
    }

    public AbstractTable tableOrMaterializedView(String name) {
        Table table = this.table(name);
        if (table == null) {
            return this.materializedView(name);
        }
        return table;
    }

    @Override
    @Value.Derived
    @Value.Auxiliary
    public int schemaHashCode() {
        return SchemaHashable.combine(SchemaHashable.hashCode(this.name()), SchemaHashable.hash(this.tables()), SchemaHashable.hash(this.userDefinedTypes()), SchemaHashable.hashCode(this.replication()), SchemaHashable.hashCode(this.durableWrites()));
    }
}

