/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.internal.core.type.DefaultTupleType;
import com.datastax.oss.driver.internal.core.type.codec.ListCodec;
import com.datastax.oss.driver.internal.core.type.codec.MapCodec;
import com.datastax.oss.driver.internal.core.type.codec.SetCodec;
import com.datastax.oss.driver.internal.core.type.codec.TupleCodec;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableListType;
import io.stargate.db.schema.ImmutableMapType;
import io.stargate.db.schema.ImmutableSetType;
import io.stargate.db.schema.ImmutableTupleType;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.SchemaHashable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;

public abstract class ParameterizedType
implements Column.ColumnType {
    @Override
    public abstract List<Column.ColumnType> parameters();

    @Override
    public int id() {
        return this.rawType().id();
    }

    @Override
    public String name() {
        throw new UnsupportedOperationException("Parameterized types do not have a name");
    }

    @Override
    public String cqlDefinition() {
        String definition = this.rawType().cqlDefinition() + this.parameters().stream().map(p -> p.cqlDefinition()).collect(Collectors.joining(", ", "<", ">"));
        if (this.isFrozen()) {
            definition = "frozen<" + definition + ">";
        }
        return definition;
    }

    @Override
    public boolean isParameterized() {
        return true;
    }

    @Override
    public Class<?> javaType() {
        return this.rawType().javaType();
    }

    protected abstract ParameterizedType withIsFrozen(boolean var1);

    @Override
    public Column.ColumnType frozen(boolean frozen) {
        return this.withIsFrozen(frozen);
    }

    @Value.Immutable(prehash=true)
    public static abstract class TupleType
    extends ParameterizedType {
        @Override
        public Object validate(Object value, String location) throws Column.ValidationException {
            if (null != (value = super.validate(value, location))) {
                TupleValue tupleValue = (TupleValue)value;
                for (int count = 0; count < this.parameters().size(); ++count) {
                    Object o;
                    Column.ColumnType type = this.parameters().get(count);
                    DataType dataType = tupleValue.getType().getComponentTypes().get(count);
                    String fieldLocation = location + "." + this.cqlDefinition() + "[" + count + "]";
                    boolean compatible = type.codec().accepts(dataType);
                    if (type.isComplexType() || !compatible) {
                        o = tupleValue.getObject(count);
                    } else {
                        try {
                            o = tupleValue.get(count, type.codec());
                        }
                        catch (RuntimeException e) {
                            throw new Column.ValidationException(this, fieldLocation);
                        }
                    }
                    Object validated = type.validate(o, fieldLocation);
                    tupleValue = (TupleValue)tupleValue.set(count, validated, type.codec());
                }
            }
            return value;
        }

        @Override
        public boolean isFrozen() {
            return true;
        }

        public TupleValue create(Object ... parameters) {
            return this.populate(this.cqlDataType().newValue(), parameters);
        }

        public TupleValue populate(TupleValue tuple, Object[] parameters) {
            try {
                for (int count = 0; count < parameters.length; ++count) {
                    Column.ColumnType columnType = this.parameters().get(count);
                    Object validated = columnType.validate(parameters[count], "[" + count + "]");
                    tuple = (TupleValue)tuple.set(count, validated, columnType.codec());
                }
            }
            catch (Column.ValidationException e) {
                throw new IllegalArgumentException(String.format("Wrong value type provided for tuple '%s'. Provided type '%s' is not compatible with expected CQL type '%s' at location '%s'.", this.cqlDefinition(), e.providedType(), e.expectedCqlType(), e.location()));
            }
            return tuple;
        }

        @Override
        public TypeCodec codec() {
            return new TupleCodec(this.cqlDataType());
        }

        private com.datastax.oss.driver.api.core.type.TupleType cqlDataType() {
            return new DefaultTupleType(this.parameters().stream().map(p -> p.codec().getCqlType()).collect(Collectors.toList()), CUSTOM_ATTACHMENT_POINT);
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public Column.Type rawType() {
            return Column.Type.Tuple;
        }

        @Override
        public Column.ColumnType dereference(Keyspace keyspace) {
            return ImmutableTupleType.copyOf(this).withParameters(this.parameters().stream().map(t -> t.dereference(keyspace)).collect(Collectors.toList()));
        }

        @Override
        public String cqlDefinition() {
            String definition = this.rawType().cqlDefinition() + this.parameters().stream().map(p -> p.cqlDefinition()).collect(Collectors.joining(", ", "<", ">"));
            if (this.isFrozen()) {
                definition = "frozen<" + definition + ">";
            }
            return definition;
        }

        @Override
        public boolean isTuple() {
            return true;
        }

        @Override
        protected TupleType withIsFrozen(boolean value) {
            return this;
        }

        @Value.Lazy
        public Map<String, Column.ColumnType> parameterMap() {
            int count = 1;
            HashMap<String, Column.ColumnType> parameterMap = new HashMap<String, Column.ColumnType>();
            for (Column.ColumnType parameter : this.parameters()) {
                parameterMap.put("field" + count++, parameter);
            }
            return parameterMap;
        }

        @Override
        public Column.ColumnType fieldType(String name) {
            Column.ColumnType parameterType = this.parameterMap().get(name);
            Preconditions.checkArgument(null != parameterType, "Tuple type '%s' does not have field '%s'", (Object)this.cqlDefinition(), (Object)name);
            return parameterType;
        }

        @Override
        @Value.Derived
        @Value.Auxiliary
        public int schemaHashCode() {
            return SchemaHashable.hash(this.parameters());
        }

        public static abstract class Builder
        implements io.stargate.db.schema.ParameterizedType$Builder {
        }
    }

    @Value.Immutable(prehash=true)
    public static abstract class MapType
    extends ParameterizedType {
        @Override
        public Object validate(Object value, String location) throws Column.ValidationException {
            if ((value = super.validate(value, location)) != null) {
                Map<Object, Object> validated;
                Map map = (Map)value;
                try {
                    validated = (Map)map.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    validated = new HashMap(map.size());
                }
                Column.ColumnType keyType = this.parameters().get(0);
                Column.ColumnType valueType = this.parameters().get(1);
                for (Map.Entry o : map.entrySet()) {
                    Object key = keyType.validate(o.getKey(), this.cqlDefinition() + "[key]");
                    Object val = valueType.validate(o.getValue(), this.cqlDefinition() + "[value]");
                    validated.put(key, val);
                }
                return validated;
            }
            return value;
        }

        public Map<?, ?> create(Object ... args) {
            Preconditions.checkArgument(null != args, "Your arguments were null. If you want to create an empty map, just call .create() with no parameters.");
            Preconditions.checkArgument(args.length % 2 == 0, "Please provide an even number of parameters. These are interpreted as key/value pairs to the map.");
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
            for (int i = 0; i < args.length; i += 2) {
                int j = i + 1;
                map.put(args[i], args[j]);
            }
            return map;
        }

        @Override
        public TypeCodec codec() {
            TypeCodec keyCodec = this.parameters().get(0).codec();
            TypeCodec valueCodec = this.parameters().get(1).codec();
            return new MapCodec(DataTypes.mapOf(keyCodec.getCqlType(), valueCodec.getCqlType(), this.isFrozen()), keyCodec, valueCodec);
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public boolean isMap() {
            return true;
        }

        @Override
        public Column.Type rawType() {
            return Column.Type.Map;
        }

        @Override
        public Column.ColumnType dereference(Keyspace keyspace) {
            return ImmutableMapType.copyOf(this).withParameters(this.parameters().stream().map(t -> t.dereference(keyspace)).collect(Collectors.toList()));
        }

        @Override
        public Column.ColumnType fieldType(String name) {
            throw new UnsupportedOperationException("Map type does not support nested access");
        }

        @Override
        @Value.Derived
        @Value.Auxiliary
        public int schemaHashCode() {
            return SchemaHashable.combine(SchemaHashable.hashCode(this.isFrozen()), SchemaHashable.hashCode(this.parameters()));
        }

        public static abstract class Builder
        implements io.stargate.db.schema.ParameterizedType$Builder {
        }
    }

    @Value.Immutable(prehash=true)
    public static abstract class SetType
    extends ParameterizedType {
        @Override
        public Object validate(Object value, String location) throws Column.ValidationException {
            if ((value = super.validate(value, location)) != null) {
                Collection<Object> validated;
                Set set = (Set)value;
                try {
                    validated = (Collection)set.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    validated = new HashSet(set.size());
                }
                Column.ColumnType type = this.parameters().get(0);
                for (Object o : set) {
                    Object validatedValue = type.validate(o, this.cqlDefinition());
                    validated.add(validatedValue);
                }
                return validated;
            }
            return value;
        }

        public Set<?> create(Object ... entries) {
            return new LinkedHashSet<Object>(Arrays.asList(entries));
        }

        @Override
        public TypeCodec codec() {
            TypeCodec elementCodec = this.parameters().get(0).codec();
            return new SetCodec(DataTypes.setOf(elementCodec.getCqlType(), this.isFrozen()), elementCodec);
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public boolean isSet() {
            return true;
        }

        @Override
        public Column.Type rawType() {
            return Column.Type.Set;
        }

        @Override
        public Column.ColumnType dereference(Keyspace keyspace) {
            return ImmutableSetType.copyOf(this).withParameters(this.parameters().stream().map(t -> t.dereference(keyspace)).collect(Collectors.toList()));
        }

        @Override
        public Column.ColumnType fieldType(String name) {
            return this.parameters().get(0);
        }

        @Override
        @Value.Derived
        @Value.Auxiliary
        public int schemaHashCode() {
            return SchemaHashable.combine(SchemaHashable.hashCode(this.isFrozen()), SchemaHashable.hashCode(this.parameters()));
        }

        public static abstract class Builder
        implements io.stargate.db.schema.ParameterizedType$Builder {
        }
    }

    @Value.Immutable(prehash=true)
    public static abstract class ListType
    extends ParameterizedType {
        @Override
        public Object validate(Object value, String location) throws Column.ValidationException {
            if ((value = super.validate(value, location)) != null) {
                List list = (List)value;
                ArrayList<Object> validated = new ArrayList<Object>(list.size());
                Column.ColumnType type = this.parameters().get(0);
                for (Object o : list) {
                    Object validatedValue = type.validate(o, this.cqlDefinition());
                    validated.add(validatedValue);
                }
                return validated;
            }
            return value;
        }

        public List<?> create(Object ... entries) {
            return new ArrayList<Object>(Arrays.asList(entries));
        }

        @Override
        public TypeCodec codec() {
            TypeCodec elementCodec = this.parameters().get(0).codec();
            return new ListCodec(DataTypes.listOf(elementCodec.getCqlType(), this.isFrozen()), elementCodec);
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public boolean isList() {
            return true;
        }

        @Override
        public Column.Type rawType() {
            return Column.Type.List;
        }

        @Override
        public Column.ColumnType dereference(Keyspace keyspace) {
            return ImmutableListType.copyOf(this).withParameters(this.parameters().stream().map(t -> t.dereference(keyspace)).collect(Collectors.toList()));
        }

        @Override
        public Column.ColumnType fieldType(String name) {
            return this.parameters().get(0);
        }

        @Override
        @Value.Derived
        @Value.Auxiliary
        public int schemaHashCode() {
            return SchemaHashable.combine(SchemaHashable.hashCode(this.isFrozen()), SchemaHashable.hashCode(this.parameters()));
        }

        public static abstract class Builder
        implements io.stargate.db.schema.ParameterizedType$Builder {
        }
    }

    public static interface Builder {
        public Builder addParameters(Column.ColumnType var1);

        public ParameterizedType build();
    }
}

