/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import io.stargate.db.schema.ImmutableKeyspace;
import io.stargate.db.schema.ImmutableSchema;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.SchemaBuilder;
import io.stargate.db.schema.SchemaEntity;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable(prehash=true)
public abstract class Schema {
    private static final Keyspace ANONYMOUS = ImmutableKeyspace.builder().name("<anonymous>").build();

    public abstract Set<Keyspace> keyspaces();

    @Value.Lazy
    Map<String, Keyspace> keyspaceMap() {
        return this.keyspaces().stream().collect(Collectors.toMap(SchemaEntity::name, Function.identity()));
    }

    public Keyspace keyspace(String name) {
        if (name == null) {
            return ANONYMOUS;
        }
        return this.keyspaceMap().get(name);
    }

    public List<String> keyspaceNames() {
        return this.keyspaces().stream().map(k -> k.name()).sorted().collect(Collectors.toList());
    }

    public static Schema create(Iterable<Keyspace> keyspaces) {
        return ImmutableSchema.builder().addAllKeyspaces(keyspaces).build();
    }

    public static SchemaBuilder build() {
        return new SchemaBuilder(Optional.empty());
    }

    public static SchemaBuilder build(Consumer<Schema> callback) {
        return new SchemaBuilder(Optional.of(callback));
    }

    public String toString() {
        return this.keyspaces().stream().map(Keyspace::toString).collect(Collectors.joining("\n"));
    }
}

